/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.distribution.Collector;
import org.infinispan.interceptors.distribution.PrimaryOwnerOnlyCollector;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class CommandAckCollector {
    private static final Log log = LogFactory.getLog(CommandAckCollector.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    @ComponentName(value="org.infinispan.executors.timeout")
    private ScheduledExecutorService timeoutExecutor;
    @Inject
    private Configuration configuration;
    private final ConcurrentHashMap<Long, BaseAckTarget> collectorMap = new ConcurrentHashMap();
    private long timeoutNanoSeconds;
    private Collection<Address> currentMembers;

    @Start
    public void start() {
        this.timeoutNanoSeconds = TimeUnit.MILLISECONDS.toNanos(this.configuration.clustering().remoteTimeout());
    }

    public <T> Collector<T> create(long id, Collection<Address> backupOwners, int topologyId) {
        if (backupOwners.isEmpty()) {
            return new PrimaryOwnerOnlyCollector();
        }
        SingleKeyCollector collector = new SingleKeyCollector(id, backupOwners, topologyId);
        BaseAckTarget prev = this.collectorMap.put(id, collector);
        assert (prev == null || prev.topologyId < topologyId) : String.format("replaced old collector '%s' by '%s'", prev, collector);
        if (trace) {
            log.tracef("Created new collector for %s. BackupOwners=%s", id, backupOwners);
        }
        return collector;
    }

    public <T> Collector<T> createBiased(long id, Address primaryOwner, int topologyId) {
        BiasedKeyCollector collector = new BiasedKeyCollector(id, primaryOwner, topologyId);
        BaseAckTarget prev = this.collectorMap.put(id, collector);
        assert (prev == null) : prev.toString();
        if (trace) {
            log.tracef("Created new biased collector for %s, primary is %s", id, primaryOwner);
        }
        return collector;
    }

    public Collector<Response> createMultiTargetCollector(long id, Address target, int topologyId) {
        MultiAckTarget multiAckTarget = new MultiAckTarget(id, topologyId);
        BaseAckTarget prev = this.collectorMap.put(id, multiAckTarget);
        assert (prev == null) : prev.toString();
        if (trace) {
            log.tracef("Created new multi target collector for %s and primary %s", id, target);
        }
        return multiAckTarget.collectorFor(target);
    }

    public <T> Collector<T> createSegmentBasedCollector(long id, Map<Address, Collection<Integer>> backups, int topologyId) {
        if (backups.isEmpty()) {
            return new PrimaryOwnerOnlyCollector();
        }
        SegmentBasedCollector collector = new SegmentBasedCollector(id, backups, topologyId);
        BaseAckTarget prev = this.collectorMap.put(id, collector);
        assert (prev == null || prev.topologyId < topologyId) : String.format("replaced old collector '%s' by '%s'", prev, collector);
        if (trace) {
            log.tracef("Created new collector for %s. BackupSegments=%s", id, backups);
        }
        return collector;
    }

    public void multiKeyBackupAck(long id, Address from, int segment, int topologyId) {
        SegmentBasedCollector collector = (SegmentBasedCollector)this.collectorMap.get(id);
        if (collector != null) {
            collector.backupAck(from, segment, topologyId);
        }
    }

    public void backupAck(long id, Address from, int topologyId) {
        BaseAckTarget ackTarget = this.collectorMap.get(id);
        if (ackTarget instanceof SingleKeyCollector) {
            ((SingleKeyCollector)ackTarget).backupAck(topologyId, from);
        } else if (ackTarget instanceof MultiAckTarget) {
            ((MultiAckTarget)ackTarget).backupAck(topologyId, from);
        }
    }

    public void primaryAck(long id, Address from, Object value, boolean success, Address[] waitFor) {
        BaseAckTarget ackTarget = this.collectorMap.get(id);
        if (ackTarget == null) {
            if (trace) {
                log.tracef("No collector for %d", id);
            }
        } else if (ackTarget instanceof BiasedKeyCollector) {
            BiasedKeyCollector collector = (BiasedKeyCollector)ackTarget;
            collector.addPendingAcks(success, waitFor);
            collector.primaryResult(success ? SuccessfulResponse.create(value) : UnsuccessfulResponse.create(value), success);
        } else if (ackTarget instanceof MultiAckTarget) {
            MultiAckTarget multiAckTarget = (MultiAckTarget)ackTarget;
            if (success && waitFor != null) {
                multiAckTarget.addPendingAcks(waitFor);
            }
            multiAckTarget.primaryResult(from, value, success);
        } else {
            throw new IllegalStateException("Unexpected ack: " + ackTarget);
        }
    }

    public void completeExceptionally(long id, Throwable throwable, int topologyId) {
        BaseAckTarget ackTarget = this.collectorMap.get(id);
        if (ackTarget != null) {
            ackTarget.completeExceptionally(throwable, topologyId);
        }
    }

    public List<Long> getPendingCommands() {
        return new ArrayList<Long>(this.collectorMap.keySet());
    }

    public boolean hasPendingBackupAcks(long id) {
        BaseAckTarget ackTarget = this.collectorMap.get(id);
        return ackTarget != null && ackTarget.hasPendingBackupAcks();
    }

    public void onMembersChange(Collection<Address> members) {
        HashSet<Address> currentMembers = new HashSet<Address>(members);
        this.currentMembers = currentMembers;
        for (BaseAckTarget ackTarget : this.collectorMap.values()) {
            ackTarget.onMembersChange(currentMembers);
        }
    }

    private TimeoutException createTimeoutException(long id) {
        return log.timeoutWaitingForAcks(Util.prettyPrintTime((long)this.timeoutNanoSeconds, (TimeUnit)TimeUnit.NANOSECONDS), id);
    }

    private class MultiAckTarget
    extends BaseAckTarget {
        private final Map<Address, Collector<Response>> primaryCollectors;
        private final List<Address> pendingAcks;
        private final CompletableFuture<Void> acksFuture;
        private List<Address> unsolicitedAcks;
        private Throwable throwable;

        MultiAckTarget(long id, int topologyId) {
            super(id, topologyId);
            this.primaryCollectors = new HashMap<Address, Collector<Response>>();
            this.pendingAcks = new ArrayList<Address>();
            this.acksFuture = new CompletableFuture();
        }

        synchronized Collector<Response> collectorFor(Address target) {
            if (this.throwable != null) {
                return new ExceptionCollector<Response>(this.throwable);
            }
            CombiningCollector<Response> collector = new CombiningCollector<Response>(this.acksFuture);
            Collector prev = this.primaryCollectors.put(target, collector);
            assert (prev == null) : prev.toString();
            return collector;
        }

        synchronized void addPendingAcks(Address[] waitFor) {
            if (trace) {
                log.tracef("[Collector#%s] Adding pending acks from %s, existing are %s", this.id, Arrays.toString(waitFor), this.pendingAcks);
            }
            Collection members = CommandAckCollector.this.currentMembers;
            for (Address member : waitFor) {
                if (members != null && !members.contains(member)) continue;
                this.pendingAcks.add(member);
            }
        }

        synchronized void primaryResult(Address from, Object value, boolean success) {
            Collector<Response> collector = this.primaryCollectors.get(from);
            if (trace) {
                log.tracef("[Collector#%s] PutMap Primary ACK. Address=%s", this.id, from);
            }
            collector.primaryResult(success ? SuccessfulResponse.create(value) : UnsuccessfulResponse.create(value), success);
            if (this.unsolicitedAcks != null) {
                this.unsolicitedAcks.removeIf(this.pendingAcks::remove);
            }
            if (this.pendingAcks.isEmpty()) {
                this.acksFuture.complete(null);
            }
        }

        synchronized void backupAck(int topologyId, Address from) {
            if (trace) {
                log.tracef("[Collector#%s] PutMap Backup ACK. Address=%s. TopologyId=%s (expected=%s).", new Object[]{this.id, from, topologyId, this.topologyId});
            }
            if (topologyId == this.topologyId && !this.pendingAcks.remove(from)) {
                if (this.unsolicitedAcks == null) {
                    this.unsolicitedAcks = new ArrayList<Address>(4);
                }
                this.unsolicitedAcks.add(from);
            }
        }

        @Override
        synchronized void completeExceptionally(Throwable throwable, int topologyId) {
            if (topologyId == this.topologyId) {
                this.throwable = throwable;
                for (Collector<Response> collector : this.primaryCollectors.values()) {
                    collector.primaryException(throwable);
                }
            }
        }

        @Override
        synchronized boolean hasPendingBackupAcks() {
            return !this.pendingAcks.isEmpty();
        }

        @Override
        synchronized void onMembersChange(Collection<Address> members) {
            this.pendingAcks.retainAll(members);
            for (Map.Entry<Address, Collector<Response>> pair : this.primaryCollectors.entrySet()) {
                if (members.contains(pair.getKey())) continue;
                pair.getValue().primaryException((Throwable)((Object)OutdatedTopologyException.INSTANCE));
            }
        }

        @Override
        public Void call() {
            this.completeExceptionally((Throwable)((Object)CommandAckCollector.this.createTimeoutException(this.id)), this.topologyId);
            return null;
        }
    }

    private static class CombiningCollector<T>
    implements Collector<T>,
    Function<Void, CompletableFuture<T>> {
        private final CompletableFuture<T> resultFuture = new CompletableFuture();
        private final CompletableFuture<T> combinedFuture;

        private CombiningCollector(CompletableFuture<?> acksFuture) {
            this.combinedFuture = CompletableFuture.allOf(this.resultFuture, acksFuture).thenCompose((Function)this);
        }

        @Override
        public CompletableFuture<T> getFuture() {
            return this.combinedFuture;
        }

        @Override
        public void primaryException(Throwable throwable) {
            this.combinedFuture.completeExceptionally(throwable);
        }

        @Override
        public void primaryResult(T result, boolean success) {
            this.resultFuture.complete(result);
        }

        @Override
        public CompletableFuture<T> apply(Void nil) {
            return this.resultFuture;
        }
    }

    private static class ExceptionCollector<T>
    extends CompletableFuture<T>
    implements Collector<T> {
        ExceptionCollector(Throwable throwable) {
            this.completeExceptionally(throwable);
        }

        @Override
        public CompletableFuture<T> getFuture() {
            return this;
        }

        @Override
        public void primaryException(Throwable throwable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void primaryResult(T result, boolean success) {
            throw new UnsupportedOperationException();
        }
    }

    private class SegmentBasedCollector<T>
    extends BaseCollector<T> {
        @GuardedBy(value="this")
        private final Map<Address, Collection<Integer>> backups;

        SegmentBasedCollector(long id, Map<Address, Collection<Integer>> backups, int topologyId) {
            super(id, topologyId);
            this.backups = backups;
        }

        @Override
        public synchronized boolean hasPendingBackupAcks() {
            return !this.backups.isEmpty();
        }

        @Override
        public synchronized void onMembersChange(Collection<Address> members) {
            if (this.backups.keySet().retainAll(members)) {
                if (trace) {
                    log.tracef("[Collector#%s] Some backups left the cluster.", this.id);
                }
                this.checkCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void primaryResult(T result, boolean success) {
            this.primaryResult = result;
            this.primaryResultReceived = true;
            SegmentBasedCollector segmentBasedCollector = this;
            synchronized (segmentBasedCollector) {
                this.checkCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void backupAck(Address from, int segment, int topologyId) {
            if (trace) {
                log.tracef("[Collector#%s] PutMap Backup ACK. Address=%s. TopologyId=%s (expected=%s). Segment=%s", new Object[]{this.id, from, topologyId, this.topologyId, segment});
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            SegmentBasedCollector segmentBasedCollector = this;
            synchronized (segmentBasedCollector) {
                Collection pendingSegments = this.backups.getOrDefault(from, Collections.emptyList());
                if (pendingSegments.remove(segment) && pendingSegments.isEmpty()) {
                    this.backups.remove(from);
                }
                this.checkCompleted();
            }
        }

        @GuardedBy(value="this")
        private void checkCompleted() {
            if (this.primaryResultReceived && this.backups.isEmpty()) {
                if (trace) {
                    log.tracef("[Collector#%s] Ready! Return value=%ss.", this.id, this.primaryResult);
                }
                this.future.complete(this.primaryResult);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SegmentBasedCollector{");
            sb.append("id=").append(this.id);
            sb.append(", topologyId=").append(this.topologyId);
            sb.append(", primaryResult=").append(this.primaryResult);
            sb.append(", primaryResultReceived=").append(this.primaryResultReceived);
            sb.append(", backups=").append(this.backups);
            sb.append('}');
            return sb.toString();
        }
    }

    private class BiasedKeyCollector<T>
    extends SingleKeyCollector<T> {
        private final Address primaryOwner;
        private Collection<Address> unsolicitedAcks;

        private BiasedKeyCollector(long id, Address primaryOwner, int topologyId) {
            super(id, Collections.emptyList(), topologyId);
            this.primaryOwner = primaryOwner;
        }

        @Override
        public void onMembersChange(Collection<Address> members) {
            if (this.primaryOwner != null && !members.contains(this.primaryOwner)) {
                this.future.completeExceptionally((Throwable)((Object)log.remoteNodeSuspected(this.primaryOwner)));
            }
            super.onMembersChange(members);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void backupAck(int topologyId, Address from) {
            boolean empty;
            if (trace) {
                log.tracef("[Collector#%s] Backup ACK. Address=%s, TopologyId=%s (expected=%s)", new Object[]{this.id, from, topologyId, this.topologyId});
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            BiasedKeyCollector biasedKeyCollector = this;
            synchronized (biasedKeyCollector) {
                if (!this.backupOwners.remove(from)) {
                    if (this.unsolicitedAcks == null) {
                        this.unsolicitedAcks = new ArrayList<Address>(4);
                    }
                    log.tracef("[Collector#%s] Unsolicited ACK", this.id);
                    this.unsolicitedAcks.add(from);
                }
                empty = this.backupOwners.isEmpty();
            }
            if (empty && this.primaryResultReceived) {
                this.markReady();
            }
        }

        synchronized void addPendingAcks(boolean success, Address[] waitFor) {
            if (success && waitFor != null) {
                Collection members = CommandAckCollector.this.currentMembers;
                for (Address address : waitFor) {
                    if (members != null && !members.contains(address)) continue;
                    this.backupOwners.add(address);
                }
            }
            if (this.unsolicitedAcks != null) {
                this.unsolicitedAcks.removeIf(this.backupOwners::remove);
            }
        }
    }

    private class SingleKeyCollector<T>
    extends BaseCollector<T> {
        final Collection<Address> backupOwners;

        private SingleKeyCollector(long id, Collection<Address> backupOwners, int topologyId) {
            super(id, topologyId);
            this.backupOwners = new HashSet<Address>(backupOwners);
        }

        @Override
        synchronized boolean hasPendingBackupAcks() {
            return !this.backupOwners.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void onMembersChange(Collection<Address> members) {
            boolean empty;
            SingleKeyCollector singleKeyCollector = this;
            synchronized (singleKeyCollector) {
                empty = this.backupOwners.retainAll(members) && this.backupOwners.isEmpty();
            }
            if (empty && this.primaryResultReceived) {
                if (trace) {
                    log.tracef("[Collector#%s] Some backups left the cluster.", this.id);
                }
                this.markReady();
            }
        }

        @Override
        public void primaryResult(T result, boolean success) {
            this.primaryResult = result;
            this.primaryResultReceived = true;
            if (!success || !this.hasPendingBackupAcks()) {
                this.markReady();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void backupAck(int topologyId, Address from) {
            boolean empty;
            if (trace) {
                log.tracef("[Collector#%s] Backup ACK. Address=%s, TopologyId=%s (expected=%s)", new Object[]{this.id, from, topologyId, this.topologyId});
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            SingleKeyCollector singleKeyCollector = this;
            synchronized (singleKeyCollector) {
                empty = this.backupOwners.remove(from) && this.backupOwners.isEmpty();
            }
            if (empty && this.primaryResultReceived) {
                this.markReady();
            }
        }

        void markReady() {
            if (trace) {
                log.tracef("[Collector#%s] Ready!", this.id);
            }
            this.future.complete(this.primaryResult);
        }
    }

    private abstract class BaseCollector<T>
    extends BaseAckTarget
    implements BiConsumer<T, Throwable>,
    Collector<T> {
        final CompletableFuture<T> future;
        final CompletableFuture<T> exposedFuture;
        volatile T primaryResult;
        volatile boolean primaryResultReceived;

        BaseCollector(long id, int topologyId) {
            super(id, topologyId);
            this.primaryResultReceived = false;
            this.future = new CompletableFuture();
            this.exposedFuture = this.future.whenComplete((BiConsumer)this);
        }

        @Override
        public final synchronized Void call() {
            this.future.completeExceptionally((Throwable)((Object)CommandAckCollector.this.createTimeoutException(this.id)));
            return null;
        }

        @Override
        public final void accept(T t, Throwable throwable) {
            if (trace) {
                log.tracef("[Collector#%s] Collector completed with ret=%s, throw=%s", this.id, t, throwable);
            }
            boolean removed = CommandAckCollector.this.collectorMap.remove(this.id, this);
            assert (removed);
            this.timeoutTask.cancel(false);
        }

        @Override
        public final CompletableFuture<T> getFuture() {
            return this.exposedFuture;
        }

        @Override
        public void primaryException(Throwable throwable) {
            this.future.completeExceptionally(throwable);
        }

        @Override
        final void completeExceptionally(Throwable throwable, int topologyId) {
            if (trace) {
                log.tracef(throwable, "[Collector#%s] completed exceptionally. TopologyId=%s (expected=%s)", this.id, topologyId, this.topologyId);
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            this.future.completeExceptionally(throwable);
        }

        final boolean isWrongTopologyOrIsDone(int topologyId) {
            return this.topologyId != topologyId || this.future.isDone();
        }
    }

    private abstract class BaseAckTarget
    implements Callable<Void> {
        final long id;
        final int topologyId;
        final ScheduledFuture<?> timeoutTask;

        private BaseAckTarget(long id, int topologyId) {
            this.topologyId = topologyId;
            this.id = id;
            this.timeoutTask = CommandAckCollector.this.timeoutExecutor.schedule(this, CommandAckCollector.this.timeoutNanoSeconds, TimeUnit.NANOSECONDS);
        }

        abstract void completeExceptionally(Throwable var1, int var2);

        abstract boolean hasPendingBackupAcks();

        abstract void onMembersChange(Collection<Address> var1);
    }
}

