/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerStartHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "start";
    private static final AttributeDefinition SERVER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setDeprecated(ModelVersion.create((int)1, (int)0, (int)4))).build();
    private static final AttributeDefinition BLOCKING = new SimpleAttributeDefinitionBuilder("blocking", ModelType.BOOLEAN, true).build();
    static final AttributeDefinition START_MODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"start-mode", (ModelType)ModelType.STRING, (boolean)true).setDefaultValue(new ModelNode(StartMode.NORMAL.toString()))).setValidator((ParameterValidator)new EnumValidator(StartMode.class, true, true))).build();
    public static final OperationDefinition DEFINITION = ServerStartHandler.getOperationDefinition("start", START_MODE);
    private final ServerInventory serverInventory;

    static OperationDefinition getOperationDefinition(String name, AttributeDefinition ... additional) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder(name, HostResolver.getResolver("host.server")).setParameters(new AttributeDefinition[]{SERVER, BLOCKING}).setReplyType(ModelType.STRING).setRuntimeOnly().withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY);
        for (AttributeDefinition param : additional) {
            builder.addParameter(param);
        }
        return builder.build();
    }

    public ServerStartHandler(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getRunningMode() == RunningMode.ADMIN_ONLY) {
            throw new OperationFailedException(HostControllerLogger.ROOT_LOGGER.cannotStartServersInvalidMode(context.getRunningMode()));
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement element = address.getLastElement();
        final String serverName = element.getValue();
        final boolean blocking = operation.get("blocking").asBoolean(false);
        final boolean suspend = START_MODE.resolveModelAttribute(context, operation).asString().toLowerCase(Locale.ENGLISH).equals(StartMode.SUSPEND.toString());
        final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.getServiceRegistry(true);
                final ServerStatus origStatus = ServerStartHandler.this.serverInventory.determineServerStatus(serverName);
                if (origStatus != ServerStatus.STARTED && origStatus != ServerStatus.STARTING) {
                    ServerStatus status = ServerStartHandler.this.serverInventory.startServer(serverName, model, blocking, suspend);
                    this.persistAutoStart(context);
                    context.getResult().set(status.toString());
                } else {
                    context.getResult().set(origStatus.toString());
                }
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                        if (origStatus != ServerStatus.STARTED && origStatus != ServerStatus.STARTING) {
                            ServerStartHandler.this.serverInventory.stopServer(serverName, -1);
                            this.persistAutoStart(context);
                        }
                    }
                });
            }

            private void persistAutoStart(OperationContext context) {
                context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel();
            }
        }, OperationContext.Stage.RUNTIME);
    }

    static enum StartMode {
        NORMAL("normal"),
        SUSPEND("suspend");

        private final String localName;

        private StartMode(String localName) {
            this.localName = localName;
        }

        public String toString() {
            return this.localName;
        }
    }
}

