/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra.inflow;

import java.util.HashMap;
import java.util.UUID;
import javax.jms.IllegalStateException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivation;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.apache.activemq.artemis.service.extensions.ServiceUtils;
import org.apache.activemq.artemis.service.extensions.xa.ActiveMQXAResourceWrapper;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.VersionLoader;

public class ActiveMQMessageHandler
implements MessageHandler,
FailoverEventListener {
    private static boolean trace = ActiveMQRALogger.LOGGER.isTraceEnabled();
    private final ClientSessionInternal session;
    private ClientConsumerInternal consumer;
    private MessageEndpoint endpoint;
    private final ConnectionFactoryOptions options;
    private final ActiveMQActivation activation;
    private boolean useLocalTx;
    private boolean transacted;
    private boolean useXA = false;
    private final int sessionNr;
    private final TransactionManager tm;
    private ClientSessionFactory cf;
    private volatile boolean connected;

    public ActiveMQMessageHandler(ConnectionFactoryOptions options, ActiveMQActivation activation, TransactionManager tm, ClientSessionInternal session, ClientSessionFactory cf, int sessionNr) {
        this.options = options;
        this.activation = activation;
        this.session = session;
        this.cf = cf;
        this.sessionNr = sessionNr;
        this.tm = tm;
    }

    public void setup() throws Exception {
        ActiveMQActivationSpec spec;
        String selector;
        SimpleString selectorString;
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setup()");
        }
        SimpleString simpleString = selectorString = (selector = (spec = this.activation.getActivationSpec()).getMessageSelector()) == null || selector.trim().equals("") ? null : new SimpleString(selector);
        if (this.activation.isTopic() && spec.isSubscriptionDurable().booleanValue()) {
            SimpleString queueName = new SimpleString(ActiveMQDestination.createQueueNameForDurableSubscription((boolean)true, (String)spec.getClientID(), (String)spec.getSubscriptionName()));
            ClientSession.QueueQuery subResponse = this.session.queueQuery(queueName);
            if (!subResponse.isExists()) {
                this.session.createQueue(this.activation.getAddress(), queueName, selectorString, true);
            } else {
                boolean topicChanged;
                if (this.sessionNr == 0 && subResponse.getConsumerCount() > 0) {
                    if (!spec.isShareSubscriptions().booleanValue()) {
                        throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
                    }
                    if (ActiveMQRALogger.LOGGER.isDebugEnabled()) {
                        ActiveMQRALogger.LOGGER.debug("the mdb on destination " + queueName + " already had " + subResponse.getConsumerCount() + " consumers but the MDB is configured to share subscriptions, so no exceptions are thrown");
                    }
                }
                SimpleString oldFilterString = subResponse.getFilterString();
                boolean selectorChanged = selector == null && oldFilterString != null || oldFilterString == null && selector != null || oldFilterString != null && selector != null && !oldFilterString.toString().equals(selector);
                SimpleString oldTopicName = subResponse.getAddress();
                boolean bl = topicChanged = !oldTopicName.equals((Object)this.activation.getAddress());
                if (selectorChanged || topicChanged) {
                    this.session.deleteQueue(queueName);
                    this.session.createQueue(this.activation.getAddress(), queueName, selectorString, true);
                }
            }
            this.consumer = (ClientConsumerInternal)this.session.createConsumer(queueName, null, false);
        } else {
            SimpleString tempQueueName;
            if (this.activation.isTopic()) {
                if (this.activation.getTopicTemporaryQueue() == null) {
                    tempQueueName = new SimpleString(UUID.randomUUID().toString());
                    this.session.createTemporaryQueue(this.activation.getAddress(), tempQueueName, selectorString);
                    this.activation.setTopicTemporaryQueue(tempQueueName);
                } else {
                    tempQueueName = this.activation.getTopicTemporaryQueue();
                    ClientSession.QueueQuery queueQuery = this.session.queueQuery(tempQueueName);
                    if (!queueQuery.isExists()) {
                        this.session.createTemporaryQueue(this.activation.getAddress(), tempQueueName, selectorString);
                    }
                }
            } else {
                tempQueueName = this.activation.getAddress();
            }
            this.consumer = (ClientConsumerInternal)this.session.createConsumer(tempQueueName, selectorString);
        }
        MessageEndpointFactory endpointFactory = this.activation.getMessageEndpointFactory();
        this.useLocalTx = !this.activation.isDeliveryTransacted() && this.activation.getActivationSpec().isUseLocalTx() != false;
        this.transacted = this.activation.isDeliveryTransacted();
        if (this.activation.isDeliveryTransacted() && !this.activation.getActivationSpec().isUseLocalTx().booleanValue()) {
            HashMap<String, String> xaResourceProperties = new HashMap<String, String>();
            xaResourceProperties.put("ACTIVEMQ_JNDI_ID", ((ActiveMQResourceAdapter)spec.getResourceAdapter()).getJndiName());
            xaResourceProperties.put("ACTIVEMQ_NODE_ID", ((ClientSessionFactoryInternal)this.cf).getLiveNodeId());
            xaResourceProperties.put("ACTIVEMQ_PRODUCT_NAME", "ActiveMQ Artemis");
            xaResourceProperties.put("ACTIVEMQ_PRODUCT_VERSION", VersionLoader.getVersion().getFullVersion());
            ActiveMQXAResourceWrapper xaResource = ServiceUtils.wrapXAResource((XAResource)this.session, xaResourceProperties);
            this.endpoint = endpointFactory.createEndpoint((XAResource)xaResource);
            this.useXA = true;
        } else {
            this.endpoint = endpointFactory.createEndpoint(null);
            this.useXA = false;
        }
        this.connected = true;
        this.session.addFailoverListener((FailoverEventListener)this);
        this.consumer.setMessageHandler((MessageHandler)this);
    }

    XAResource getXAResource() {
        return this.useXA ? this.session : null;
    }

    public Thread interruptConsumer(FutureLatch future) {
        try {
            if (this.consumer != null) {
                return this.consumer.prepareForClose(future);
            }
        }
        catch (Throwable e) {
            ActiveMQRALogger.LOGGER.errorInterruptingHandler(this.endpoint.toString(), this.consumer.toString(), e);
        }
        return null;
    }

    public void teardown() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("teardown()");
        }
        try {
            if (this.endpoint != null) {
                this.endpoint.release();
                this.endpoint = null;
            }
        }
        catch (Throwable t) {
            ActiveMQRALogger.LOGGER.debug("Error releasing endpoint " + this.endpoint, t);
        }
        if (this.connected) {
            try {
                SimpleString tmpQueue;
                ClientSession.QueueQuery subResponse;
                this.consumer.close();
                if (this.activation.getTopicTemporaryQueue() != null && (subResponse = this.session.queueQuery(tmpQueue = this.activation.getTopicTemporaryQueue())).getConsumerCount() == 0) {
                    this.session.deleteQueue(tmpQueue);
                }
            }
            catch (Throwable t) {
                ActiveMQRALogger.LOGGER.debug("Error closing core-queue consumer", t);
            }
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Throwable t) {
                ActiveMQRALogger.LOGGER.debug("Error releasing session " + this.session, t);
            }
            try {
                if (this.cf != null) {
                    this.cf.close();
                }
            }
            catch (Throwable t) {
                ActiveMQRALogger.LOGGER.debug("Error releasing session factory " + this.session, t);
            }
        } else {
            try {
                if (this.cf != null) {
                    this.cf.cleanup();
                }
            }
            catch (Throwable t) {
                ActiveMQRALogger.LOGGER.debug("Error releasing session factory " + this.session, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ClientMessage message) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("onMessage(" + message + ")");
        }
        ActiveMQMessage msg = ActiveMQMessage.createMessage((ClientMessage)message, (ClientSession)this.session, (ConnectionFactoryOptions)this.options);
        boolean beforeDelivery = false;
        try {
            if (this.activation.getActivationSpec().getTransactionTimeout() > 0 && this.tm != null) {
                this.tm.setTransactionTimeout(this.activation.getActivationSpec().getTransactionTimeout().intValue());
            }
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("HornetQMessageHandler::calling beforeDelivery on message " + message);
            }
            this.endpoint.beforeDelivery(ActiveMQActivation.ONMESSAGE);
            beforeDelivery = true;
            msg.doBeforeReceive();
            if (this.transacted) {
                message.individualAcknowledge();
            }
            ((MessageListener)this.endpoint).onMessage((Message)msg);
            if (!this.transacted) {
                message.individualAcknowledge();
            }
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("HornetQMessageHandler::calling afterDelivery on message " + message);
            }
            try {
                this.endpoint.afterDelivery();
            }
            catch (ResourceException e) {
                ActiveMQRALogger.LOGGER.unableToCallAfterDelivery((Exception)((Object)e));
                this.session.markRollbackOnly();
                try {
                    this.session.resetIfNeeded();
                }
                catch (ActiveMQException e2) {
                    ActiveMQRALogger.LOGGER.unableToResetSession(this.activation.toString(), (Exception)((Object)e2));
                    this.activation.startReconnectThread("Reset MessageHandler after Failure Thread");
                }
                return;
            }
            if (this.useLocalTx) {
                this.session.commit();
            }
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("finished onMessage on " + message);
            }
        }
        catch (Throwable e) {
            ActiveMQRALogger.LOGGER.errorDeliveringMessage(e);
            if (beforeDelivery) {
                if (this.useXA && this.tm != null) {
                    try {
                        Transaction tx = this.tm.getTransaction();
                        if (tx != null) {
                            tx.setRollbackOnly();
                        }
                    }
                    catch (Exception e1) {
                        ActiveMQRALogger.LOGGER.warn("unnable to clear the transaction", e1);
                    }
                }
                MessageEndpoint endToUse = this.endpoint;
                try {
                    if (endToUse != null) {
                        endToUse.afterDelivery();
                    }
                }
                catch (ResourceException e1) {
                    ActiveMQRALogger.LOGGER.unableToCallAfterDelivery((Exception)((Object)e1));
                }
            }
            if (this.useLocalTx || !this.activation.isDeliveryTransacted()) {
                try {
                    this.session.rollback(true);
                }
                catch (ActiveMQException e1) {
                    ActiveMQRALogger.LOGGER.unableToRollbackTX();
                }
            }
            this.session.markRollbackOnly();
        }
        finally {
            try {
                this.session.resetIfNeeded();
            }
            catch (ActiveMQException e) {
                ActiveMQRALogger.LOGGER.unableToResetSession(this.activation.toString(), (Exception)((Object)e));
                this.activation.startReconnectThread("Reset MessageHandler after Failure Thread");
            }
        }
    }

    public void start() throws ActiveMQException {
        this.session.start();
    }

    public void failoverEvent(FailoverEventType eventType) {
        this.connected = eventType == FailoverEventType.FAILOVER_COMPLETED;
    }
}

