/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.token;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.BearerTokenEvidence;
import org.wildfly.security.evidence.Evidence;

public final class TokenSecurityRealm
implements SecurityRealm {
    private final TokenValidator strategy;
    private final String principalClaimName;

    public static Builder builder() {
        return new Builder();
    }

    TokenSecurityRealm(Builder configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        this.principalClaimName = configuration.principalClaimName == null ? "username" : configuration.principalClaimName;
        this.strategy = (TokenValidator)Assert.checkNotNullParam((String)"tokenValidationStrategy", (Object)configuration.strategy);
    }

    @Override
    public RealmIdentity getRealmIdentity(Evidence evidence) {
        return new TokenRealmIdentity(evidence);
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return SupportLevel.UNSUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        if (this.isBearerTokenEvidence(evidenceType)) {
            return SupportLevel.POSSIBLY_SUPPORTED;
        }
        return SupportLevel.UNSUPPORTED;
    }

    private boolean isBearerTokenEvidence(Evidence evidence) {
        return evidence != null && this.isBearerTokenEvidence(evidence.getClass());
    }

    private boolean isBearerTokenEvidence(Class<?> evidenceType) {
        return BearerTokenEvidence.class.equals(evidenceType);
    }

    public static class Builder {
        private String principalClaimName = "username";
        private TokenValidator strategy;

        private Builder() {
        }

        public Builder principalClaimName(String name) {
            this.principalClaimName = name;
            return this;
        }

        public Builder validator(TokenValidator strategy) {
            this.strategy = strategy;
            return this;
        }

        public TokenSecurityRealm build() {
            return new TokenSecurityRealm(this);
        }
    }

    final class TokenRealmIdentity
    implements RealmIdentity {
        private final BearerTokenEvidence evidence;
        private Attributes claims;

        TokenRealmIdentity(Evidence evidence) {
            this.evidence = TokenSecurityRealm.this.isBearerTokenEvidence(evidence) ? (BearerTokenEvidence)BearerTokenEvidence.class.cast(evidence) : null;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            try {
                if (this.exists()) {
                    if (!this.claims.containsKey(TokenSecurityRealm.this.principalClaimName)) {
                        throw ElytronMessages.log.tokenRealmFailedToObtainPrincipalWithClaim(TokenSecurityRealm.this.principalClaimName);
                    }
                    return new NamePrincipal(this.claims.getFirst(TokenSecurityRealm.this.principalClaimName));
                }
            }
            catch (Exception e) {
                throw ElytronMessages.log.tokenRealmFailedToObtainPrincipal(e);
            }
            return null;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return this.validateToken(evidence) != null;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return this.getClaims() != null;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            if (this.exists()) {
                return new AuthorizationIdentity(){

                    @Override
                    public Attributes getAttributes() {
                        return TokenRealmIdentity.this.claims;
                    }
                };
            }
            return null;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return null;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            if (this.exists() && TokenSecurityRealm.this.isBearerTokenEvidence(evidenceType)) {
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        private Attributes getClaims() throws RealmUnavailableException {
            if (this.claims == null) {
                this.claims = this.validateToken(this.evidence);
            }
            return this.claims;
        }

        private Attributes validateToken(Evidence evidence) throws RealmUnavailableException {
            if (!TokenSecurityRealm.this.isBearerTokenEvidence(evidence)) {
                return null;
            }
            BearerTokenEvidence tokenEvidence = (BearerTokenEvidence)BearerTokenEvidence.class.cast(evidence);
            try {
                return TokenSecurityRealm.this.strategy.validate(tokenEvidence);
            }
            catch (RealmUnavailableException rue) {
                throw rue;
            }
            catch (Exception unknown) {
                ElytronMessages.log.debugf(unknown, "Failed to validate token evidence [%s]", tokenEvidence.getToken());
                return null;
            }
        }
    }
}

