/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.text.Normalizer;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.util.ByteStringBuilder;

public final class StringPrep {
    public static final long MAP_TO_NOTHING = 1L;
    public static final long MAP_TO_SPACE = 2L;
    public static final long MAP_SCRAM_LOGIN_CHARS = 0x40000000L;
    public static final long MAP_GS2_LOGIN_CHARS = 0x80000000L;
    public static final long UNMAP_SCRAM_LOGIN_CHARS = 0x10000000L;
    public static final long UNMAP_GS2_LOGIN_CHARS = 0x20000000L;
    public static final long NORMALIZE_KC = 4L;
    public static final long FORBID_NON_ASCII_SPACES = 8L;
    public static final long FORBID_ASCII_CONTROL = 16L;
    public static final long FORBID_NON_ASCII_CONTROL = 32L;
    public static final long FORBID_PRIVATE_USE = 64L;
    public static final long FORBID_NON_CHARACTER = 128L;
    public static final long FORBID_SURROGATE = 256L;
    public static final long FORBID_INAPPROPRIATE_FOR_PLAIN_TEXT = 512L;
    public static final long FORBID_INAPPROPRIATE_FOR_CANON_REP = 1024L;
    public static final long FORBID_CHANGE_DISPLAY_AND_DEPRECATED = 2048L;
    public static final long FORBID_TAGGING = 4096L;
    public static final long FORBID_UNASSIGNED = 8192L;
    public static final long PROFILE_SASL_QUERY = 8191L;
    public static final long PROFILE_SASL_STORED = 16383L;

    public static boolean mapCodePointToNothing(int input) {
        return input == 173 || input == 847 || input == 6150 || input >= 6155 && input <= 6157 || input >= 8203 && input <= 8205 || input == 8288 || input >= 65024 && input <= 65039 || input == 65279;
    }

    public static boolean mapCodePointToSpace(int input) {
        return input == 160 || input == 5760 || input >= 8192 && input <= 8203 || input == 8239 || input == 8287 || input == 12288;
    }

    public static void forbidNonAsciiSpaces(int input) {
        if (StringPrep.mapCodePointToSpace(input)) {
            throw ElytronMessages.log.invalidNonAsciiSpace(input);
        }
    }

    public static void forbidAsciiControl(int input) {
        if (input < 32 || input == 127) {
            throw ElytronMessages.log.invalidAsciiControl(input);
        }
    }

    public static void forbidNonAsciiControl(int input) {
        if (input >= 128 && input <= 159 || input == 1757 || input == 1807 || input == 6158 || input >= 8204 && input <= 8205 || input >= 8232 && input <= 8233 || input >= 8288 && input <= 8291 || input >= 8298 && input <= 8303 || input == 65279 || input >= 65529 && input <= 65532 || input >= 119155 && input <= 119162) {
            throw ElytronMessages.log.invalidNonAsciiControl(input);
        }
    }

    public static void forbidPrivateUse(int input) {
        if (input >= 57344 && input <= 63743 || input >= 983040 && input <= 1048573 || input >= 0x100000 && input <= 1114109) {
            throw ElytronMessages.log.invalidPrivateUseCharacter(input);
        }
    }

    public static void forbidNonCharacter(int input) {
        if ((input & 0xFFFE) == 65534 || input >= 64976 && input <= 65007) {
            throw ElytronMessages.log.invalidNonCharacterCodePoint(input);
        }
    }

    public static void forbidSurrogate(int input) {
        if (input >= 55296 && input <= 57343) {
            throw ElytronMessages.log.invalidSurrogateCodePoint(input);
        }
    }

    public static void forbidInappropriateForPlainText(int input) {
        if (input >= 65529 && input <= 65533) {
            throw ElytronMessages.log.invalidPlainTextCodePoint(input);
        }
    }

    public static void forbidInappropriateForCanonicalRepresentation(int input) {
        if (input >= 12272 && input <= 12283) {
            throw ElytronMessages.log.invalidNonCanonicalCodePoint(input);
        }
    }

    public static void forbidChangeDisplayPropertiesOrDeprecated(int input) {
        if (input >= 832 && input <= 833 || input >= 8206 && input <= 8207 || input >= 8234 && input <= 8238 || input >= 8298 && input <= 8303) {
            throw ElytronMessages.log.invalidControlCharacter(input);
        }
    }

    public static void forbidTagging(int input) {
        if (input == 917505 || input >= 917536 && input <= 917631) {
            throw ElytronMessages.log.invalidTaggingCharacter(input);
        }
    }

    public static void forbidUnassigned(int input) {
        if (Character.getType(input) == 0) {
            throw ElytronMessages.log.unassignedCodePoint(input);
        }
    }

    private static boolean isSet(long test, long bit) {
        return (test & bit) != 0L;
    }

    public static void encode(char[] string, ByteStringBuilder target, long profile) {
        StringPrep.encode(new String(string), target, profile);
    }

    public static void encode(String string, ByteStringBuilder target, long profile) {
        if (StringPrep.isSet(profile, 4L)) {
            string = Normalizer.normalize(string, Normalizer.Form.NFKC);
        }
        int len = string.length();
        boolean isRALString = false;
        boolean first = true;
        int i = 0;
        while (i < len) {
            int cp;
            int ch;
            if (Character.isHighSurrogate((char)(ch = string.charAt(i++)))) {
                char low;
                if (i == len) {
                    throw ElytronMessages.log.invalidSurrogatePairHightAtEnd((char)ch);
                }
                if (!Character.isLowSurrogate(low = string.charAt(i++))) {
                    throw ElytronMessages.log.invalidSurrogatePairSecondIsNotLow((char)ch, low);
                }
                cp = Character.toCodePoint((char)ch, low);
            } else {
                if (Character.isLowSurrogate((char)ch)) {
                    throw ElytronMessages.log.invalidSurrogatePairLowWithoutHigh((char)ch);
                }
                cp = ch;
            }
            if (!Character.isValidCodePoint(cp)) {
                throw ElytronMessages.log.invalidCodePoint(cp);
            }
            assert (0 <= cp && cp <= 0x10FFFF);
            switch (Character.getDirectionality(cp)) {
                case 1: 
                case 2: {
                    if (first) {
                        isRALString = true;
                        break;
                    }
                    if (isRALString) break;
                    throw ElytronMessages.log.disallowedRalDirectionalityInL();
                }
                case 0: {
                    if (!isRALString) break;
                    throw ElytronMessages.log.disallowedLDirectionalityInRal();
                }
                default: {
                    if (i != len || !isRALString) break;
                    throw ElytronMessages.log.missingTrailingRal();
                }
            }
            if (first) {
                first = false;
            }
            if (StringPrep.isSet(profile, 1L) && StringPrep.mapCodePointToNothing(cp)) continue;
            if (StringPrep.isSet(profile, 2L) && StringPrep.mapCodePointToSpace(cp)) {
                target.append(' ');
                continue;
            }
            if (StringPrep.isSet(profile, 0x40000000L) || StringPrep.isSet(profile, 0x80000000L)) {
                if (cp == 61) {
                    target.append('=').append('3').append('D');
                    continue;
                }
                if (cp == 44) {
                    target.append('=').append('2').append('C');
                    continue;
                }
            } else if ((StringPrep.isSet(profile, 0x10000000L) || StringPrep.isSet(profile, 0x20000000L)) && cp == 61) {
                if (i + 1 >= len) {
                    throw ElytronMessages.log.invalidEscapeSequence();
                }
                char ch1 = string.charAt(i++);
                char ch2 = string.charAt(i++);
                if (ch1 == '3' && ch2 == 'D') {
                    target.append('=');
                    continue;
                }
                if (ch1 == '2' && ch2 == 'C') {
                    target.append(',');
                    continue;
                }
                throw ElytronMessages.log.invalidEscapeSequence();
            }
            if (StringPrep.isSet(profile, 8L)) {
                StringPrep.forbidNonAsciiSpaces(cp);
            }
            if (StringPrep.isSet(profile, 16L)) {
                StringPrep.forbidAsciiControl(cp);
            }
            if (StringPrep.isSet(profile, 32L)) {
                StringPrep.forbidNonAsciiControl(cp);
            }
            if (StringPrep.isSet(profile, 64L)) {
                StringPrep.forbidPrivateUse(cp);
            }
            if (StringPrep.isSet(profile, 128L)) {
                StringPrep.forbidNonCharacter(cp);
            }
            if (StringPrep.isSet(profile, 256L)) {
                StringPrep.forbidSurrogate(cp);
            }
            if (StringPrep.isSet(profile, 512L)) {
                StringPrep.forbidInappropriateForPlainText(cp);
            }
            if (StringPrep.isSet(profile, 1024L)) {
                StringPrep.forbidInappropriateForCanonicalRepresentation(cp);
            }
            if (StringPrep.isSet(profile, 2048L)) {
                StringPrep.forbidChangeDisplayPropertiesOrDeprecated(cp);
            }
            if (StringPrep.isSet(profile, 4096L)) {
                StringPrep.forbidTagging(cp);
            }
            if (StringPrep.isSet(profile, 8192L)) {
                StringPrep.forbidUnassigned(cp);
            }
            target.appendUtf8Raw(cp);
        }
    }
}

