/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class ExecuteOperation<T>
extends RetryOnFailureOperation<T> {
    private final String taskName;
    private final Map<String, byte[]> marshalledParams;

    protected ExecuteOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, String taskName, Map<String, byte[]> marshalledParams) {
        super((short)43, (short)44, codec, channelFactory, cacheName == null ? DEFAULT_CACHE_NAME_BYTES : cacheName, topologyId, flags, cfg);
        this.taskName = taskName;
        this.marshalledParams = marshalledParams;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer();
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeString(buf, this.taskName);
        ByteBufUtil.writeVInt(buf, this.marshalledParams.size());
        for (Map.Entry<String, byte[]> entry : this.marshalledParams.entrySet()) {
            ByteBufUtil.writeString(buf, entry.getKey());
            ByteBufUtil.writeArray(buf, entry.getValue());
        }
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.complete(this.codec.readUnmarshallByteArray(buf, status, this.cfg.serialWhitelist(), this.channelFactory.getMarshaller()));
    }
}

