/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessControlContext;
import org.jboss.modules.PathResourceLoader;
import org.jboss.modules.Resource;

class PathResource
implements Resource {
    private final Path path;
    private final AccessControlContext context;

    PathResource(Path path, AccessControlContext context) {
        this.path = path;
        this.context = context;
    }

    @Override
    public String getName() {
        String separator = this.path.getFileSystem().getSeparator();
        if (separator.equals("/")) {
            return this.path.toString();
        }
        return this.path.toString().replace(separator, "/");
    }

    @Override
    public URL getURL() {
        return PathResourceLoader.doPrivilegedIfNeeded(this.context, () -> this.path.toUri().toURL());
    }

    @Override
    public InputStream openStream() throws IOException {
        return PathResourceLoader.doPrivilegedIfNeeded(this.context, IOException.class, () -> Files.newInputStream(this.path, new OpenOption[0]));
    }

    @Override
    public long getSize() {
        try {
            return PathResourceLoader.doPrivilegedIfNeeded(this.context, IOException.class, () -> Files.size(this.path));
        }
        catch (IOException e) {
            return 0L;
        }
    }
}

