/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.unix.Limits;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

public final class IovArray
implements ChannelOutboundBuffer.MessageProcessor {
    private static final int ADDRESS_SIZE = PlatformDependent.addressSize();
    private static final int IOV_SIZE = 2 * ADDRESS_SIZE;
    private static final int CAPACITY = Limits.IOV_MAX * IOV_SIZE;
    private final long memoryAddress;
    private int count;
    private long size;
    private long maxBytes = Limits.SSIZE_MAX;

    public IovArray() {
        this.memoryAddress = PlatformDependent.allocateMemory((long)CAPACITY);
    }

    public void clear() {
        this.count = 0;
        this.size = 0L;
    }

    public boolean add(ByteBuf buf) {
        ByteBuffer[] buffers;
        if (this.count == Limits.IOV_MAX) {
            return false;
        }
        if (buf.nioBufferCount() == 1) {
            int len = buf.readableBytes();
            return len == 0 || this.add(buf.memoryAddress(), buf.readerIndex(), len);
        }
        for (ByteBuffer nioBuffer : buffers = buf.nioBuffers()) {
            int len = nioBuffer.remaining();
            if (len == 0 || this.add(PlatformDependent.directBufferAddress((ByteBuffer)nioBuffer), nioBuffer.position(), len) && this.count != Limits.IOV_MAX) continue;
            return false;
        }
        return true;
    }

    private boolean add(long addr, int offset, int len) {
        long baseOffset = this.memoryAddress(this.count);
        long lengthOffset = baseOffset + (long)ADDRESS_SIZE;
        if (this.maxBytes - (long)len < this.size && this.count > 0) {
            return false;
        }
        this.size += (long)len;
        ++this.count;
        if (ADDRESS_SIZE == 8) {
            PlatformDependent.putLong((long)baseOffset, (long)(addr + (long)offset));
            PlatformDependent.putLong((long)lengthOffset, (long)len);
        } else {
            assert (ADDRESS_SIZE == 4);
            PlatformDependent.putInt((long)baseOffset, (int)((int)addr + offset));
            PlatformDependent.putInt((long)lengthOffset, (int)len);
        }
        return true;
    }

    public int count() {
        return this.count;
    }

    public long size() {
        return this.size;
    }

    public void maxBytes(long maxBytes) {
        this.maxBytes = Math.min(Limits.SSIZE_MAX, ObjectUtil.checkPositive((long)maxBytes, (String)"maxBytes"));
    }

    public long maxBytes() {
        return this.maxBytes;
    }

    public long memoryAddress(int offset) {
        return this.memoryAddress + (long)(IOV_SIZE * offset);
    }

    public void release() {
        PlatformDependent.freeMemory((long)this.memoryAddress);
    }

    public boolean processMessage(Object msg) throws Exception {
        return msg instanceof ByteBuf && this.add((ByteBuf)msg);
    }
}

