/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.undertow.deployment.ScisMetaData;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class ServletContainerInitializerDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Map<ServletContainerInitializer, Set<Class<?>>> handlesTypes;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ServiceModuleLoader loader = (ServiceModuleLoader)deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        assert (warMetaData != null);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw UndertowLogger.ROOT_LOGGER.failedToResolveModule(deploymentUnit);
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        ScisMetaData scisMetaData = (ScisMetaData)deploymentUnit.getAttachment(ScisMetaData.ATTACHMENT_KEY);
        if (scisMetaData == null) {
            scisMetaData = new ScisMetaData();
            deploymentUnit.putAttachment(ScisMetaData.ATTACHMENT_KEY, (Object)scisMetaData);
        }
        Set<ServletContainerInitializer> scis = scisMetaData.getScis();
        HashSet<Class<? extends ServletContainerInitializer>> sciClasses = new HashSet<Class<? extends ServletContainerInitializer>>();
        if (scis == null) {
            scis = new HashSet<ServletContainerInitializer>();
            scisMetaData.setScis(scis);
        }
        if ((handlesTypes = scisMetaData.getHandlesTypes()) == null) {
            handlesTypes = new HashMap();
            scisMetaData.setHandlesTypes(handlesTypes);
        }
        for (ModuleDependency dependency : moduleSpecification.getAllDependencies()) {
            try {
                Module depModule = loader.loadModule(dependency.getIdentifier());
                ServiceLoader serviceLoader = depModule.loadService(ServletContainerInitializer.class);
                for (ServletContainerInitializer service : serviceLoader) {
                    if (!sciClasses.add(service.getClass())) continue;
                    scis.add(service);
                }
            }
            catch (ModuleLoadException e) {
                if (dependency.isOptional()) continue;
                throw UndertowLogger.ROOT_LOGGER.errorLoadingSCIFromModule(dependency.getIdentifier().toString(), (Exception)((Object)e));
            }
        }
        List order = warMetaData.getOrder();
        Map localScis = warMetaData.getScis();
        if (order != null && localScis != null) {
            for (Object jar : order) {
                VirtualFile sci = (VirtualFile)localScis.get(jar);
                if (sci == null) continue;
                scis.addAll(this.loadSci((ClassLoader)classLoader, sci, (String)jar, true, sciClasses));
            }
        }
        HashMap<Class, HashSet<ServletContainerInitializer>> typesMap = new HashMap<Class, HashSet<ServletContainerInitializer>>();
        for (ServletContainerInitializer service : scis) {
            HandlesTypes handlesTypesAnnotation;
            Class[] typesArray;
            if (!service.getClass().isAnnotationPresent(HandlesTypes.class) || (typesArray = (handlesTypesAnnotation = service.getClass().getAnnotation(HandlesTypes.class)).value()) == null) continue;
            Class[] classArray = typesArray;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class type = classArray[i];
                HashSet<ServletContainerInitializer> servicesSet = (HashSet<ServletContainerInitializer>)typesMap.get(type);
                if (servicesSet == null) {
                    servicesSet = new HashSet<ServletContainerInitializer>();
                    typesMap.put(type, servicesSet);
                }
                servicesSet.add(service);
                handlesTypes.put(service, new HashSet());
            }
        }
        Class[] typesArray = typesMap.keySet().toArray(new Class[0]);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (index == null) {
            throw UndertowLogger.ROOT_LOGGER.unableToResolveAnnotationIndex(deploymentUnit);
        }
        CompositeIndex parentIndex = deploymentUnit.getParent() == null ? null : (CompositeIndex)deploymentUnit.getParent().getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (Class type : typesArray) {
            DotName className = DotName.createSimple((String)type.getName());
            HashSet<ClassInfo> classInfos = new HashSet<ClassInfo>();
            classInfos.addAll(this.processHandlesType(className, type, index));
            if (parentIndex != null) {
                classInfos.addAll(this.processHandlesType(className, type, parentIndex));
            }
            Set<Class<?>> classes = this.loadClassInfoSet(classInfos, (ClassLoader)classLoader);
            Set sciSet = (Set)typesMap.get(type);
            for (ServletContainerInitializer sci : sciSet) {
                handlesTypes.get(sci).addAll(classes);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
        context.removeAttachment(ScisMetaData.ATTACHMENT_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServletContainerInitializer> loadSci(ClassLoader classLoader, VirtualFile sci, String jar, boolean error, Set<Class<? extends ServletContainerInitializer>> sciClasses) throws DeploymentUnitProcessingException {
        ArrayList<ServletContainerInitializer> scis = new ArrayList<ServletContainerInitializer>();
        InputStream is = null;
        try {
            is = sci.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String servletContainerInitializerClassName = reader.readLine();
            while (servletContainerInitializerClassName != null) {
                try {
                    ServletContainerInitializer service;
                    int pos = servletContainerInitializerClassName.indexOf(35);
                    if (pos >= 0) {
                        servletContainerInitializerClassName = servletContainerInitializerClassName.substring(0, pos);
                    }
                    if (!(servletContainerInitializerClassName = servletContainerInitializerClassName.trim()).isEmpty() && (service = (ServletContainerInitializer)classLoader.loadClass(servletContainerInitializerClassName).newInstance()) != null && sciClasses.add(service.getClass())) {
                        scis.add(service);
                    }
                    servletContainerInitializerClassName = reader.readLine();
                }
                catch (Exception e) {
                    if (error) {
                        throw UndertowLogger.ROOT_LOGGER.errorProcessingSCI(jar, e);
                    }
                    UndertowLogger.ROOT_LOGGER.skippedSCI(jar, e);
                }
            }
        }
        catch (Exception e) {
            if (error) {
                throw UndertowLogger.ROOT_LOGGER.errorProcessingSCI(jar, e);
            }
            UndertowLogger.ROOT_LOGGER.skippedSCI(jar, e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return scis;
    }

    private Set<ClassInfo> processHandlesType(DotName typeName, Class<?> type, CompositeIndex index) throws DeploymentUnitProcessingException {
        HashSet<ClassInfo> classes = new HashSet<ClassInfo>();
        if (type.isAnnotation()) {
            List instances = index.getAnnotations(typeName);
            for (AnnotationInstance instance : instances) {
                AnnotationTarget annotationTarget = instance.target();
                if (annotationTarget instanceof ClassInfo) {
                    classes.add((ClassInfo)annotationTarget);
                    continue;
                }
                if (annotationTarget instanceof FieldInfo) {
                    classes.add(((FieldInfo)annotationTarget).declaringClass());
                    continue;
                }
                if (annotationTarget instanceof MethodInfo) {
                    classes.add(((MethodInfo)annotationTarget).declaringClass());
                    continue;
                }
                if (!(annotationTarget instanceof MethodParameterInfo)) continue;
                classes.add(((MethodParameterInfo)annotationTarget).method().declaringClass());
            }
        } else {
            classes.addAll(index.getAllKnownSubclasses(typeName));
            classes.addAll(index.getAllKnownImplementors(typeName));
        }
        return classes;
    }

    private Set<Class<?>> loadClassInfoSet(Set<ClassInfo> classInfos, ClassLoader classLoader) throws DeploymentUnitProcessingException {
        HashSet classes = new HashSet();
        for (ClassInfo classInfo : classInfos) {
            try {
                Class<?> type = classLoader.loadClass(classInfo.name().toString());
                classes.add(type);
            }
            catch (Exception e) {
                UndertowLogger.ROOT_LOGGER.cannotLoadDesignatedHandleTypes(classInfo, e);
            }
        }
        return classes;
    }
}

