/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.hibernate.search.analyzer.definition.LuceneAnalysisDefinitionProvider;
import org.hibernate.search.analyzer.definition.impl.ChainingLuceneAnalysisDefinitionRegistry;
import org.hibernate.search.analyzer.definition.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.analyzer.definition.impl.LuceneAnalysisDefinitionRegistryBuilderImpl;
import org.hibernate.search.analyzer.definition.impl.SimpleLuceneAnalysisDefinitionRegistry;
import org.hibernate.search.analyzer.definition.spi.LuceneAnalysisDefinitionSourceService;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerBuilder;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.NamedLuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.NamedLuceneNormalizerReference;
import org.hibernate.search.analyzer.impl.ScopedLuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.SimpleLuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.SimpleLuceneNormalizerReference;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerStrategy;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.backend.impl.lucene.analysis.HibernateSearchNormalizerWrapper;
import org.hibernate.search.cfg.Environment;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.PassThroughAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneEmbeddedAnalyzerStrategy
implements AnalyzerStrategy {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final ServiceManager serviceManager;
    private final SearchConfiguration cfg;
    private final Version luceneMatchVersion;
    private final SimpleLuceneAnalysisDefinitionRegistry defaultDefinitionRegistry;

    public LuceneEmbeddedAnalyzerStrategy(ServiceManager serviceManager, SearchConfiguration cfg) {
        this.serviceManager = serviceManager;
        this.cfg = cfg;
        this.luceneMatchVersion = this.getLuceneMatchVersion(cfg);
        this.defaultDefinitionRegistry = this.createDefaultDefinitionRegistry(cfg);
    }

    private Version getLuceneMatchVersion(SearchConfiguration cfg) {
        Version version;
        String tmp = cfg.getProperty("hibernate.search.lucene_version");
        if (StringHelper.isEmpty(tmp)) {
            log.recommendConfiguringLuceneVersion();
            version = Environment.DEFAULT_LUCENE_MATCH_VERSION;
        } else {
            try {
                version = Version.parseLeniently((String)tmp);
                if (log.isDebugEnabled()) {
                    log.debug("Setting Lucene compatibility to Version " + version);
                }
            }
            catch (IllegalArgumentException e) {
                throw log.illegalLuceneVersionFormat(tmp, e.getMessage());
            }
            catch (ParseException e) {
                throw log.illegalLuceneVersionFormat(tmp, e.getMessage());
            }
        }
        return version;
    }

    private SimpleLuceneAnalysisDefinitionRegistry createDefaultDefinitionRegistry(SearchConfiguration cfg) {
        LuceneAnalysisDefinitionProvider definitionsProvider = this.getLuceneAnalyzerDefinitionProvider();
        LuceneAnalysisDefinitionRegistryBuilderImpl builder = new LuceneAnalysisDefinitionRegistryBuilderImpl();
        if (definitionsProvider != null) {
            try {
                definitionsProvider.register(builder);
            }
            catch (SearchException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw log.invalidLuceneAnalyzerDefinitionProvider(definitionsProvider.getClass().getName(), e);
            }
        }
        return builder.build();
    }

    private LuceneAnalysisDefinitionProvider getLuceneAnalyzerDefinitionProvider() {
        try (ServiceReference<LuceneAnalysisDefinitionSourceService> serviceRef = this.serviceManager.requestReference(LuceneAnalysisDefinitionSourceService.class);){
            LuceneAnalysisDefinitionProvider luceneAnalysisDefinitionProvider = serviceRef.get().getLuceneAnalyzerDefinitionProvider();
            return luceneAnalysisDefinitionProvider;
        }
    }

    @Override
    public LuceneAnalyzerReference createDefaultAnalyzerReference() {
        Class analyzerClass;
        String analyzerClassName = this.cfg.getProperty("hibernate.search.analyzer");
        if (analyzerClassName != null) {
            try {
                analyzerClass = ClassLoaderHelper.classForName(analyzerClassName, this.serviceManager);
            }
            catch (Exception e) {
                return this.createNamedAnalyzerReference(analyzerClassName);
            }
        } else {
            analyzerClass = StandardAnalyzer.class;
        }
        return this.createLuceneClassAnalyzerReference(analyzerClass);
    }

    @Override
    public LuceneAnalyzerReference createPassThroughAnalyzerReference() {
        return new SimpleLuceneAnalyzerReference(PassThroughAnalyzer.INSTANCE);
    }

    @Override
    public Map<String, AnalyzerReference> createProvidedAnalyzerReferences() {
        HashMap<String, AnalyzerReference> references = new HashMap<String, AnalyzerReference>();
        for (String defaultAnalyzerName : this.defaultDefinitionRegistry.getAnalyzerDefinitions().keySet()) {
            NamedLuceneAnalyzerReference reference = this.createNamedAnalyzerReference(defaultAnalyzerName);
            references.put(defaultAnalyzerName, reference);
        }
        return references;
    }

    @Override
    public LuceneAnalyzerReference createLuceneClassAnalyzerReference(Class<?> analyzerClass) {
        Analyzer analyzer = this.createAnalyzerInstance(analyzerClass);
        return new SimpleLuceneAnalyzerReference(analyzer);
    }

    @Override
    public NamedLuceneAnalyzerReference createNamedAnalyzerReference(String name) {
        return new NamedLuceneAnalyzerReference(name);
    }

    @Override
    public Map<String, AnalyzerReference> createProvidedNormalizerReferences() {
        HashMap<String, AnalyzerReference> references = new HashMap<String, AnalyzerReference>();
        for (String defaultAnalyzerName : this.defaultDefinitionRegistry.getNormalizerDefinitions().keySet()) {
            NamedLuceneAnalyzerReference reference = this.createNamedNormalizerReference(defaultAnalyzerName);
            references.put(defaultAnalyzerName, reference);
        }
        return references;
    }

    @Override
    public LuceneAnalyzerReference createLuceneClassNormalizerReference(Class<?> analyzerClass) {
        Analyzer normalizer = this.createNormalizerInstance(analyzerClass);
        return new SimpleLuceneNormalizerReference(normalizer);
    }

    @Override
    public NamedLuceneAnalyzerReference createNamedNormalizerReference(String name) {
        return new NamedLuceneNormalizerReference(name);
    }

    @Override
    public void initializeReferences(Collection<AnalyzerReference> analyzerReferences, Map<String, AnalyzerDef> mappingAnalyzerDefinitions, Collection<AnalyzerReference> normalizerReferences, Map<String, NormalizerDef> mappingNormalizerDefinitions) {
        LuceneAnalysisDefinitionRegistry definitionRegistry = this.createAnalyzerDefinitionRegistry(mappingAnalyzerDefinitions, mappingNormalizerDefinitions);
        LuceneAnalyzerBuilder builder = new LuceneAnalyzerBuilder(this.luceneMatchVersion, this.serviceManager, definitionRegistry);
        Stream.concat(analyzerReferences.stream(), normalizerReferences.stream()).forEach(r -> this.initializeReference((AnalyzerReference)r, definitionRegistry, builder));
    }

    @Override
    public ScopedLuceneAnalyzerReference.Builder buildScopedAnalyzerReference(AnalyzerReference initialGlobalAnalyzerReference) {
        return new ScopedLuceneAnalyzerReference.Builder(initialGlobalAnalyzerReference.unwrap(LuceneAnalyzerReference.class), Collections.emptyMap());
    }

    private LuceneAnalysisDefinitionRegistry createAnalyzerDefinitionRegistry(Map<String, AnalyzerDef> mappingAnalyzerDefinitions, Map<String, NormalizerDef> mappingNormalizerDefinitions) {
        SimpleLuceneAnalysisDefinitionRegistry mappingDefinitionRegistry = new SimpleLuceneAnalysisDefinitionRegistry(mappingAnalyzerDefinitions, mappingNormalizerDefinitions);
        ChainingLuceneAnalysisDefinitionRegistry definitionRegistry = new ChainingLuceneAnalysisDefinitionRegistry(mappingDefinitionRegistry, this.defaultDefinitionRegistry);
        return definitionRegistry;
    }

    private void initializeReference(AnalyzerReference reference, LuceneAnalysisDefinitionRegistry definitionRegistry, LuceneAnalyzerBuilder builder) {
        NamedLuceneAnalyzerReference namedReference;
        if (reference.is(NamedLuceneAnalyzerReference.class) && !(namedReference = reference.unwrap(NamedLuceneAnalyzerReference.class)).isInitialized()) {
            namedReference.initialize(builder);
        }
    }

    private Analyzer createAnalyzerInstance(Class<?> analyzerClass) {
        try {
            return ClassLoaderHelper.analyzerInstanceFromClass(analyzerClass, this.luceneMatchVersion);
        }
        catch (ClassCastException e) {
            throw new SearchException("Lucene analyzer does not extend " + Analyzer.class.getName() + ": " + analyzerClass.getName(), e);
        }
        catch (Exception e) {
            throw new SearchException("Failed to instantiate lucene analyzer with type " + analyzerClass.getName(), e);
        }
    }

    private Analyzer createNormalizerInstance(Class<?> analyzerClass) {
        Analyzer normalizer = this.createAnalyzerInstance(analyzerClass);
        return new HibernateSearchNormalizerWrapper(normalizer, analyzerClass.getName());
    }
}

