/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.spi.DeleteByQueryLuceneWork;
import org.hibernate.search.backend.spi.DeleteByQueryWork;
import org.hibernate.search.backend.spi.DeletionQuery;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.AbstractDocumentBuilder;
import org.hibernate.search.engine.spi.ContainedInRecursionContext;
import org.hibernate.search.engine.spi.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.interceptor.IndexingOverride;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class WorkPlan {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final Map<IndexedTypeIdentifier, PerClassWork> byClass = new LinkedHashMap<IndexedTypeIdentifier, PerClassWork>();
    private final ExtendedSearchIntegrator extendedIntegrator;
    private final InstanceInitializer instanceInitializer;
    private int approximateWorkQueueSize = 0;

    public WorkPlan(ExtendedSearchIntegrator extendedIntegrator) {
        this.extendedIntegrator = extendedIntegrator;
        this.instanceInitializer = extendedIntegrator.getInstanceInitializer();
    }

    public void addWork(Work work) {
        ++this.approximateWorkQueueSize;
        IndexedTypeIdentifier typeIdentifier = this.instanceInitializer.getIndexedTypeIdFromWork(work);
        PerClassWork classWork = this.getClassWork(work.getTenantIdentifier(), typeIdentifier);
        classWork.addWork(work);
    }

    public void clear() {
        this.byClass.clear();
        this.approximateWorkQueueSize = 0;
    }

    public int size() {
        return this.approximateWorkQueueSize;
    }

    private PerClassWork getClassWork(String tenantId, IndexedTypeIdentifier typeIdentifier) {
        PerClassWork classWork = this.byClass.get(typeIdentifier);
        if (classWork == null) {
            classWork = new PerClassWork(tenantId, typeIdentifier);
            this.byClass.put(typeIdentifier, classWork);
        }
        return classWork;
    }

    public void processContainedInAndPrepareExecution() {
        PerClassWork[] worksFromEvents;
        for (PerClassWork perClassWork : worksFromEvents = this.byClass.values().toArray(new PerClassWork[this.byClass.size()])) {
            perClassWork.processContainedInAndPrepareExecution();
        }
    }

    public <T> void recurseContainedIn(T value, ContainedInRecursionContext context, String tenantId) {
        Class<T> entityClass = this.instanceInitializer.getClass(value);
        PerClassWork classWork = this.getClassWork(tenantId, new PojoIndexedTypeIdentifier(entityClass));
        classWork.recurseContainedIn(value, context);
    }

    public List<LuceneWork> getPlannedLuceneWork() {
        ArrayList<LuceneWork> luceneQueue = new ArrayList<LuceneWork>();
        for (PerClassWork perClassWork : this.byClass.values()) {
            perClassWork.enqueueLuceneWork(luceneQueue);
        }
        return luceneQueue;
    }

    private static AbstractDocumentBuilder getEntityBuilder(ExtendedSearchIntegrator extendedIntegrator, IndexedTypeIdentifier typeIdentifier) {
        EntityIndexBinding entityIndexBinding = extendedIntegrator.getIndexBinding(typeIdentifier);
        if (entityIndexBinding == null) {
            DocumentBuilderContainedEntity entityBuilder = extendedIntegrator.getDocumentBuilderContainedEntity(typeIdentifier);
            if (entityBuilder == null) {
                throw new SearchException("Unable to perform work. Entity Class is not @Indexed nor hosts @ContainedIn: " + typeIdentifier);
            }
            return entityBuilder;
        }
        return entityIndexBinding.getDocumentBuilder();
    }

    private static class PerEntityWork {
        private Object entity;
        private boolean delete = false;
        private boolean add = false;
        private boolean containedInProcessed = false;
        private final String tenantId;

        private PerEntityWork(String tenantId, Object entity) {
            this.entity = entity;
            this.delete = true;
            this.add = true;
            this.containedInProcessed = true;
            this.tenantId = tenantId;
        }

        private PerEntityWork(Work work) {
            this.entity = work.getEntity();
            this.tenantId = work.getTenantIdentifier();
            WorkType type = work.getType();
            switch (type) {
                case ADD: {
                    this.add = true;
                    break;
                }
                case DELETE: 
                case PURGE: {
                    this.delete = true;
                    break;
                }
                case COLLECTION: 
                case UPDATE: {
                    this.delete = true;
                    this.add = true;
                    break;
                }
                case INDEX: {
                    this.add = true;
                    this.delete = true;
                    break;
                }
                default: {
                    throw new SearchException("unexpected state:" + (Object)((Object)type));
                }
            }
        }

        public void addWork(Work work) {
            this.entity = work.getEntity();
            WorkType type = work.getType();
            switch (type) {
                case UPDATE: 
                case INDEX: {
                    if (this.add && !this.delete) break;
                    this.add = true;
                    this.delete = true;
                    break;
                }
                case ADD: {
                    this.add = true;
                    break;
                }
                case DELETE: 
                case PURGE: {
                    if (this.add && !this.delete) {
                        this.add = false;
                        break;
                    }
                    this.add = false;
                    this.delete = true;
                    break;
                }
                case COLLECTION: {
                    if (this.add || this.delete) break;
                    this.add = true;
                    this.delete = true;
                    break;
                }
                default: {
                    throw new SearchException("unexpected state:" + (Object)((Object)type));
                }
            }
        }

        public void enqueueLuceneWork(String tenantIdentifier, IndexedTypeIdentifier typeIdentifier, Serializable indexingId, AbstractDocumentBuilder entityBuilder, List<LuceneWork> luceneQueue, ConversionContext conversionContext) {
            if (this.add || this.delete) {
                entityBuilder.addWorkToQueue(tenantIdentifier, typeIdentifier, this.entity, indexingId, this.delete, this.add, luceneQueue, conversionContext);
            }
        }

        public void processContainedIn(AbstractDocumentBuilder entityBuilder, WorkPlan workplan) {
            if (this.entity != null && !this.containedInProcessed) {
                this.containedInProcessed = true;
                if (this.add || this.delete) {
                    entityBuilder.appendContainedInWorkForInstance(this.entity, workplan, null, this.getTenantIdentifier());
                }
            }
        }

        public String getTenantIdentifier() {
            return this.tenantId;
        }
    }

    class PerClassWork {
        private final Map<Serializable, PerEntityWork> entityById = new LinkedHashMap<Serializable, PerEntityWork>();
        private boolean purgeAll = false;
        private List<DeletionQuery> deletionQueries = new ArrayList<DeletionQuery>();
        private final IndexedTypeIdentifier typeIdentifier;
        private final String tenantId;
        private final AbstractDocumentBuilder documentBuilder;
        private final boolean containedInOnly;

        PerClassWork(String tenantId, IndexedTypeIdentifier typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            this.documentBuilder = WorkPlan.getEntityBuilder(WorkPlan.this.extendedIntegrator, typeIdentifier);
            this.containedInOnly = this.documentBuilder instanceof DocumentBuilderContainedEntity;
            this.tenantId = tenantId;
        }

        public void addWork(Work work) {
            if (work.getType() == WorkType.PURGE_ALL) {
                this.entityById.clear();
                this.deletionQueries.clear();
                this.purgeAll = true;
            } else if (work.getType() == WorkType.DELETE_BY_QUERY) {
                DeleteByQueryWork delWork = (DeleteByQueryWork)work;
                this.deletionQueries.add(delWork.getDeleteByQuery());
            } else {
                Serializable id = this.extractProperId(work);
                PerEntityWork entityWork = this.entityById.get(id);
                if (entityWork == null) {
                    entityWork = new PerEntityWork(work);
                    this.entityById.put(id, entityWork);
                }
                entityWork.addWork(work);
            }
        }

        private Serializable extractProperId(Work work) {
            if (this.containedInOnly) {
                return work.getId();
            }
            Object entity = work.getEntity();
            if (entity == null || this.documentBuilder.requiresProvidedId() || work.isIdentifierWasRolledBack() && this.documentBuilder.isIdMatchingJpaId()) {
                return work.getId();
            }
            return this.documentBuilder.getId(entity);
        }

        public void enqueueLuceneWork(List<LuceneWork> luceneQueue) {
            Set<Map.Entry<Serializable, PerEntityWork>> entityInstances = this.entityById.entrySet();
            ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
            if (this.purgeAll) {
                luceneQueue.add(new PurgeAllLuceneWork(this.tenantId, this.typeIdentifier));
            }
            for (DeletionQuery deletionQuery : this.deletionQueries) {
                luceneQueue.add(new DeleteByQueryLuceneWork(this.tenantId, this.typeIdentifier, deletionQuery));
            }
            for (Map.Entry entry : entityInstances) {
                Serializable indexingId = (Serializable)entry.getKey();
                PerEntityWork perEntityWork = (PerEntityWork)entry.getValue();
                String tenantIdentifier = perEntityWork.getTenantIdentifier();
                perEntityWork.enqueueLuceneWork(tenantIdentifier, this.typeIdentifier, indexingId, this.documentBuilder, luceneQueue, conversionContext);
            }
        }

        public void processContainedInAndPrepareExecution() {
            Map.Entry[] entityInstancesFrozenView = new Map.Entry[this.entityById.size()];
            for (Map.Entry entry : entityInstancesFrozenView = this.entityById.entrySet().toArray(entityInstancesFrozenView)) {
                PerEntityWork perEntityWork = (PerEntityWork)entry.getValue();
                perEntityWork.processContainedIn(this.documentBuilder, WorkPlan.this);
            }
        }

        void recurseContainedIn(Object value, ContainedInRecursionContext context) {
            if (this.documentBuilder.requiresProvidedId()) {
                log.containedInPointsToProvidedId(WorkPlan.this.instanceInitializer.getClass(value));
            } else {
                Serializable extractedId = this.documentBuilder.getId(value);
                if (extractedId != null) {
                    PerEntityWork entityWork = this.entityById.get(extractedId);
                    if (entityWork == null) {
                        EntityIndexingInterceptor entityInterceptor = this.getEntityInterceptor();
                        IndexingOverride operation = entityInterceptor != null ? entityInterceptor.onUpdate(value) : IndexingOverride.APPLY_DEFAULT;
                        switch (operation) {
                            case UPDATE: 
                            case APPLY_DEFAULT: {
                                entityWork = new PerEntityWork(this.tenantId, value);
                                this.entityById.put(extractedId, entityWork);
                                break;
                            }
                            case SKIP: {
                                log.forceSkipIndexOperationViaInterception(this.typeIdentifier, WorkType.UPDATE);
                                break;
                            }
                            case REMOVE: {
                                log.forceRemoveOnIndexOperationViaInterception(this.typeIdentifier, WorkType.UPDATE);
                                Work work = new Work(this.tenantId, value, extractedId, WorkType.DELETE);
                                entityWork = new PerEntityWork(work);
                                this.entityById.put(extractedId, entityWork);
                                break;
                            }
                            default: {
                                throw new AssertionFailure("Unknown action type: " + (Object)((Object)operation));
                            }
                        }
                        this.documentBuilder.appendContainedInWorkForInstance(value, WorkPlan.this, context);
                    }
                } else {
                    this.documentBuilder.appendContainedInWorkForInstance(value, WorkPlan.this, context);
                }
            }
        }

        private EntityIndexingInterceptor getEntityInterceptor() {
            EntityIndexBinding indexBindingForEntity = WorkPlan.this.extendedIntegrator.getIndexBinding(this.typeIdentifier);
            return indexBindingForEntity != null ? indexBindingForEntity.getEntityIndexingInterceptor() : null;
        }

        public String getTenantId() {
            return this.tenantId;
        }
    }
}

