/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;

public class RecoveryMonitor {
    public static void main(String[] args) {
        String host = null;
        int port = 0;
        boolean asyncScan = false;
        int timeout = 20000;
        boolean test = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].compareTo("-help") == 0) {
                RecoveryMonitor.usage();
                System.exit(0);
                continue;
            }
            if (args[i].compareTo("-host") == 0) {
                host = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].compareTo("-port") == 0) {
                try {
                    port = Integer.parseInt(args[i + 1]);
                }
                catch (Exception ex) {
                    System.err.println("Invalid port: " + args[i + 1]);
                }
                ++i;
                continue;
            }
            if (args[i].compareTo("-timeout") == 0) {
                try {
                    timeout = Integer.parseInt(args[i + 1]);
                }
                catch (Exception ex) {
                    System.err.println("Invalid timeout: " + args[i + 1]);
                }
                ++i;
                continue;
            }
            if (args[i].compareTo("-async") == 0) {
                asyncScan = true;
                continue;
            }
            if (args[i].compareTo("-test") == 0) {
                test = true;
                continue;
            }
            System.out.println("Unknown option " + args[i]);
            RecoveryMonitor.usage();
            System.exit(0);
        }
        try {
            if (host == null) {
                host = InetAddress.getLocalHost().getHostName();
            }
            Socket connectorSocket = new Socket(host, port);
            connectorSocket.setSoTimeout(timeout);
            BufferedReader fromServer = new BufferedReader(new InputStreamReader(connectorSocket.getInputStream(), StandardCharsets.UTF_8));
            PrintWriter toServer = new PrintWriter(new OutputStreamWriter(connectorSocket.getOutputStream(), StandardCharsets.UTF_8));
            if (asyncScan) {
                toServer.println("ASYNC_SCAN");
            } else {
                toServer.println("SCAN");
            }
            toServer.flush();
            String response = fromServer.readLine();
            if (response.equals("DONE")) {
                System.out.println("RecoveryManager scan begun.");
            } else {
                System.err.println("RecoveryManager did not understand request: " + response);
            }
            connectorSocket.close();
        }
        catch (ConnectException e) {
            System.err.println("Connection refused - check the host/port information is correct.");
        }
        catch (Exception e) {
            System.err.println("Caught unexpected exception: " + e);
        }
        if (test) {
            System.out.println("Ready");
        }
    }

    private static void usage() {
        System.out.println("Usage: RecoveryMonitor -port <port number> [-host <host name>] [-async] [-timeout <wait time>] [-help]");
    }
}

