/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.resource.transaction.spi.DdlTransactionIsolator;
import org.hibernate.tool.schema.internal.exec.JdbcConnectionAccessProvidedConnectionImpl;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.hibernate.tool.schema.spi.SchemaManagementException;

class DdlTransactionIsolatorProvidedConnectionImpl
implements DdlTransactionIsolator {
    private final JdbcContext jdbcContext;

    public DdlTransactionIsolatorProvidedConnectionImpl(JdbcContext jdbcContext) {
        assert (jdbcContext.getJdbcConnectionAccess() instanceof JdbcConnectionAccessProvidedConnectionImpl);
        this.jdbcContext = jdbcContext;
    }

    @Override
    public JdbcContext getJdbcContext() {
        return this.jdbcContext;
    }

    @Override
    public Connection getIsolatedConnection() {
        try {
            return this.jdbcContext.getJdbcConnectionAccess().obtainConnection();
        }
        catch (SQLException e) {
            throw new SchemaManagementException("Error accessing user-provided Connection via JdbcConnectionAccessProvidedConnectionImpl", e);
        }
    }

    @Override
    public void prepare() {
    }

    @Override
    public void release() {
    }
}

