/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.resource.transaction.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.backend.jdbc.internal.DdlTransactionIsolatorNonJtaImpl;
import org.hibernate.resource.transaction.backend.jta.internal.DdlTransactionIsolatorJtaImpl;
import org.hibernate.resource.transaction.spi.DdlTransactionIsolator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.extract.internal.DatabaseInformationImpl;
import org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.hibernate.tool.schema.internal.exec.ScriptSourceInputFromFile;
import org.hibernate.tool.schema.internal.exec.ScriptSourceInputFromReader;
import org.hibernate.tool.schema.internal.exec.ScriptSourceInputFromUrl;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToFile;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToUrl;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToWriter;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.jboss.logging.Logger;

public class Helper {
    private static final Logger log = Logger.getLogger(Helper.class);

    public static ScriptSourceInput interpretScriptSourceSetting(Object scriptSourceSetting, ClassLoaderService classLoaderService) {
        if (Reader.class.isInstance(scriptSourceSetting)) {
            return new ScriptSourceInputFromReader((Reader)scriptSourceSetting);
        }
        String scriptSourceSettingString = scriptSourceSetting.toString();
        log.debugf("Attempting to resolve script source setting : %s", (Object)scriptSourceSettingString);
        log.trace((Object)"Trying as URL...");
        URL url = classLoaderService.locateResource(scriptSourceSettingString);
        if (url != null) {
            return new ScriptSourceInputFromUrl(url);
        }
        File file = new File(scriptSourceSettingString);
        return new ScriptSourceInputFromFile(file);
    }

    public static ScriptTargetOutput interpretScriptTargetSetting(Object scriptTargetSetting, ClassLoaderService classLoaderService) {
        if (scriptTargetSetting == null) {
            return null;
        }
        if (Writer.class.isInstance(scriptTargetSetting)) {
            return new ScriptTargetOutputToWriter((Writer)scriptTargetSetting);
        }
        String scriptTargetSettingString = scriptTargetSetting.toString();
        log.debugf("Attempting to resolve script source setting : %s", (Object)scriptTargetSettingString);
        log.trace((Object)"Trying as URL...");
        URL url = classLoaderService.locateResource(scriptTargetSettingString);
        if (url != null) {
            return new ScriptTargetOutputToUrl(url);
        }
        File file = new File(scriptTargetSettingString);
        return new ScriptTargetOutputToFile(file);
    }

    public static boolean interpretNamespaceHandling(Map configurationValues) {
        return ConfigurationHelper.getBoolean("javax.persistence.create-database-schemas", configurationValues, ConfigurationHelper.getBoolean("hibernate.hbm2dll.create_namespaces", configurationValues, false));
    }

    public static boolean interpretFormattingEnabled(Map configurationValues) {
        return ConfigurationHelper.getBoolean("hibernate.format_sql", configurationValues, false);
    }

    public static DatabaseInformation buildDatabaseInformation(ServiceRegistry serviceRegistry, DdlTransactionIsolator ddlTransactionIsolator, Namespace.Name defaultNamespace) {
        JdbcEnvironment jdbcEnvironment = serviceRegistry.getService(JdbcEnvironment.class);
        try {
            return new DatabaseInformationImpl(serviceRegistry, jdbcEnvironment, ddlTransactionIsolator, defaultNamespace);
        }
        catch (SQLException e) {
            throw jdbcEnvironment.getSqlExceptionHelper().convert(e, "Unable to build DatabaseInformation");
        }
    }

    public static DdlTransactionIsolator buildDefaultDdlTransactionIsolator(JdbcContext jdbcContext) {
        TransactionCoordinatorBuilder builder = jdbcContext.getServiceRegistry().getService(TransactionCoordinatorBuilder.class);
        return builder.isJta() ? new DdlTransactionIsolatorJtaImpl(jdbcContext) : new DdlTransactionIsolatorNonJtaImpl(jdbcContext);
    }
}

