/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.jgroups.spi.JGroupsDefaultRequirement;
import org.wildfly.extension.messaging.activemq.BroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq.CommonAttributes;

public class BroadcastGroupRemove
extends AbstractRemoveStepHandler {
    public static final BroadcastGroupRemove INSTANCE = new BroadcastGroupRemove();

    private BroadcastGroupRemove() {
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        String broadcastGroupName = context.getCurrentAddressValue();
        String serverName = context.getCurrentAddress().getParent().getLastElement().getValue();
        String compositeName = serverName + "." + broadcastGroupName;
        context.deregisterCapability(BroadcastGroupDefinition.CHANNEL_FACTORY_CAPABILITY.getDynamicName(compositeName));
        ModelNode model = resource.getModel();
        if (CommonAttributes.JGROUPS_CHANNEL.resolveModelAttribute(context, model).isDefined() && !BroadcastGroupDefinition.JGROUPS_STACK.resolveModelAttribute(context, model).isDefined()) {
            context.deregisterCapabilityRequirement(JGroupsDefaultRequirement.CHANNEL_FACTORY.getName(), RuntimeCapability.buildDynamicCapabilityName((String)BroadcastGroupDefinition.CHANNEL_FACTORY_CAPABILITY.getName(), (String)compositeName));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.reloadRequired();
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.revertReloadRequired();
    }
}

