/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import java.util.Map;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.PrimaryPredicateExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;

public final class LikeExpr
implements PrimaryPredicateExpr {
    public static final char SINGLE_CHARACTER_WILDCARD = '_';
    public static final char MULTIPLE_CHARACTERS_WILDCARD = '%';
    public static final char DEFAULT_ESCAPE_CHARACTER = '\\';
    private final ValueExpr child;
    private final Object pattern;
    private final char escapeChar = (char)92;

    public LikeExpr(ValueExpr child, Object pattern) {
        this.child = child;
        this.pattern = pattern;
    }

    @Override
    public ValueExpr getChild() {
        return this.child;
    }

    public String getPattern(Map<String, Object> namedParameters) {
        if (this.pattern instanceof ConstantValueExpr.ParamPlaceholder) {
            String paramName = ((ConstantValueExpr.ParamPlaceholder)this.pattern).getName();
            if (namedParameters == null) {
                throw new IllegalStateException("Missing value for parameter " + paramName);
            }
            String p = (String)namedParameters.get(paramName);
            if (p == null) {
                throw new IllegalStateException("Missing value for parameter " + paramName);
            }
            return p;
        }
        return (String)this.pattern;
    }

    public char getEscapeChar() {
        return '\\';
    }

    @Override
    public <T> T acceptVisitor(Visitor<?, ?> visitor) {
        return (T)visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LikeExpr likeExpr = (LikeExpr)o;
        return this.pattern.equals(likeExpr.pattern) && this.child.equals(likeExpr.child);
    }

    public int hashCode() {
        return 31 * this.child.hashCode() + this.pattern.hashCode();
    }

    public String toString() {
        return "LIKE(" + this.child + ", " + this.pattern + ')';
    }

    @Override
    public String toQueryString() {
        return this.child.toQueryString() + " LIKE '" + this.pattern + "'";
    }
}

