/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.net.ssl.SSLContext;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionBuilder;
import org.jboss.remoting3.ConnectionImpl;
import org.jboss.remoting3.ConnectionInfo;
import org.jboss.remoting3.ConnectionKey;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.ConnectionProviderFactoryBuilder;
import org.jboss.remoting3.DuplicateRegistrationException;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointBuilder;
import org.jboss.remoting3.EndpointMXBean;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.ModuleLoader;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.ServiceRegistrationException;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.Version;
import org.jboss.remoting3._private.Messages;
import org.jboss.remoting3.remote.HttpUpgradeConnectionProviderFactory;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.security.RemotingPermission;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.jboss.remoting3.spi.RegisteredService;
import org.jboss.remoting3.spi.SpiUtils;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.AuthenticationException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.wildfly.security.sasl.util.ProtocolSaslClientFactory;
import org.wildfly.security.sasl.util.ServerNameSaslClientFactory;
import org.xnio.Bits;
import org.xnio.Cancellable;
import org.xnio.FailedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Result;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

final class EndpointImpl
extends AbstractHandleableCloseable<Endpoint>
implements Endpoint {
    private static final String[] NO_STRINGS = new String[0];
    private static final Logger log;
    private static final int CLOSED_FLAG = Integer.MIN_VALUE;
    private static final int COUNT_MASK = Integer.MAX_VALUE;
    private static final String FQCN;
    private final Set<ConnectionImpl> connections = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final Attachments attachments = new Attachments();
    private final ConcurrentMap<String, ProtocolRegistration> connectionProviders = new ConcurrentHashMap<String, ProtocolRegistration>();
    private final ConcurrentMap<String, RegisteredServiceImpl> registeredServices = new ConcurrentHashMap<String, RegisteredServiceImpl>();
    private final ConcurrentMap<ConnectionKey, ConnectionInfo> managedConnections = new ConcurrentHashMap<ConnectionKey, ConnectionInfo>();
    private final Map<URI, OptionMap> connectionOptions;
    private final XnioWorker worker;
    private final Object connectionLock = new Object();
    private static final AtomicIntegerFieldUpdater<EndpointImpl> resourceCountUpdater;
    private volatile int resourceCount = 0;
    private static final Pattern VALID_SERVICE_PATTERN;
    static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT;
    private final String name;
    private final CloseHandler<Object> resourceCloseHandler = (closed, exception) -> this.closeTick1(closed);
    private final CloseHandler<Connection> connectionCloseHandler = (closed, exception) -> this.connections.remove(closed);
    private final boolean ourWorker;
    private final MBeanServer server;
    private final ObjectName objectName;

    private EndpointImpl(XnioWorker xnioWorker, boolean ourWorker, final String name, Map<URI, OptionMap> connectionOptions) throws NotOpenException {
        super((Executor)xnioWorker, true);
        this.worker = xnioWorker;
        this.ourWorker = ourWorker;
        this.name = name;
        this.connectionOptions = connectionOptions;
        MBeanServer server = null;
        ObjectName objectName = null;
        try {
            server = ManagementFactory.getPlatformMBeanServer();
            String objName = name == null ? "Remoting (anonymous)" : "Remoting-" + name;
            objectName = new ObjectName("jboss.remoting.endpoint", "name", objName + "-" + this.hashCode());
            server.registerMBean(new EndpointMXBean(){

                @Override
                public String getEndpointName() {
                    return name;
                }

                @Override
                public String[] getSupportedProtocolNames() {
                    return EndpointImpl.this.connectionProviders.keySet().toArray(NO_STRINGS);
                }

                @Override
                public String[] getRegisteredServices() {
                    return EndpointImpl.this.registeredServices.keySet().toArray(NO_STRINGS);
                }

                @Override
                public boolean getCloseRequested() {
                    return (EndpointImpl.this.resourceCount & Integer.MIN_VALUE) != 0;
                }

                @Override
                public int getResourceCount() {
                    return EndpointImpl.this.resourceCount & Integer.MAX_VALUE;
                }

                @Override
                public String[] getManagedConnectionURIs() {
                    ConnectionKey[] connectionKeys = EndpointImpl.this.managedConnections.keySet().toArray(new ConnectionKey[0]);
                    String[] result = new String[connectionKeys.length];
                    int connectionKeysLength = connectionKeys.length;
                    for (int i = 0; i < connectionKeysLength; ++i) {
                        result[i] = connectionKeys[i].getRealUri().toString();
                    }
                    return result;
                }

                @Override
                public int getConnectionCount() {
                    return EndpointImpl.this.connections.size();
                }
            }, objectName);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        this.server = server;
        this.objectName = objectName;
        log.tracef("Completed open of %s", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EndpointImpl construct(EndpointBuilder endpointBuilder) throws IOException {
        EndpointImpl endpoint;
        XnioWorker xnioWorker;
        String endpointName = endpointBuilder.getEndpointName();
        List<ConnectionProviderFactoryBuilder> factoryBuilders = endpointBuilder.getConnectionProviderFactoryBuilders();
        List<ConnectionBuilder> connectionBuilders = endpointBuilder.getConnectionBuilders();
        HashMap<URI, OptionMap> connectionOptions = new HashMap<URI, OptionMap>();
        if (connectionBuilders != null) {
            for (ConnectionBuilder connectionBuilder : connectionBuilders) {
                URI destination = connectionBuilder.getDestination();
                OptionMap.Builder optionBuilder = OptionMap.builder();
                if (connectionBuilder.getHeartbeatInterval() != -1) {
                    optionBuilder.set(RemotingOptions.HEARTBEAT_INTERVAL, connectionBuilder.getHeartbeatInterval());
                }
                if (connectionBuilder.getReadTimeout() != -1) {
                    optionBuilder.set(Options.READ_TIMEOUT, connectionBuilder.getReadTimeout());
                }
                if (connectionBuilder.getWriteTimeout() != -1) {
                    optionBuilder.set(Options.WRITE_TIMEOUT, connectionBuilder.getWriteTimeout());
                }
                if (connectionBuilder.getIPTrafficClass() != -1) {
                    optionBuilder.set(Options.IP_TRAFFIC_CLASS, connectionBuilder.getIPTrafficClass());
                }
                if (connectionBuilder.isSetTcpKeepAlive()) {
                    optionBuilder.set(Options.KEEP_ALIVE, connectionBuilder.isTcpKeepAlive());
                }
                connectionOptions.put(destination, optionBuilder.getMap());
            }
        }
        if ((xnioWorker = endpointBuilder.getXnioWorker()) == null) {
            XnioWorker.Builder workerBuilder = endpointBuilder.getWorkerBuilder();
            if (workerBuilder == null) {
                xnioWorker = (XnioWorker)XnioWorker.getContextManager().get();
                endpoint = new EndpointImpl(xnioWorker, false, endpointName, connectionOptions);
            } else {
                AtomicReference endpointRef = new AtomicReference();
                workerBuilder.setDaemon(true);
                workerBuilder.setWorkerName(endpointName == null ? "Remoting (anonymous)" : "Remoting \"" + endpointName + "\"");
                workerBuilder.setTerminationTask(() -> {
                    EndpointImpl e = endpointRef.getAndSet(null);
                    if (e != null) {
                        e.closeComplete();
                    }
                });
                xnioWorker = workerBuilder.build();
                endpoint = new EndpointImpl(xnioWorker, true, endpointName, connectionOptions.isEmpty() ? Collections.emptyMap() : connectionOptions);
                endpointRef.set(endpoint);
            }
        } else {
            endpoint = new EndpointImpl(xnioWorker, false, endpointName, connectionOptions.isEmpty() ? Collections.emptyMap() : connectionOptions);
        }
        boolean ok = false;
        try {
            if (factoryBuilders != null) {
                for (ConnectionProviderFactoryBuilder factoryBuilder : factoryBuilders) {
                    ClassLoader classLoader;
                    String className = factoryBuilder.getClassName();
                    String moduleName = factoryBuilder.getModuleName();
                    if (moduleName != null) {
                        classLoader = ModuleLoader.getClassLoaderFromModule(moduleName);
                    } else {
                        if (className == null) {
                            throw new IllegalArgumentException("Either class or module name required for connection provider factory");
                        }
                        classLoader = EndpointImpl.class.getClassLoader();
                    }
                    if (className == null) {
                        ServiceLoader<ConnectionProviderFactory> loader = ServiceLoader.load(ConnectionProviderFactory.class, classLoader);
                        for (ConnectionProviderFactory factory : loader) {
                            endpoint.addConnectionProvider(factoryBuilder.getScheme(), factory, OptionMap.EMPTY);
                            for (String alias : factoryBuilder.getAliases()) {
                                endpoint.addConnectionProvider(alias, factory, OptionMap.EMPTY);
                            }
                        }
                        continue;
                    }
                    try {
                        Class<ConnectionProviderFactory> factoryClass = classLoader.loadClass(className).asSubclass(ConnectionProviderFactory.class);
                        ConnectionProviderFactory factory = factoryClass.newInstance();
                        endpoint.addConnectionProvider(factoryBuilder.getScheme(), factory, OptionMap.EMPTY);
                        for (String alias : factoryBuilder.getAliases()) {
                            endpoint.addConnectionProvider(alias, factory, OptionMap.EMPTY);
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException("Unable to load connection provider factory class '" + className + "'", e);
                    }
                }
            }
            RemoteConnectionProviderFactory remoteConnectionProviderFactory = new RemoteConnectionProviderFactory();
            endpoint.addConnectionProvider("remote", remoteConnectionProviderFactory, OptionMap.create((Option)Options.SSL_ENABLED, (Object)Boolean.TRUE, (Option)Options.SSL_STARTTLS, (Object)Boolean.TRUE));
            endpoint.addConnectionProvider("remote+tls", remoteConnectionProviderFactory, OptionMap.create((Option)Options.SECURE, (Object)Boolean.TRUE));
            endpoint.addConnectionProvider("remoting", remoteConnectionProviderFactory, OptionMap.create((Option)Options.SSL_ENABLED, (Object)Boolean.TRUE, (Option)Options.SSL_STARTTLS, (Object)Boolean.TRUE));
            HttpUpgradeConnectionProviderFactory httpUpgradeConnectionProviderFactory = new HttpUpgradeConnectionProviderFactory();
            endpoint.addConnectionProvider("remote+http", httpUpgradeConnectionProviderFactory, OptionMap.create((Option)Options.SSL_ENABLED, (Object)Boolean.FALSE, (Option)Options.SSL_STARTTLS, (Object)Boolean.TRUE));
            endpoint.addConnectionProvider("remote+https", httpUpgradeConnectionProviderFactory, OptionMap.create((Option)Options.SECURE, (Object)Boolean.TRUE));
            endpoint.addConnectionProvider("http-remoting", httpUpgradeConnectionProviderFactory, OptionMap.create((Option)Options.SSL_ENABLED, (Object)Boolean.FALSE, (Option)Options.SSL_STARTTLS, (Object)Boolean.TRUE));
            endpoint.addConnectionProvider("https-remoting", httpUpgradeConnectionProviderFactory, OptionMap.create((Option)Options.SECURE, (Object)Boolean.TRUE));
            ok = true;
            EndpointImpl endpointImpl = endpoint;
            return endpointImpl;
        }
        finally {
            if (!ok) {
                endpoint.closeAsync();
            }
        }
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Executor getExecutor() {
        return new TrackingExecutor();
    }

    @Override
    protected void closeComplete() {
        try {
            super.closeComplete();
        }
        finally {
            if (this.server != null && this.objectName != null) {
                try {
                    this.server.unregisterMBean(this.objectName);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void closeTick1(Object c) {
        int res = resourceCountUpdater.decrementAndGet(this);
        if (res == Integer.MIN_VALUE) {
            this.finishPhase1();
        } else if ((res & Integer.MIN_VALUE) != 0) {
            if (log.isTraceEnabled()) {
                log.logf(FQCN, Logger.Level.TRACE, null, "Phase 1 shutdown count %08x of %s (closed %s)", (Object)(res & Integer.MAX_VALUE), (Object)this, c);
            }
        } else if (log.isTraceEnabled()) {
            log.logf(FQCN, Logger.Level.TRACE, null, "Resource closed count %08x of %s (closed %s)", (Object)(res & Integer.MAX_VALUE), (Object)this, c);
        }
    }

    private void finishPhase1() {
        log.tracef("Finished phase 1 shutdown of %s", (Object)this);
        if (this.ourWorker) {
            this.worker.shutdown();
        } else {
            this.closeComplete();
        }
    }

    void resourceUntick(Object opened) throws NotOpenException {
        int old;
        do {
            if (((old = resourceCountUpdater.get(this)) & Integer.MIN_VALUE) == 0) continue;
            throw new NotOpenException("Endpoint is not open");
        } while (!resourceCountUpdater.compareAndSet(this, old, old + 1));
        if (log.isTraceEnabled()) {
            log.tracef("Allocated tick to %d of %s (opened %s)", (Object)(old + 1), (Object)this, opened);
        }
    }

    void executorUntick(Object opened) {
        int old;
        do {
            if ((old = resourceCountUpdater.get(this)) != Integer.MIN_VALUE) continue;
            throw new RejectedExecutionException("Endpoint is not open");
        } while (!resourceCountUpdater.compareAndSet(this, old, old + 1));
        if (log.isTraceEnabled()) {
            log.tracef("Allocated tick to %d of %s (opened %s)", (Object)(old + 1), (Object)this, opened);
        }
    }

    boolean isCloseFlagSet() {
        return Bits.allAreSet((int)resourceCountUpdater.get(this), (int)Integer.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAction() throws IOException {
        Object object = this.connectionLock;
        synchronized (object) {
            int res;
            while (!resourceCountUpdater.compareAndSet(this, res = this.resourceCount, res | Integer.MIN_VALUE)) {
            }
            if (res == 0) {
                this.finishPhase1();
            } else {
                for (Object connection : this.connections.toArray()) {
                    ((ConnectionImpl)connection).closeAsync();
                }
                for (ProtocolRegistration protocolRegistration : this.connectionProviders.values()) {
                    protocolRegistration.getProvider().closeAsync();
                }
            }
        }
    }

    @Override
    public Registration registerService(String serviceType, final OpenListener openListener, OptionMap optionMap) throws ServiceRegistrationException {
        RegisteredServiceImpl registeredService;
        if (!VALID_SERVICE_PATTERN.matcher(serviceType).matches()) {
            throw new IllegalArgumentException("Service type must match " + VALID_SERVICE_PATTERN);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)RemotingPermission.REGISTER_SERVICE));
        }
        if (this.registeredServices.putIfAbsent(serviceType, registeredService = new RegisteredServiceImpl(openListener, optionMap)) != null) {
            throw new ServiceRegistrationException("Service type '" + serviceType + "' is already registered");
        }
        MapRegistration<RegisteredServiceImpl> registration = new MapRegistration<RegisteredServiceImpl>(this.registeredServices, serviceType, registeredService){

            @Override
            protected void closeAction() throws IOException {
                try {
                    openListener.registrationTerminated();
                }
                finally {
                    super.closeAction();
                }
            }
        };
        HandleableCloseable.Key key = this.addCloseHandler(SpiUtils.closingCloseHandler(registration));
        registration.addCloseHandler((closed, exception) -> key.remove());
        return registration;
    }

    @Override
    public IoFuture<ConnectionPeerIdentity> getConnectedIdentity(URI destination, SSLContext sslContext, AuthenticationConfiguration authenticationConfiguration) {
        return this.doGetConnection(destination, sslContext, authenticationConfiguration, true);
    }

    @Override
    public IoFuture<ConnectionPeerIdentity> getConnectedIdentityIfExists(URI destination, SSLContext sslContext, AuthenticationConfiguration authenticationConfiguration) {
        return this.doGetConnection(destination, sslContext, authenticationConfiguration, false);
    }

    IoFuture<ConnectionPeerIdentity> doGetConnection(URI destination, SSLContext sslContext, final AuthenticationConfiguration authenticationConfiguration, boolean connect) {
        URI realDestination;
        Assert.checkNotNullParam((String)"destination", (Object)destination);
        Assert.checkNotNullParam((String)"authenticationConfiguration", (Object)authenticationConfiguration);
        AuthenticationContextConfigurationClient client = AUTH_CONFIGURATION_CLIENT;
        String realHost = client.getRealHost(destination, authenticationConfiguration);
        if (realHost == null) {
            throw new IllegalArgumentException("No host given in URI '" + destination + "'");
        }
        int realPort = client.getRealPort(destination, authenticationConfiguration);
        if (realPort == -1) {
            throw new IllegalArgumentException("No port number given in URI '" + destination + "'");
        }
        String scheme = client.getRealProtocol(destination, authenticationConfiguration);
        if (scheme == null) {
            throw new IllegalArgumentException("No scheme given in URI '" + destination + "'");
        }
        try {
            realDestination = new URI(scheme, null, realHost, realPort, null, null, null);
        }
        catch (URISyntaxException e) {
            return new FailedIoFuture(new IOException(e));
        }
        ConnectionKey connectionKey = new ConnectionKey(realDestination, sslContext);
        ConnectionInfo newConnectionInfo = (ConnectionInfo)this.managedConnections.get(connectionKey);
        while (newConnectionInfo == null) {
            newConnectionInfo = new ConnectionInfo(this.connectionOptions.getOrDefault(realDestination, OptionMap.EMPTY));
            ConnectionInfo appearing = this.managedConnections.putIfAbsent(connectionKey, newConnectionInfo);
            if (appearing == null) continue;
            newConnectionInfo = appearing;
        }
        IoFuture<Connection> futureConnection = newConnectionInfo.getConnection(this, connectionKey, authenticationConfiguration, connect);
        if (futureConnection == null) {
            return null;
        }
        final FutureResult futureResult = new FutureResult(this.getExecutor());
        futureResult.addCancelHandler(futureConnection);
        futureConnection.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Connection, FutureResult<ConnectionPeerIdentity>>(){

            public void handleCancelled(FutureResult<ConnectionPeerIdentity> attachment) {
                futureResult.setCancelled();
            }

            public void handleFailed(IOException exception, FutureResult<ConnectionPeerIdentity> attachment) {
                futureResult.setException(exception);
            }

            public void handleDone(Connection connection, FutureResult<ConnectionPeerIdentity> attachment) {
                try {
                    ConnectionPeerIdentity identity = connection.getPeerIdentityContext().authenticate(authenticationConfiguration);
                    futureResult.setResult((Object)identity);
                }
                catch (AuthenticationException e) {
                    futureResult.setException((IOException)((Object)e));
                }
            }
        }, (Object)futureResult);
        return futureResult.getIoFuture();
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions) {
        return this.connect(destination, connectOptions, AuthenticationContext.captureCurrent());
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions, AuthenticationContext authenticationContext) {
        return this.connect(destination, null, connectOptions, authenticationContext);
    }

    @Override
    public IoFuture<Connection> connect(URI destination, InetSocketAddress bindAddress, OptionMap connectOptions, AuthenticationContext authenticationContext) {
        SSLContext sslContext;
        AuthenticationContextConfigurationClient client = AUTH_CONFIGURATION_CLIENT;
        AuthenticationConfiguration configuration = client.getAuthenticationConfiguration(destination, authenticationContext, -1, null, null);
        try {
            sslContext = client.getSSLContext(destination, authenticationContext, null, null);
        }
        catch (GeneralSecurityException e) {
            return new FailedIoFuture(Messages.conn.failedToConfigureSslContext(e));
        }
        return this.connect(destination, (SocketAddress)bindAddress, connectOptions, configuration, sslContext);
    }

    @Override
    public IoFuture<Connection> connect(URI destination, InetSocketAddress bindAddress, OptionMap connectOptions, SSLContext sslContext, AuthenticationConfiguration connectionConfiguration) {
        return this.connect(destination, (SocketAddress)bindAddress, connectOptions, connectionConfiguration, sslContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    IoFuture<Connection> connect(final URI destination, SocketAddress bindAddress, OptionMap connectOptions, final AuthenticationConfiguration configuration, SSLContext sslContext) {
        SecurityManager sm;
        Assert.checkNotNullParam((String)"destination", (Object)destination);
        Assert.checkNotNullParam((String)"connectOptions", (Object)connectOptions);
        final String protocol = AUTH_CONFIGURATION_CLIENT.getSaslProtocol(configuration) != null ? AUTH_CONFIGURATION_CLIENT.getSaslProtocol(configuration) : (connectOptions.contains(RemotingOptions.SASL_PROTOCOL) ? (String)connectOptions.get(RemotingOptions.SASL_PROTOCOL) : "remote");
        UnaryOperator factoryOperator = factory -> new ProtocolSaslClientFactory(factory, protocol);
        if (connectOptions.contains(RemotingOptions.SERVER_NAME)) {
            String serverName = (String)connectOptions.get(RemotingOptions.SERVER_NAME);
            factoryOperator = EndpointImpl.and(factoryOperator, factory -> new ServerNameSaslClientFactory(factory, serverName));
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission((Permission)((Object)RemotingPermission.CONNECT));
        }
        String scheme = AUTH_CONFIGURATION_CLIENT.getRealProtocol(destination, configuration);
        Object object = this.connectionLock;
        synchronized (object) {
            boolean ok = false;
            try {
                this.resourceUntick("Connection to " + destination);
            }
            catch (NotOpenException e) {
                return new FailedIoFuture((IOException)e);
            }
            try {
                final ProtocolRegistration protocolRegistration = (ProtocolRegistration)this.connectionProviders.get(scheme);
                if (protocolRegistration == null) {
                    FailedIoFuture failedIoFuture = new FailedIoFuture((IOException)new UnknownURISchemeException("No connection provider for URI scheme \"" + scheme + "\" is installed"));
                    return failedIoFuture;
                }
                ConnectionProvider connectionProvider = protocolRegistration.getProvider();
                final FutureResult futureResult = new FutureResult(this.getExecutor());
                final StackTraceElement[] mark = Thread.currentThread().getStackTrace();
                UnaryOperator finalFactoryOperator = factoryOperator;
                Result<ConnectionHandlerFactory> result = new Result<ConnectionHandlerFactory>(){
                    private final AtomicBoolean flag = new AtomicBoolean();

                    public boolean setCancelled() {
                        if (!this.flag.compareAndSet(false, true)) {
                            return false;
                        }
                        log.logf(this.getClass().getName(), Logger.Level.TRACE, null, "Registered cancellation result", new Object[0]);
                        EndpointImpl.this.closeTick1("a cancelled connection");
                        futureResult.setCancelled();
                        return true;
                    }

                    public boolean setException(IOException exception) {
                        if (!this.flag.compareAndSet(false, true)) {
                            return false;
                        }
                        log.logf(this.getClass().getName(), Logger.Level.TRACE, (Throwable)exception, "Registered exception result", new Object[0]);
                        EndpointImpl.this.closeTick1("a failed connection (2)");
                        SpiUtils.glueStackTraces(exception, mark, 1, "asynchronous invocation");
                        futureResult.setException(exception);
                        return true;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean setResult(ConnectionHandlerFactory connHandlerFactory) {
                        if (!this.flag.compareAndSet(false, true)) {
                            return false;
                        }
                        Object object = EndpointImpl.this.connectionLock;
                        synchronized (object) {
                            log.logf(this.getClass().getName(), Logger.Level.TRACE, null, "Registered successful result %s", (Object)connHandlerFactory);
                            ConnectionImpl connection = new ConnectionImpl(EndpointImpl.this, connHandlerFactory, protocolRegistration.getContext(), destination, null, configuration, protocol);
                            EndpointImpl.this.connections.add(connection);
                            connection.getConnectionHandler().addCloseHandler(SpiUtils.asyncClosingCloseHandler(connection));
                            connection.addCloseHandler(EndpointImpl.this.resourceCloseHandler);
                            connection.addCloseHandler(EndpointImpl.this.connectionCloseHandler);
                            if (EndpointImpl.this.isCloseFlagSet()) {
                                connection.closeAsync();
                                futureResult.setCancelled();
                            } else {
                                futureResult.setResult((Object)connection);
                            }
                        }
                        return true;
                    }
                };
                Cancellable connect = AccessController.doPrivileged(() -> EndpointImpl.lambda$connect$6(connectionProvider, destination, bindAddress, connectOptions, (Result)result, configuration, sslContext, finalFactoryOperator));
                ok = true;
                futureResult.addCancelHandler(connect);
                IoFuture ioFuture = futureResult.getIoFuture();
                return ioFuture;
            }
            finally {
                if (!ok) {
                    this.closeTick1("a failed connection (1)");
                }
            }
        }
    }

    private static <T> UnaryOperator<T> and(UnaryOperator<T> first, UnaryOperator<T> second) {
        return t -> second.apply(first.apply(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration addConnectionProvider(String uriScheme, ConnectionProviderFactory providerFactory, OptionMap optionMap) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)RemotingPermission.ADD_CONNECTION_PROVIDER));
        }
        boolean ok = false;
        this.resourceUntick("Connection provider for " + uriScheme);
        try {
            MapRegistration<ProtocolRegistration> mapRegistration;
            block10: {
                String saslProtocol = (String)optionMap.get(RemotingOptions.SASL_PROTOCOL, (Object)"remote");
                ConnectionProviderContextImpl context = new ConnectionProviderContextImpl(uriScheme, saslProtocol);
                final ConnectionProvider provider = providerFactory.createInstance(context, optionMap, uriScheme);
                ProtocolRegistration protocolRegistration = new ProtocolRegistration(provider, context);
                try {
                    if (this.connectionProviders.putIfAbsent(uriScheme, protocolRegistration) != null) {
                        IoUtils.safeClose((Closeable)provider);
                        throw new DuplicateRegistrationException("URI scheme '" + uriScheme + "' is already registered to a provider");
                    }
                    log.tracef("Adding connection provider registration named '%s': %s", (Object)uriScheme, (Object)provider);
                    MapRegistration<ProtocolRegistration> registration = new MapRegistration<ProtocolRegistration>(this.connectionProviders, uriScheme, protocolRegistration){

                        @Override
                        protected void closeAction() throws IOException {
                            try {
                                provider.closeAsync();
                            }
                            finally {
                                super.closeAction();
                            }
                        }
                    };
                    provider.addCloseHandler((closed, exception) -> {
                        registration.closeAsync();
                        this.closeTick1(closed);
                    });
                    ok = true;
                    mapRegistration = registration;
                    if (ok) break block10;
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        provider.close();
                    }
                    throw throwable;
                }
                provider.close();
            }
            return mapRegistration;
        }
        finally {
            if (!ok) {
                this.closeTick1("Connection provider for " + uriScheme);
            }
        }
    }

    @Override
    public <T> T getConnectionProviderInterface(String uriScheme, Class<T> expectedType) throws UnknownURISchemeException, ClassCastException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)RemotingPermission.GET_CONNECTION_PROVIDER_INTERFACE));
        }
        if (!expectedType.isInterface()) {
            throw new IllegalArgumentException("Interface expected");
        }
        ProtocolRegistration protocolRegistration = (ProtocolRegistration)this.connectionProviders.get(uriScheme);
        if (protocolRegistration == null) {
            throw new UnknownURISchemeException("No connection provider for URI scheme \"" + uriScheme + "\" is installed");
        }
        return expectedType.cast(protocolRegistration.getProvider().getProviderInterface());
    }

    @Override
    public boolean isValidUriScheme(String uriScheme) {
        return this.connectionProviders.containsKey(uriScheme);
    }

    @Override
    public XnioWorker getXnioWorker() {
        return this.worker;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("endpoint ");
        if (this.name != null) {
            b.append('\"').append(this.name).append('\"');
        } else {
            b.append("(anonymous)");
        }
        b.append(" <").append(Integer.toHexString(this.hashCode())).append(">");
        return b.toString();
    }

    private static /* synthetic */ Cancellable lambda$connect$6(ConnectionProvider connectionProvider, URI destination, SocketAddress bindAddress, OptionMap connectOptions, Result result, AuthenticationConfiguration configuration, SSLContext sslContext, UnaryOperator finalFactoryOperator) {
        return connectionProvider.connect(destination, bindAddress, connectOptions, (Result<ConnectionHandlerFactory>)result, configuration, sslContext, finalFactoryOperator, Collections.emptyList());
    }

    static {
        Logger.getLogger((String)"org.jboss.remoting").infof("JBoss Remoting version %s", (Object)Version.getVersionString());
        log = Logger.getLogger((String)"org.jboss.remoting.endpoint");
        FQCN = EndpointImpl.class.getName();
        resourceCountUpdater = AtomicIntegerFieldUpdater.newUpdater(EndpointImpl.class, "resourceCount");
        VALID_SERVICE_PATTERN = Pattern.compile("[-.:a-zA-Z_0-9]+");
        AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    }

    final class TrackingExecutor
    implements Executor {
        private final AtomicInteger count = new AtomicInteger();

        TrackingExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            AtomicInteger count = this.count;
            int i = count.getAndIncrement();
            boolean ok = false;
            try {
                if (i == 0) {
                    EndpointImpl.this.executorUntick(this);
                }
                EndpointImpl.this.worker.execute(() -> {
                    try {
                        command.run();
                    }
                    finally {
                        this.finishWork();
                    }
                });
                ok = true;
            }
            finally {
                if (!ok) {
                    this.finishWork();
                }
            }
        }

        void finishWork() {
            if (this.count.decrementAndGet() == 0) {
                EndpointImpl.this.closeTick1(this);
            }
        }
    }

    static class RegisteredServiceImpl
    implements RegisteredService {
        private final OpenListener openListener;
        private final OptionMap optionMap;

        private RegisteredServiceImpl(OpenListener openListener, OptionMap optionMap) {
            this.openListener = openListener;
            this.optionMap = optionMap;
        }

        @Override
        public OpenListener getOpenListener() {
            return this.openListener;
        }

        @Override
        public OptionMap getOptionMap() {
            return this.optionMap;
        }
    }

    final class ConnectionProviderContextImpl
    implements ConnectionProviderContext {
        private final String protocol;
        private final String saslProtocol;

        ConnectionProviderContextImpl(String protocol, String saslProtocol) {
            this.protocol = protocol;
            this.saslProtocol = saslProtocol;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(ConnectionHandlerFactory connectionHandlerFactory, SaslAuthenticationFactory authenticationFactory) {
            Object object = EndpointImpl.this.connectionLock;
            synchronized (object) {
                try {
                    EndpointImpl.this.resourceUntick("an inbound connection");
                }
                catch (NotOpenException e) {
                    throw new IllegalStateException("Accept after endpoint close", e);
                }
                boolean ok = false;
                try {
                    ConnectionImpl connection = new ConnectionImpl(EndpointImpl.this, connectionHandlerFactory, this, null, authenticationFactory, AuthenticationConfiguration.empty(), this.saslProtocol);
                    EndpointImpl.this.connections.add(connection);
                    connection.getConnectionHandler().addCloseHandler(SpiUtils.asyncClosingCloseHandler(connection));
                    connection.addCloseHandler(EndpointImpl.this.connectionCloseHandler);
                    connection.addCloseHandler(EndpointImpl.this.resourceCloseHandler);
                    ok = true;
                }
                finally {
                    if (!ok) {
                        EndpointImpl.this.closeTick1("a failed inbound connection");
                    }
                }
            }
        }

        @Override
        public Endpoint getEndpoint() {
            return EndpointImpl.this;
        }

        @Override
        public Xnio getXnio() {
            return EndpointImpl.this.worker.getXnio();
        }

        @Override
        public Executor getExecutor() {
            return EndpointImpl.this.getExecutor();
        }

        @Override
        public XnioWorker getXnioWorker() {
            return EndpointImpl.this.worker;
        }

        @Override
        public String getProtocol() {
            return this.protocol;
        }
    }

    final class LocalConnectionContext
    implements ConnectionHandlerContext {
        private final ConnectionProviderContext connectionProviderContext;
        private final ConnectionImpl connection;

        LocalConnectionContext(ConnectionProviderContext connectionProviderContext, ConnectionImpl connection) {
            this.connectionProviderContext = connectionProviderContext;
            this.connection = connection;
        }

        @Override
        public ConnectionProviderContext getConnectionProviderContext() {
            return this.connectionProviderContext;
        }

        @Override
        public RegisteredServiceImpl getRegisteredService(String serviceType) {
            return (RegisteredServiceImpl)EndpointImpl.this.registeredServices.get(serviceType);
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public void remoteClosed() {
            this.connection.closeAsync();
        }

        @Override
        public void receiveAuthRequest(int id, String mechName, byte[] initialResponse) {
            this.connection.receiveAuthRequest(id, mechName, initialResponse);
        }

        @Override
        public void receiveAuthResponse(int id, byte[] response) {
            this.connection.receiveAuthResponse(id, response);
        }

        @Override
        public void receiveAuthDelete(int id) {
            this.connection.receiveAuthDelete(id);
        }

        @Override
        public void receiveAuthChallenge(int id, byte[] challenge) {
            if (id == 0 || id == 1) {
                return;
            }
            this.connection.getPeerIdentityContext().receiveChallenge(id, challenge);
        }

        @Override
        public void receiveAuthSuccess(int id, byte[] challenge) {
            if (id == 0 || id == 1) {
                return;
            }
            this.connection.getPeerIdentityContext().receiveSuccess(id, challenge);
        }

        @Override
        public void receiveAuthReject(int id) {
            if (id == 0 || id == 1) {
                return;
            }
            this.connection.getPeerIdentityContext().receiveReject(id);
        }

        @Override
        public void receiveAuthDeleteAck(int id) {
            if (id == 0 || id == 1) {
                return;
            }
            this.connection.getPeerIdentityContext().receiveDeleteAck(id);
        }
    }

    class MapRegistration<T>
    extends AbstractHandleableCloseable<Registration>
    implements Registration {
        private final ConcurrentMap<String, T> map;
        private final String key;
        private final T value;

        MapRegistration(ConcurrentMap<String, T> map, String key, T value) {
            super(EndpointImpl.this.getExecutor(), false);
            this.map = map;
            this.key = key;
            this.value = value;
        }

        @Override
        protected void closeAction() throws IOException {
            this.map.remove(this.key, this.value);
            this.closeComplete();
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        T getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("Registration of '%s': %s", this.key, this.value);
        }
    }

    static final class ProtocolRegistration {
        private final ConnectionProvider provider;
        private final ConnectionProviderContextImpl context;

        ProtocolRegistration(ConnectionProvider provider, ConnectionProviderContextImpl context) {
            this.provider = provider;
            this.context = context;
        }

        ConnectionProvider getProvider() {
            return this.provider;
        }

        ConnectionProviderContextImpl getContext() {
            return this.context;
        }
    }
}

