/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal;

import java.util.Collection;
import java.util.Locale;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import org.hibernate.bytecode.enhance.internal.PersistentAttributesHelper;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.internal.util.compare.EqualsHelper;

public abstract class AttributeTypeDescriptor {
    protected InheritanceMetadata inheritanceMetadata;

    protected AttributeTypeDescriptor(InheritanceMetadata inheritanceMetadata) {
        this.inheritanceMetadata = inheritanceMetadata;
    }

    public abstract String buildReadInterceptionBodyFragment(String var1);

    public abstract String buildWriteInterceptionBodyFragment(String var1);

    public String buildInLineDirtyCheckingBodyFragment(EnhancementContext context, CtField currentValue) {
        StringBuilder builder = new StringBuilder();
        try {
            String readFragment;
            if (PersistentAttributesHelper.hasAnnotation(currentValue, Id.class) || PersistentAttributesHelper.hasAnnotation(currentValue, EmbeddedId.class)) {
                return "";
            }
            String string = readFragment = this.inheritanceMetadata.isInherited() && !this.inheritanceMetadata.isVisible() ? "super." + this.inheritanceMetadata.getReaderName() + "()" : "this." + currentValue.getName();
            if (currentValue.getType().isPrimitive() || currentValue.getType().isEnum()) {
                builder.append(String.format("  if ( %s != $1 )", readFragment));
            } else {
                for (CtClass ctClass : currentValue.getType().getInterfaces()) {
                    if (!ctClass.getName().equals(Collection.class.getName()) || !context.isMappedCollection(currentValue)) continue;
                    return "";
                }
                builder.append(String.format("  if ( !%s.areEqual( %s, $1 ) )", EqualsHelper.class.getName(), readFragment));
            }
            builder.append(String.format("  {  %s(\"%s\");  }", "$$_hibernate_trackChange", currentValue.getName()));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return builder.toString();
    }

    public static AttributeTypeDescriptor resolve(CtClass managedCtClass, CtField persistentField) throws NotFoundException {
        boolean inherited = !managedCtClass.equals(persistentField.getDeclaringClass());
        boolean visible = persistentField.visibleFrom(managedCtClass);
        String readerName = "$$_hibernate_read_" + persistentField.getName();
        String writerName = "$$_hibernate_write_" + persistentField.getName();
        InheritanceMetadata inheritanceMetadata = new InheritanceMetadata(inherited, visible, readerName, writerName);
        if (CtClass.booleanType.equals(persistentField.getType())) {
            return new PrimitiveAttributeTypeDescriptor(inheritanceMetadata, Boolean.TYPE);
        }
        if (CtClass.byteType.equals(persistentField.getType())) {
            return new PrimitiveAttributeTypeDescriptor(inheritanceMetadata, Byte.TYPE);
        }
        if (CtClass.charType.equals(persistentField.getType())) {
            return new PrimitiveAttributeTypeDescriptor(inheritanceMetadata, Character.TYPE);
        }
        if (CtClass.shortType.equals(persistentField.getType())) {
            return new PrimitiveAttributeTypeDescriptor(inheritanceMetadata, Short.TYPE);
        }
        if (CtClass.intType.equals(persistentField.getType())) {
            return new PrimitiveAttributeTypeDescriptor(inheritanceMetadata, Integer.TYPE);
        }
        if (CtClass.longType.equals(persistentField.getType())) {
            return new PrimitiveAttributeTypeDescriptor(inheritanceMetadata, Long.TYPE);
        }
        if (CtClass.doubleType.equals(persistentField.getType())) {
            return new PrimitiveAttributeTypeDescriptor(inheritanceMetadata, Double.TYPE);
        }
        if (CtClass.floatType.equals(persistentField.getType())) {
            return new PrimitiveAttributeTypeDescriptor(inheritanceMetadata, Float.TYPE);
        }
        return new ObjectAttributeTypeDescriptor(inheritanceMetadata, persistentField.getType());
    }

    private static class InheritanceMetadata {
        private boolean inherited;
        private boolean visible;
        private String readerName;
        private String writerName;

        public InheritanceMetadata(boolean inherited, boolean visible, String readerName, String writerName) {
            this.inherited = inherited;
            this.visible = visible;
            this.readerName = readerName;
            this.writerName = writerName;
        }

        public boolean isInherited() {
            return this.inherited;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public String getReaderName() {
            return this.readerName;
        }

        public String getWriterName() {
            return this.writerName;
        }
    }

    private static class PrimitiveAttributeTypeDescriptor
    extends AttributeTypeDescriptor {
        private final String type;

        private PrimitiveAttributeTypeDescriptor(InheritanceMetadata inheritanceMetadata, Class<?> primitiveType) {
            super(inheritanceMetadata);
            if (!primitiveType.isPrimitive()) {
                throw new IllegalArgumentException("Primitive attribute type descriptor can only be used on primitive types");
            }
            this.type = primitiveType.getSimpleName().substring(0, 1).toUpperCase(Locale.ROOT) + primitiveType.getSimpleName().substring(1);
        }

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            if (this.inheritanceMetadata.isInherited() && !this.inheritanceMetadata.isVisible()) {
                return String.format("  if (%3$s() != null ) { super.%5$s( %3$s().read%2$s(this, \"%1$s\", super.%4$s())); }", fieldName, this.type, "$$_hibernate_getInterceptor", this.inheritanceMetadata.getReaderName(), this.inheritanceMetadata.getWriterName());
            }
            return String.format("  if (%3$s() != null ) { this.%1$s = %3$s().read%2$s(this, \"%1$s\", this.%1$s); }", fieldName, this.type, "$$_hibernate_getInterceptor");
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            if (this.inheritanceMetadata.isInherited() && !this.inheritanceMetadata.isVisible()) {
                return String.format("  %2$s localVar = $1;%n  if ( %4$s() != null ) { localVar = %4$s().write%3$s(this, \"%1$s\", super.%5$s(), $1); }%n  super.%6$s(localVar);", fieldName, this.type.toLowerCase(Locale.ROOT), this.type, "$$_hibernate_getInterceptor", this.inheritanceMetadata.getReaderName(), this.inheritanceMetadata.getWriterName());
            }
            return String.format("  %2$s localVar = $1;%n  if ( %4$s() != null ) { localVar = %4$s().write%3$s(this, \"%1$s\", this.%1$s, $1); }%n  this.%1$s = localVar;", fieldName, this.type.toLowerCase(Locale.ROOT), this.type, "$$_hibernate_getInterceptor");
        }
    }

    private static class ObjectAttributeTypeDescriptor
    extends AttributeTypeDescriptor {
        private final String type;

        private ObjectAttributeTypeDescriptor(InheritanceMetadata inheritanceMetadata, CtClass concreteType) {
            super(inheritanceMetadata);
            this.type = concreteType.getName();
        }

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            if (this.inheritanceMetadata.isInherited() && !this.inheritanceMetadata.isVisible()) {
                return String.format(" if( %3$s() != null ) { super.%5$s( (%2$s) %3$s().readObject(this, \"%1$s\", super.%4$s())); }%n", fieldName, this.type, "$$_hibernate_getInterceptor", this.inheritanceMetadata.getReaderName(), this.inheritanceMetadata.getWriterName());
            }
            return String.format("  if ( %3$s() != null ) { this.%1$s = (%2$s) %3$s().readObject(this, \"%1$s\", this.%1$s); }%n", fieldName, this.type, "$$_hibernate_getInterceptor");
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            if (this.inheritanceMetadata.isInherited() && !this.inheritanceMetadata.isVisible()) {
                return String.format("  %2$s localVar = $1;%n  if ( %3$s() != null ) { localVar = (%2$s) %3$s().writeObject(this, \"%1$s\", super.%4$s(), $1); }%n  super.%5$s(localVar);", fieldName, this.type, "$$_hibernate_getInterceptor", this.inheritanceMetadata.getReaderName(), this.inheritanceMetadata.getWriterName());
            }
            return String.format("  %2$s localVar = $1;%n  if ( %3$s() != null ) { localVar = (%2$s) %3$s().writeObject(this, \"%1$s\", this.%1$s, $1); }%n  this.%1$s = localVar;", fieldName, this.type, "$$_hibernate_getInterceptor");
        }
    }
}

