/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.admin.embeddedserver;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.server.core.admin.AdminServerTask;

public class CacheCreateTask
extends AdminServerTask<Void> {
    private static final Set<String> PARAMETERS;

    @Override
    public String getTaskContextName() {
        return "cache";
    }

    @Override
    public String getTaskOperationName() {
        return "create";
    }

    public Set<String> getParameters() {
        return PARAMETERS;
    }

    protected Configuration getConfiguration(String name, String configuration) {
        ParserRegistry parserRegistry = new ParserRegistry();
        ConfigurationBuilderHolder builderHolder = parserRegistry.parse(configuration);
        if (!builderHolder.getNamedConfigurationBuilders().containsKey(name)) {
            throw this.log.missingCacheConfiguration(name, configuration);
        }
        return ((ConfigurationBuilder)builderHolder.getNamedConfigurationBuilders().get(name)).build();
    }

    @Override
    protected Void execute(EmbeddedCacheManager cacheManager, Map<String, String> parameters, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        String name = this.requireParameter(parameters, "name");
        String template = this.getParameter(parameters, "template");
        String configuration = this.getParameter(parameters, "configuration");
        if (configuration != null) {
            Configuration config = this.getConfiguration(name, configuration);
            ((EmbeddedCacheManagerAdmin)cacheManager.administration().withFlags(flags)).createCache(name, config);
        } else {
            ((EmbeddedCacheManagerAdmin)cacheManager.administration().withFlags(flags)).createCache(name, template);
        }
        return null;
    }

    static {
        HashSet<String> params = new HashSet<String>(3);
        params.add("name");
        params.add("template");
        params.add("configuration");
        PARAMETERS = Collections.unmodifiableSet(params);
    }
}

