/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.elasticsearch.impl.ElasticsearchJsonQueryDescriptor;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchQueries {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonParser PARSER = new JsonParser();
    private static final Set<String> ALLOWED_PAYLOAD_ATTRIBUTES = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{"query"}));

    private ElasticsearchQueries() {
    }

    public static QueryDescriptor fromJson(String payload) {
        JsonObject payloadAsJsonObject;
        try {
            payloadAsJsonObject = PARSER.parse(payload).getAsJsonObject();
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            throw LOG.invalidSearchAPIPayload((Exception)e);
        }
        ArrayList<String> invalidAttributes = new ArrayList<String>();
        for (Map.Entry entry : payloadAsJsonObject.entrySet()) {
            String payloadAttribute = (String)entry.getKey();
            if (ALLOWED_PAYLOAD_ATTRIBUTES.contains(payloadAttribute)) continue;
            invalidAttributes.add(payloadAttribute);
        }
        if (!invalidAttributes.isEmpty()) {
            throw LOG.unsupportedSearchAPIPayloadAttributes(invalidAttributes);
        }
        return new ElasticsearchJsonQueryDescriptor(PARSER.parse(payload).getAsJsonObject());
    }

    public static QueryDescriptor fromQueryString(String queryStringQuery) {
        JsonBuilder.Object query = JsonBuilder.object().add("query", JsonBuilder.object().add("query_string", JsonBuilder.object().addProperty("query", queryStringQuery)));
        return new ElasticsearchJsonQueryDescriptor(query.build());
    }
}

