/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.query.QueryDefinition;
import org.infinispan.query.clustered.ClusteredQueryCommandType;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.ClusteredQueryCommandWorker;
import org.infinispan.query.impl.CommandInitializer;
import org.infinispan.query.impl.CustomQueryCommand;
import org.infinispan.util.ByteString;

public class ClusteredQueryCommand
extends BaseRpcCommand
implements ReplicableCommand,
CustomQueryCommand {
    public static final byte COMMAND_ID = 101;
    private static final Integer ZERO = 0;
    private ClusteredQueryCommandType commandType;
    private QueryDefinition queryDefinition;
    private Cache<?, ?> cache;
    private UUID lazyQueryId;
    private Integer docIndex = ZERO;

    private ClusteredQueryCommand(ClusteredQueryCommandType type, String cacheName) {
        super(ByteString.fromString((String)cacheName));
        this.commandType = type;
    }

    public ClusteredQueryCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public void fetchExecutionContext(CommandInitializer ci) {
        this.cache = ci.getCacheManager().getCache(this.cacheName.toString());
    }

    public static ClusteredQueryCommand createLazyIterator(QueryDefinition queryDefinition, Cache<?, ?> cache, UUID id) {
        ClusteredQueryCommand clQuery = new ClusteredQueryCommand(ClusteredQueryCommandType.CREATE_LAZY_ITERATOR, cache.getName());
        clQuery.queryDefinition = queryDefinition;
        clQuery.lazyQueryId = id;
        return clQuery;
    }

    public static ClusteredQueryCommand getResultSize(QueryDefinition queryDefinition, Cache<?, ?> cache) {
        ClusteredQueryCommand clQuery = new ClusteredQueryCommand(ClusteredQueryCommandType.GET_RESULT_SIZE, cache.getName());
        clQuery.queryDefinition = queryDefinition;
        return clQuery;
    }

    public static ClusteredQueryCommand createEagerIterator(QueryDefinition queryDefinition, Cache<?, ?> cache) {
        ClusteredQueryCommand clQuery = new ClusteredQueryCommand(ClusteredQueryCommandType.CREATE_EAGER_ITERATOR, cache.getName());
        clQuery.queryDefinition = queryDefinition;
        return clQuery;
    }

    public static ClusteredQueryCommand destroyLazyQuery(Cache<?, ?> cache, UUID id) {
        ClusteredQueryCommand clQuery = new ClusteredQueryCommand(ClusteredQueryCommandType.DESTROY_LAZY_ITERATOR, cache.getName());
        clQuery.lazyQueryId = id;
        return clQuery;
    }

    public static ClusteredQueryCommand retrieveKeyFromLazyQuery(Cache<?, ?> cache, UUID id, int docIndex) {
        ClusteredQueryCommand clQuery = new ClusteredQueryCommand(ClusteredQueryCommandType.GET_SOME_KEYS, cache.getName());
        clQuery.lazyQueryId = id;
        clQuery.docIndex = docIndex;
        return clQuery;
    }

    public CompletableFuture<Object> invokeAsync() {
        return CompletableFuture.completedFuture(this.perform(this.cache));
    }

    public QueryResponse perform(Cache<?, ?> cache) {
        ClusteredQueryCommandWorker worker = this.commandType.getCommand(cache, this.queryDefinition, this.lazyQueryId, this.docIndex);
        return worker.perform();
    }

    public byte getCommandId() {
        return 101;
    }

    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallEnum((Enum)this.commandType, (ObjectOutput)output);
        output.writeObject(this.queryDefinition);
        MarshallUtil.marshallUUID((UUID)this.lazyQueryId, (ObjectOutput)output, (boolean)true);
        output.writeInt(this.docIndex);
    }

    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandType = (ClusteredQueryCommandType)MarshallUtil.unmarshallEnum((ObjectInput)input, ClusteredQueryCommandType::valueOf);
        this.queryDefinition = (QueryDefinition)input.readObject();
        this.lazyQueryId = MarshallUtil.unmarshallUUID((ObjectInput)input, (boolean)true);
        this.docIndex = input.readInt();
    }

    public String toString() {
        return "ClusteredQuery{ cache=" + this.getCacheName() + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheName == null ? 0 : this.cacheName.hashCode());
        result = 31 * result + (this.queryDefinition == null ? 0 : this.queryDefinition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusteredQueryCommand)) {
            return false;
        }
        ClusteredQueryCommand other = (ClusteredQueryCommand)obj;
        if (this.cacheName == null ? other.cacheName != null : !this.cacheName.equals((Object)other.cacheName)) {
            return false;
        }
        return !(this.queryDefinition == null ? other.queryDefinition != null : !this.queryDefinition.equals(other.queryDefinition));
    }

    public boolean isReturnValueExpected() {
        return true;
    }

    public boolean canBlock() {
        return true;
    }
}

