/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.dispatcher.LocalCommandDispatcherFactory;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringRequirement;

public class LocalCommandDispatcherFactoryBuilder
implements CapabilityServiceBuilder<CommandDispatcherFactory> {
    private final ServiceName name;
    private final String groupName;
    private volatile ValueDependency<Group> group;

    public LocalCommandDispatcherFactoryBuilder(ServiceName name, String groupName) {
        this.name = name;
        this.groupName = groupName;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<CommandDispatcherFactory> configure(CapabilityServiceSupport support) {
        this.group = new InjectedValueDependency(ClusteringRequirement.GROUP.getServiceName(support, this.groupName), Group.class);
        return this;
    }

    public ServiceBuilder<CommandDispatcherFactory> build(ServiceTarget target) {
        Value value = () -> new LocalCommandDispatcherFactory((Group)this.group.getValue());
        return this.group.register(target.addService(this.name, (Service)new ValueService(value)).setInitialMode(ServiceController.Mode.ON_DEMAND));
    }
}

