/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.counter.impl.RemoteCounterManager;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.InvalidatedNearRemoteCache;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.RemoteCacheManagerAdminImpl;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.CodecFactory;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.near.NearCacheService;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.uberjar.ManifestUberJarDuplicatedJarsWarner;
import org.infinispan.counter.api.CounterManager;

public class RemoteCacheManager
implements RemoteCacheContainer,
Closeable {
    private static final Log log = LogFactory.getLog(RemoteCacheManager.class);
    public static final String DEFAULT_CACHE_NAME = "___defaultcache";
    public static final String HOTROD_CLIENT_PROPERTIES = "hotrod-client.properties";
    public static final String JSON_STRING_ARRAY_ELEMENT_REGEX = "(?:\")([^\"]*)(?:\",?)";
    private volatile boolean started = false;
    private final Map<RemoteCacheKey, RemoteCacheHolder> cacheName2RemoteCache = new HashMap<RemoteCacheKey, RemoteCacheHolder>();
    private final AtomicInteger defaultCacheTopologyId = new AtomicInteger(-1);
    private Configuration configuration;
    private Codec codec;
    private Marshaller marshaller;
    protected ChannelFactory channelFactory;
    protected ClientListenerNotifier listenerNotifier;
    private final Runnable start = this::start;
    private final Runnable stop = this::stop;
    private final RemoteCounterManager counterManager;

    public RemoteCacheManager(Configuration configuration) {
        this(configuration, true);
    }

    public RemoteCacheManager(Configuration configuration, boolean start) {
        this.configuration = configuration;
        this.counterManager = new RemoteCounterManager();
        if (start) {
            this.start();
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteCacheManager(boolean start) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        builder.classLoader(cl);
        InputStream stream = FileLookupFactory.newInstance().lookupFile(HOTROD_CLIENT_PROPERTIES, cl);
        if (stream == null) {
            log.couldNotFindPropertiesFile(HOTROD_CLIENT_PROPERTIES);
        } else {
            try {
                builder.withProperties(this.loadFromStream(stream));
            }
            finally {
                org.infinispan.commons.util.Util.close((AutoCloseable)stream);
            }
        }
        this.configuration = builder.build();
        this.counterManager = new RemoteCounterManager();
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager() {
        this(true);
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, this.configuration.forceReturnValues());
    }

    public Set<String> getCacheNames() {
        OperationsFactory operationsFactory = new OperationsFactory(this.channelFactory, this.codec, this.configuration);
        String names = (String)Util.await(operationsFactory.newAdminOperation("@@cache@names", Collections.emptyMap()).execute());
        HashSet<String> cacheNames = new HashSet<String>();
        Pattern pattern = Pattern.compile(JSON_STRING_ARRAY_ELEMENT_REGEX);
        Matcher matcher = pattern.matcher(names);
        while (matcher.find()) {
            cacheNames.add(matcher.group(1));
        }
        return cacheNames;
    }

    @Override
    public <K, V> RemoteCache<K, V> getCache(String cacheName, boolean forceReturnValue) {
        return this.createRemoteCache(cacheName, forceReturnValue);
    }

    public <K, V> RemoteCache<K, V> getCache() {
        return this.getCache(this.configuration.forceReturnValues());
    }

    @Override
    public <K, V> RemoteCache<K, V> getCache(boolean forceReturnValue) {
        return this.createRemoteCache("", forceReturnValue);
    }

    public CompletableFuture<Void> startAsync() {
        return CompletableFuture.runAsync(this.start);
    }

    public CompletableFuture<Void> stopAsync() {
        return CompletableFuture.runAsync(this.stop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.channelFactory = new ChannelFactory();
        if (this.marshaller == null) {
            this.marshaller = this.configuration.marshaller();
            if (this.marshaller == null) {
                Class<? extends Marshaller> clazz = this.configuration.marshallerClass();
                this.marshaller = clazz == GenericJBossMarshaller.class && !this.configuration.serialWhitelist().isEmpty() ? new GenericJBossMarshaller(this.configuration.serialWhitelist()) : (Marshaller)org.infinispan.commons.util.Util.getInstance(clazz);
            }
        }
        this.codec = CodecFactory.getCodec(this.configuration.version());
        this.listenerNotifier = new ClientListenerNotifier(this.codec, this.marshaller, this.channelFactory, this.configuration.serialWhitelist());
        ExecutorFactory executorFactory = this.configuration.asyncExecutorFactory().factory();
        if (executorFactory == null) {
            executorFactory = (ExecutorFactory)org.infinispan.commons.util.Util.getInstance(this.configuration.asyncExecutorFactory().factoryClass());
        }
        ExecutorService asyncExecutorService = executorFactory.getExecutor((Properties)this.configuration.asyncExecutorFactory().properties());
        this.channelFactory.start(this.codec, this.configuration, this.defaultCacheTopologyId, this.marshaller, asyncExecutorService, Collections.singletonList(this.listenerNotifier::failoverListeners));
        this.counterManager.start(this.channelFactory, this.codec, this.configuration, this.listenerNotifier);
        Map<RemoteCacheKey, RemoteCacheHolder> map = this.cacheName2RemoteCache;
        synchronized (map) {
            for (RemoteCacheHolder rcc : this.cacheName2RemoteCache.values()) {
                this.startRemoteCache(rcc);
            }
        }
        log.version(RemoteCacheManager.class.getPackage().getImplementationVersion());
        this.warnAboutUberJarDuplicates();
        this.started = true;
    }

    private final void warnAboutUberJarDuplicates() {
        ManifestUberJarDuplicatedJarsWarner scanner = new ManifestUberJarDuplicatedJarsWarner();
        scanner.isClasspathCorrectAsync().thenAcceptAsync(isClasspathCorrect -> {
            if (!isClasspathCorrect.booleanValue()) {
                log.warnAboutUberJarDuplicates();
            }
        });
    }

    public void stop() {
        if (this.isStarted()) {
            this.listenerNotifier.stop();
            this.counterManager.stop();
            this.channelFactory.destroy();
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean switchToCluster(String clusterName) {
        return this.channelFactory.switchToCluster(clusterName);
    }

    @Override
    public boolean switchToDefaultCluster() {
        return this.channelFactory.switchToCluster("___DEFAULT-CLUSTER___");
    }

    private Properties loadFromStream(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new HotRodClientException("Issues configuring from client hotrod-client.properties", e);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> RemoteCache<K, V> createRemoteCache(String cacheName, Boolean forceReturnValueOverride) {
        Map<RemoteCacheKey, RemoteCacheHolder> map = this.cacheName2RemoteCache;
        synchronized (map) {
            RemoteCacheKey key = new RemoteCacheKey(cacheName, forceReturnValueOverride);
            if (!this.cacheName2RemoteCache.containsKey(key)) {
                RemoteCacheImpl<K, V> result = this.createRemoteCache(cacheName);
                RemoteCacheHolder rcc = new RemoteCacheHolder(result, forceReturnValueOverride);
                this.startRemoteCache(rcc);
                PingOperation.PingResult pingResult = result.resolveCompatibility();
                if (!cacheName.equals(DEFAULT_CACHE_NAME) && pingResult == PingOperation.PingResult.CACHE_DOES_NOT_EXIST) {
                    return null;
                }
                result.start();
                this.cacheName2RemoteCache.put(key, rcc);
                return result;
            }
            return this.cacheName2RemoteCache.get((Object)key).remoteCache;
        }
    }

    private <K, V> RemoteCacheImpl<K, V> createRemoteCache(String cacheName) {
        switch (this.configuration.nearCache().mode()) {
            case INVALIDATED: {
                return new InvalidatedNearRemoteCache<K, V>(this, cacheName, this.createNearCacheService(this.configuration.nearCache()));
            }
        }
        return new RemoteCacheImpl(this, cacheName);
    }

    protected <K, V> NearCacheService<K, V> createNearCacheService(NearCacheConfiguration cfg) {
        return NearCacheService.create(cfg, this.listenerNotifier);
    }

    private void startRemoteCache(RemoteCacheHolder remoteCacheHolder) {
        RemoteCacheImpl<?, ?> remoteCache = remoteCacheHolder.remoteCache;
        OperationsFactory operationsFactory = new OperationsFactory(this.channelFactory, remoteCache.getName(), remoteCacheHolder.forceReturnValue, this.codec, this.listenerNotifier, this.configuration);
        remoteCache.init(this.marshaller, operationsFactory, this.configuration.keySizeEstimate(), this.configuration.valueSizeEstimate(), this.configuration.batchSize());
    }

    @Override
    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public static byte[] cacheNameBytes(String cacheName) {
        return cacheName.equals(DEFAULT_CACHE_NAME) ? HotRodConstants.DEFAULT_CACHE_NAME_BYTES : cacheName.getBytes(HotRodConstants.HOTROD_STRING_CHARSET);
    }

    public static byte[] cacheNameBytes() {
        return HotRodConstants.DEFAULT_CACHE_NAME_BYTES;
    }

    public RemoteCacheManagerAdmin administration() {
        OperationsFactory operationsFactory = new OperationsFactory(this.channelFactory, this.codec, this.configuration);
        return new RemoteCacheManagerAdminImpl(this, operationsFactory, EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class), name -> {
            Map<RemoteCacheKey, RemoteCacheHolder> map = this.cacheName2RemoteCache;
            synchronized (map) {
                this.cacheName2RemoteCache.remove(new RemoteCacheKey((String)name, true));
                this.cacheName2RemoteCache.remove(new RemoteCacheKey((String)name, false));
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    CounterManager getCounterManager() {
        return this.counterManager;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    private static class RemoteCacheHolder {
        final RemoteCacheImpl<?, ?> remoteCache;
        final boolean forceReturnValue;

        RemoteCacheHolder(RemoteCacheImpl<?, ?> remoteCache, boolean forceReturnValue) {
            this.remoteCache = remoteCache;
            this.forceReturnValue = forceReturnValue;
        }
    }

    private static class RemoteCacheKey {
        final String cacheName;
        final boolean forceReturnValue;

        RemoteCacheKey(String cacheName, boolean forceReturnValue) {
            this.cacheName = cacheName;
            this.forceReturnValue = forceReturnValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RemoteCacheKey)) {
                return false;
            }
            RemoteCacheKey that = (RemoteCacheKey)o;
            if (this.forceReturnValue != that.forceReturnValue) {
                return false;
            }
            return !(this.cacheName == null ? that.cacheName != null : !this.cacheName.equals(that.cacheName));
        }

        public int hashCode() {
            int result = this.cacheName != null ? this.cacheName.hashCode() : 0;
            result = 31 * result + (this.forceReturnValue ? 1 : 0);
            return result;
        }
    }
}

