/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.Signal;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelPoolCloseEvent;
import org.infinispan.client.hotrod.impl.transport.netty.HintedReplayingDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class HeaderDecoder
extends HintedReplayingDecoder<State> {
    private static final Log log = LogFactory.getLog(HeaderDecoder.class);
    private static final boolean trace = log.isTraceEnabled();
    public static final String NAME = "header-decoder";
    private final Codec codec;
    private final ChannelFactory channelFactory;
    private final ConcurrentMap<Long, HotRodOperation<?>> incomplete = new ConcurrentHashMap();
    private volatile boolean closing;
    private HotRodOperation<?> operation;
    private short status;

    public HeaderDecoder(Codec codec, ChannelFactory channelFactory) {
        super(State.READ_MESSAGE_ID);
        this.codec = codec;
        this.channelFactory = channelFactory;
    }

    public boolean isSharable() {
        return false;
    }

    public void registerOperation(Channel channel, HotRodOperation<?> operation) {
        if (trace) {
            log.tracef("Registering operation %s(%08X) with id %d on %s", new Object[]{operation, System.identityHashCode(operation), operation.header().messageId(), channel});
        }
        if (this.closing) {
            throw log.noMoreOperationsAllowed();
        }
        HotRodOperation<?> prev = this.incomplete.put(operation.header().messageId(), operation);
        assert (prev == null) : "Already registered: " + prev + ", new: " + operation;
        operation.scheduleTimeout(channel.eventLoop());
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            switch ((State)((Object)this.state())) {
                case READ_MESSAGE_ID: {
                    long messageId = this.codec.readMessageId(in);
                    if (messageId == 0L) {
                        this.codec.readHeader(in, null, this.channelFactory, ctx.channel().remoteAddress());
                        throw new IllegalStateException("Should be never reached");
                    }
                    this.operation = (HotRodOperation)this.incomplete.remove(messageId);
                    if (this.operation == null) {
                        throw log.unknownMessageId(messageId);
                    }
                    if (trace) {
                        log.tracef("Response %d belongs to %s on %s", messageId, this.operation, ctx.channel());
                    }
                    this.checkpoint(State.READ_HEADER);
                }
                case READ_HEADER: {
                    if (trace) {
                        log.tracef("Decoding header for %s on %s", this.operation, ctx.channel());
                    }
                    this.status = this.codec.readHeader(in, this.operation.header(), this.channelFactory, ctx.channel().remoteAddress());
                    this.checkpoint(State.READ_PAYLOAD);
                }
                case READ_PAYLOAD: {
                    if (trace) {
                        log.tracef("Decoding payload for %s on %s", this.operation, ctx.channel());
                    }
                    this.operation.acceptResponse(in, this.status, this);
                    this.checkpoint(State.READ_MESSAGE_ID);
                }
            }
        }
        catch (Signal signal) {
            throw signal;
        }
        catch (Exception e) {
            this.checkpoint(State.READ_MESSAGE_ID);
            throw e;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.operation != null) {
            this.operation.exceptionCaught(ctx, cause);
        } else {
            TransportException transportException = log.errorFromUnknownOperation(ctx.channel(), cause, ctx.channel().remoteAddress());
            for (HotRodOperation op : this.incomplete.values()) {
                try {
                    op.exceptionCaught(ctx, transportException);
                }
                catch (Throwable t) {
                    log.errorf(t, "Failed to complete %s", op);
                }
            }
            if (trace) {
                log.tracef(cause, "Requesting %s close due to exception", ctx.channel());
            }
            ctx.close();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        for (HotRodOperation op : this.incomplete.values()) {
            try {
                op.channelInactive(ctx.channel());
            }
            catch (Throwable t) {
                log.errorf(t, "Failed to complete %s", op);
            }
        }
    }

    public CompletableFuture<Void> allCompleteFuture() {
        return CompletableFuture.allOf(this.incomplete.values().toArray(new CompletableFuture[this.incomplete.size()]));
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ChannelPoolCloseEvent) {
            this.closing = true;
            this.allCompleteFuture().whenComplete((nil, throwable) -> ctx.channel().close());
        } else if (evt instanceof IdleStateEvent && !this.incomplete.isEmpty()) {
            return;
        }
        ctx.fireUserEventTriggered(evt);
    }

    @Override
    public void checkpoint() {
        super.checkpoint();
    }

    public int registeredOperations() {
        return this.incomplete.size();
    }

    static enum State {
        READ_MESSAGE_ID,
        READ_HEADER,
        READ_PAYLOAD;

    }
}

