/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.undertow.HttpListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpsListenerResourceDefinition;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.WebsocketsDefinition;
import org.wildfly.extension.undertow.filters.ModClusterDefinition;
import org.wildfly.extension.undertow.handlers.ReverseProxyHandler;

public class UndertowTransformers
implements ExtensionTransformerRegistration {
    private static final ModelVersion MODEL_VERSION_EAP7_0_0 = ModelVersion.create((int)3, (int)1, (int)0);

    public String getSubsystemName() {
        return "undertow";
    }

    public void registerTransformers(SubsystemTransformerRegistration subsystemRegistration) {
        UndertowTransformers.registerTransformers_EAP_7_0_0(subsystemRegistration);
    }

    private static void registerTransformers_EAP_7_0_0(SubsystemTransformerRegistration subsystemRegistration) {
        ResourceTransformationDescriptionBuilder subsystemBuilder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ResourceTransformationDescriptionBuilder serverBuilder = subsystemBuilder.addChildResource(UndertowExtension.SERVER_PATH);
        ResourceTransformationDescriptionBuilder hostBuilder = serverBuilder.addChildResource(UndertowExtension.HOST_PATH);
        DiscardAttributeChecker.DiscardAttributeValueChecker falseDiscardChecker = new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)});
        AttributeTransformationDescriptionBuilder https = (AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)serverBuilder.addChildResource(UndertowExtension.HTTPS_LISTENER_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ListenerResourceDefinition.RFC6265_COOKIE_VALIDATION})).setDiscard((DiscardAttributeChecker)falseDiscardChecker, new AttributeDefinition[]{ListenerResourceDefinition.RFC6265_COOKIE_VALIDATION})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{HttpsListenerResourceDefinition.SSL_CONTEXT})).addRejectCheck(RejectAttributeChecker.UNDEFINED, new String[]{"security-realm"})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{HttpsListenerResourceDefinition.SSL_CONTEXT})).setDiscard((DiscardAttributeChecker)falseDiscardChecker, new AttributeDefinition[]{HttpListenerResourceDefinition.CERTIFICATE_FORWARDING})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{HttpListenerResourceDefinition.CERTIFICATE_FORWARDING})).setDiscard((DiscardAttributeChecker)falseDiscardChecker, new AttributeDefinition[]{HttpListenerResourceDefinition.PROXY_ADDRESS_FORWARDING})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{HttpListenerResourceDefinition.PROXY_ADDRESS_FORWARDING});
        UndertowTransformers.addCommonListenerRules(https).end();
        AttributeTransformationDescriptionBuilder http = (AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)serverBuilder.addChildResource(UndertowExtension.HTTP_LISTENER_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ListenerResourceDefinition.RFC6265_COOKIE_VALIDATION})).setDiscard((DiscardAttributeChecker)falseDiscardChecker, new AttributeDefinition[]{ListenerResourceDefinition.RFC6265_COOKIE_VALIDATION});
        UndertowTransformers.addCommonListenerRules(http).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)serverBuilder.addChildResource(UndertowExtension.AJP_LISTENER_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ListenerResourceDefinition.RFC6265_COOKIE_VALIDATION})).setDiscard((DiscardAttributeChecker)falseDiscardChecker, new AttributeDefinition[]{ListenerResourceDefinition.RFC6265_COOKIE_VALIDATION})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(UndertowExtension.PATH_SERVLET_CONTAINER).getAttributeBuilder().setDiscard((DiscardAttributeChecker)falseDiscardChecker, new AttributeDefinition[]{ServletContainerDefinition.DISABLE_FILE_WATCH_SERVICE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ServletContainerDefinition.DISABLE_FILE_WATCH_SERVICE})).setDiscard((DiscardAttributeChecker)falseDiscardChecker, new AttributeDefinition[]{ServletContainerDefinition.DISABLE_SESSION_ID_REUSE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ServletContainerDefinition.DISABLE_SESSION_ID_REUSE})).end().addChildResource(UndertowExtension.PATH_WEBSOCKETS).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"per-message-deflate", "deflater-level"})).setDiscard((DiscardAttributeChecker)falseDiscardChecker, new AttributeDefinition[]{WebsocketsDefinition.PER_MESSAGE_DEFLATE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(0)}), new AttributeDefinition[]{WebsocketsDefinition.DEFLATER_LEVEL})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(UndertowExtension.PATH_HANDLERS).addChildResource(PathElement.pathElement((String)"reverse-proxy")).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(1L)}), new String[]{"max-retries"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"max-retries"})).setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter(ReverseProxyHandler.CONNECTIONS_PER_THREAD), new AttributeDefinition[]{ReverseProxyHandler.CONNECTIONS_PER_THREAD})).end().addChildResource(PathElement.pathElement((String)"host")).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{HttpsListenerResourceDefinition.SSL_CONTEXT})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"ssl-context"})).setDiscard(DiscardAttributeChecker.ALWAYS, new String[]{"enable-http2"})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(UndertowExtension.PATH_FILTERS).addChildResource(PathElement.pathElement((String)"mod-cluster")).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{ModClusterDefinition.FAILOVER_STRATEGY.getDefaultValue()}), new AttributeDefinition[]{ModClusterDefinition.FAILOVER_STRATEGY})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{ModClusterDefinition.MAX_RETRIES.getDefaultValue()}), new AttributeDefinition[]{ModClusterDefinition.MAX_RETRIES})).setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter((AttributeDefinition)ModClusterDefinition.MAX_AJP_PACKET_SIZE), new AttributeDefinition[]{ModClusterDefinition.MAX_AJP_PACKET_SIZE})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{HttpsListenerResourceDefinition.SSL_CONTEXT})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ModClusterDefinition.MAX_RETRIES, ModClusterDefinition.FAILOVER_STRATEGY})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{ModClusterDefinition.MAX_AJP_PACKET_SIZE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{HttpsListenerResourceDefinition.SSL_CONTEXT})).addRejectCheck(RejectAttributeChecker.UNDEFINED, new String[]{"security-realm"})).end();
        hostBuilder.rejectChildResource(UndertowExtension.PATH_HTTP_INVOKER);
        subsystemBuilder.rejectChildResource(UndertowExtension.PATH_APPLICATION_SECURITY_DOMAIN);
        TransformationDescription.Tools.register((TransformationDescription)subsystemBuilder.build(), (SubsystemTransformerRegistration)subsystemRegistration, (ModelVersionRange)MODEL_VERSION_EAP7_0_0);
    }

    private static AttributeTransformationDescriptionBuilder addCommonListenerRules(AttributeTransformationDescriptionBuilder builder) {
        return (AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleRejectAttributeChecker(new ModelNode(true)), new String[]{HttpListenerResourceDefinition.REQUIRE_HOST_HTTP11.getName()})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{HttpListenerResourceDefinition.REQUIRE_HOST_HTTP11})).setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter((AttributeDefinition)HttpListenerResourceDefinition.HTTP2_HEADER_TABLE_SIZE), new AttributeDefinition[]{HttpListenerResourceDefinition.HTTP2_HEADER_TABLE_SIZE})).setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter((AttributeDefinition)HttpListenerResourceDefinition.HTTP2_INITIAL_WINDOW_SIZE), new AttributeDefinition[]{HttpListenerResourceDefinition.HTTP2_INITIAL_WINDOW_SIZE})).setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter((AttributeDefinition)HttpListenerResourceDefinition.HTTP2_MAX_FRAME_SIZE), new AttributeDefinition[]{HttpListenerResourceDefinition.HTTP2_MAX_FRAME_SIZE});
    }
}

