/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.util.ByteString;

public class CacheXid {
    public static final AdvancedExternalizer<CacheXid> EXTERNALIZER = new Externalizer();
    private final ByteString cacheName;
    private final XidImpl xid;

    CacheXid(ByteString cacheName, XidImpl xid) {
        this.cacheName = cacheName;
        this.xid = xid;
    }

    public static void writeTo(ObjectOutput output, CacheXid object) throws IOException {
        ByteString.writeObject((ObjectOutput)output, (ByteString)object.cacheName);
        XidImpl.writeTo((ObjectOutput)output, (XidImpl)object.xid);
    }

    public static CacheXid readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        return new CacheXid(ByteString.readObject((ObjectInput)input), XidImpl.readFrom((ObjectInput)input));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheXid cacheXid = (CacheXid)o;
        return this.cacheName.equals((Object)cacheXid.cacheName) && this.xid.equals((Object)cacheXid.xid);
    }

    public int hashCode() {
        int result = this.cacheName.hashCode();
        result = 31 * result + this.xid.hashCode();
        return result;
    }

    public String toString() {
        return "CacheXid{cacheName=" + this.cacheName + ", xid=" + this.xid + '}';
    }

    private static class Externalizer
    implements AdvancedExternalizer<CacheXid> {
        private Externalizer() {
        }

        public Set<Class<? extends CacheXid>> getTypeClasses() {
            return Collections.singleton(CacheXid.class);
        }

        public Integer getId() {
            return 1114;
        }

        public void writeObject(ObjectOutput output, CacheXid object) throws IOException {
            CacheXid.writeTo(output, object);
        }

        public CacheXid readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return CacheXid.readFrom(input);
        }
    }
}

