/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.upgrade;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.io.ByteBuffer;
import org.infinispan.marshall.BufferSizePredictor;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.FileLookup;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.Util;

public class RollingUpgradeSynchronizer {
    private final Properties oldCluster;
    private final Properties newCluster;
    private final String cacheName;
    private int threads;

    public static void main(String[] args) throws UnsupportedEncodingException {
        RollingUpgradeSynchronizer r = new RollingUpgradeSynchronizer(args);
        r.start();
    }

    public RollingUpgradeSynchronizer(String[] args) {
        if (args.length < 2) {
            RollingUpgradeSynchronizer.helpAndExit();
        }
        String oldClusterCfg = args[0];
        String newClusterCfg = args[1];
        this.oldCluster = RollingUpgradeSynchronizer.readProperties(oldClusterCfg);
        this.newCluster = RollingUpgradeSynchronizer.readProperties(newClusterCfg);
        this.cacheName = args.length >= 3 ? args[2] : "___defaultcache";
        this.threads = Runtime.getRuntime().availableProcessors();
        if (args.length >= 4) {
            try {
                this.threads = Integer.parseInt(args[3]);
            }
            catch (Exception e) {
                System.out.printf("  WARN: parameter %s should represent the nunber of threads to use, and be an integer. Using the default number of threads instead.%n", args[3]);
            }
        }
    }

    private static void helpAndExit() {
        System.out.println("  Usage: RollingUpgradeSynchronizer <old cluster properties file> <new cluster properties file> <cache name> <num threads to use>");
        System.out.println();
        System.out.println("         The last two parameters are optional, defaulting to the default cache and number of processors, respectively.");
        System.out.println();
        System.exit(0);
    }

    private static Properties readProperties(String propsFile) {
        try {
            Properties p = new Properties();
            FileLookup lookup = FileLookupFactory.newInstance();
            p.load(lookup.lookupFile(propsFile, RollingUpgradeSynchronizer.class.getClassLoader()));
            return p;
        }
        catch (Exception e) {
            System.out.printf("  FATAL: Unable to load properties file %s!  Exiting!%n", propsFile);
            System.exit(-1);
            return null;
        }
    }

    private void start() {
        long start = System.currentTimeMillis();
        MigrationMarshaller m = new MigrationMarshaller();
        RemoteCacheManager rcmOld = new RemoteCacheManager((Marshaller)m, this.oldCluster);
        final RemoteCacheManager rcmNew = new RemoteCacheManager((Marshaller)m, this.newCluster);
        Set keys = (Set)rcmOld.getCache(this.cacheName).get((Object)"___MigrationManager_HotRod_KnownKeys___");
        System.out.printf(">> Retrieved %s keys stored in cache %s on the old cluster.%n", keys.size(), this.cacheName);
        ExecutorService es = Executors.newFixedThreadPool(this.threads);
        final AtomicInteger count = new AtomicInteger(0);
        for (final ByteArrayKey key : keys) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    rcmNew.getCache(RollingUpgradeSynchronizer.this.cacheName).get((Object)key.getData());
                    int i = count.get();
                    if (i % 100 == 0) {
                        System.out.printf(">>    Moved %s keys%n", i);
                    }
                }
            });
            count.getAndIncrement();
        }
        es.shutdown();
        while (!es.isShutdown()) {
            LockSupport.parkNanos(TimeUnit.NANOSECONDS.convert(100L, TimeUnit.MILLISECONDS));
        }
        System.out.printf(">> Transferred %s entries in cache %s from the old cluster to the new, in %s%n", keys.size(), this.cacheName, Util.prettyPrintTime((long)(System.currentTimeMillis() - start)));
    }

    private static class MigrationMarshaller
    implements Marshaller {
        private final Marshaller delegate = new GenericJBossMarshaller();

        private MigrationMarshaller() {
        }

        public byte[] objectToByteBuffer(Object o, int i) throws IOException, InterruptedException {
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            return this.delegate.objectToByteBuffer(o, i);
        }

        public byte[] objectToByteBuffer(Object o) throws IOException, InterruptedException {
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            return this.delegate.objectToByteBuffer(o);
        }

        public Object objectFromByteBuffer(byte[] bytes) throws IOException, ClassNotFoundException {
            return this.delegate.objectFromByteBuffer(bytes);
        }

        public Object objectFromByteBuffer(byte[] bytes, int i, int i1) throws IOException, ClassNotFoundException {
            return this.delegate.objectFromByteBuffer(bytes, i, i1);
        }

        public ByteBuffer objectToBuffer(Object o) throws IOException, InterruptedException {
            if (o instanceof byte[]) {
                byte[] bytes = (byte[])o;
                return new ByteBuffer(bytes, 0, bytes.length);
            }
            return this.delegate.objectToBuffer(o);
        }

        public boolean isMarshallable(Object o) throws Exception {
            return o instanceof byte[] || this.delegate.isMarshallable(o);
        }

        public BufferSizePredictor getBufferSizePredictor(Object o) {
            return this.delegate.getBufferSizePredictor(o);
        }
    }
}

