/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Map;
import org.jboss.as.network.SocketBindingManager;
import org.jgroups.util.SocketFactory;

public class ManagedSocketFactory
implements SocketFactory {
    private final SocketFactory factory;
    private final SocketBindingManager manager;

    public ManagedSocketFactory(SocketFactory factory, SocketBindingManager manager) {
        this.factory = factory;
        this.manager = manager;
    }

    public Socket createSocket(String name) throws IOException {
        return this.register(this.factory.createSocket(name));
    }

    public Socket createSocket(String name, String host, int port) throws IOException {
        return this.register(this.factory.createSocket(name, host, port));
    }

    public Socket createSocket(String name, InetAddress address, int port) throws IOException {
        return this.register(this.factory.createSocket(name, address, port));
    }

    public Socket createSocket(String name, String host, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.register(this.factory.createSocket(name, host, port, localAddress, localPort));
    }

    public Socket createSocket(String name, InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.register(this.factory.createSocket(name, address, port, localAddress, localPort));
    }

    private Socket register(Socket socket) {
        this.manager.getUnnamedRegistry().registerSocket(socket);
        return socket;
    }

    public ServerSocket createServerSocket(String name) throws IOException {
        return this.register(this.factory.createServerSocket(name));
    }

    public ServerSocket createServerSocket(String name, int port) throws IOException {
        return this.register(this.factory.createServerSocket(name, port));
    }

    public ServerSocket createServerSocket(String name, int port, int backlog) throws IOException {
        return this.register(this.factory.createServerSocket(name, port, backlog));
    }

    public ServerSocket createServerSocket(String name, int port, int backlog, InetAddress bindAddr) throws IOException {
        return this.register(this.factory.createServerSocket(name, port, backlog, bindAddr));
    }

    private ServerSocket register(ServerSocket socket) {
        this.manager.getUnnamedRegistry().registerSocket(socket);
        return socket;
    }

    public DatagramSocket createDatagramSocket(String name) throws SocketException {
        return this.register(this.factory.createDatagramSocket(name));
    }

    public DatagramSocket createDatagramSocket(String name, SocketAddress bindAddress) throws SocketException {
        return this.register(this.factory.createDatagramSocket(name, bindAddress));
    }

    public DatagramSocket createDatagramSocket(String name, int port) throws SocketException {
        return this.register(this.factory.createDatagramSocket(name, port));
    }

    public DatagramSocket createDatagramSocket(String name, int port, InetAddress localAddress) throws SocketException {
        return this.register(this.factory.createDatagramSocket(name, port, localAddress));
    }

    private DatagramSocket register(DatagramSocket socket) {
        this.manager.getUnnamedRegistry().registerSocket(socket);
        return socket;
    }

    public MulticastSocket createMulticastSocket(String name) throws IOException {
        return this.register(this.factory.createMulticastSocket(name));
    }

    public MulticastSocket createMulticastSocket(String name, int port) throws IOException {
        return this.register(this.factory.createMulticastSocket(name, port));
    }

    public MulticastSocket createMulticastSocket(String name, SocketAddress bindAddress) throws IOException {
        return this.register(this.factory.createMulticastSocket(name, bindAddress));
    }

    private MulticastSocket register(MulticastSocket socket) {
        this.manager.getUnnamedRegistry().registerSocket((DatagramSocket)socket);
        return socket;
    }

    public void close(Socket socket) throws IOException {
        if (socket != null) {
            this.manager.getUnnamedRegistry().unregisterSocket(socket);
            this.factory.close(socket);
        }
    }

    public void close(ServerSocket socket) throws IOException {
        if (socket != null) {
            this.manager.getUnnamedRegistry().unregisterSocket(socket);
            this.factory.close(socket);
        }
    }

    public void close(DatagramSocket socket) {
        if (socket != null) {
            this.manager.getUnnamedRegistry().unregisterSocket(socket);
            this.factory.close(socket);
        }
    }

    public Map<Object, String> getSockets() {
        return this.factory.getSockets();
    }
}

