/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout;

import io.appulse.utils.Bytes;
import io.appulse.utils.SerializationUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public interface Serializer<T> {
    public static final Serializer<Byte> BYTE = new ByteSerializer();
    public static final Serializer<Short> SHORT = new ShortSerializer();
    public static final Serializer<Character> CHARACTER = new CharacterSerializer();
    public static final Serializer<Integer> INTEGER = new IntegerSerializer();
    public static final Serializer<Long> LONG = new LongSerializer();
    public static final Serializer<Float> FLOAT = new FloatSerializer();
    public static final Serializer<Double> DOUBLE = new DoubleSerializer();
    public static final Serializer<BigInteger> BIG_INTEGER = new BigIntegerSerializer();
    public static final Serializer<BigDecimal> BIG_DECIMAL = new BigDecimalSerializer();
    public static final Serializer<byte[]> BYTE_ARRAY = new ByteArraySerializer();
    public static final Serializer<String> STRING = new StringSerializer();

    public void serialize(T var1, Bytes var2);

    public static class StringSerializer
    implements Serializer<String> {
        @Override
        public void serialize(String object, Bytes buffer) {
            byte[] bytes = object.getBytes(StandardCharsets.UTF_8);
            buffer.write4B(bytes.length);
            buffer.writeNB(bytes);
        }
    }

    public static class ByteArraySerializer
    implements Serializer<byte[]> {
        @Override
        public void serialize(byte[] object, Bytes buffer) {
            buffer.write4B(object.length);
            buffer.writeNB(object);
        }
    }

    public static class BigDecimalSerializer
    implements Serializer<BigDecimal> {
        @Override
        public void serialize(BigDecimal object, Bytes buffer) {
            BigInteger unscaledValue = object.unscaledValue();
            byte[] bytes = unscaledValue.toByteArray();
            buffer.write4B(bytes.length);
            buffer.writeNB(bytes);
            buffer.write4B(object.scale());
        }
    }

    public static class BigIntegerSerializer
    implements Serializer<BigInteger> {
        @Override
        public void serialize(BigInteger object, Bytes buffer) {
            byte[] bytes = object.toByteArray();
            buffer.write4B(bytes.length);
            buffer.writeNB(bytes);
        }
    }

    public static class DoubleSerializer
    implements Serializer<Double> {
        @Override
        public void serialize(Double object, Bytes buffer) {
            buffer.write8B(object.doubleValue());
        }
    }

    public static class FloatSerializer
    implements Serializer<Float> {
        @Override
        public void serialize(Float object, Bytes buffer) {
            buffer.write4B(object.floatValue());
        }
    }

    public static class LongSerializer
    implements Serializer<Long> {
        @Override
        public void serialize(Long object, Bytes buffer) {
            buffer.write8B(object.longValue());
        }
    }

    public static class IntegerSerializer
    implements Serializer<Integer> {
        @Override
        public void serialize(Integer object, Bytes buffer) {
            buffer.write4B(object.intValue());
        }
    }

    public static class CharacterSerializer
    implements Serializer<Character> {
        @Override
        public void serialize(Character object, Bytes buffer) {
            buffer.write2B(object.charValue());
        }
    }

    public static class ShortSerializer
    implements Serializer<Short> {
        @Override
        public void serialize(Short object, Bytes buffer) {
            buffer.write2B(object.shortValue());
        }
    }

    public static class ByteSerializer
    implements Serializer<Byte> {
        @Override
        public void serialize(Byte object, Bytes buffer) {
            buffer.write1B(object.byteValue());
        }
    }

    public static class DefaultSerializer<T>
    implements Serializer<T> {
        @Override
        public void serialize(T object, Bytes buffer) {
            if (!(object instanceof Serializable)) {
                String msg = "Default serializer allows only objects which implement java.io.Serializable interface";
                throw new IllegalArgumentException("Default serializer allows only objects which implement java.io.Serializable interface");
            }
            Serializable serializable = (Serializable)object;
            byte[] bytes = SerializationUtils.serialize((Serializable)serializable);
            BYTE_ARRAY.serialize(bytes, buffer);
        }
    }
}

