/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.batched;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.utils.Bytes;
import io.appulse.utils.ReadBytesUtils;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infobip.lib.popout.Deserializer;
import org.infobip.lib.popout.Serializer;
import org.infobip.lib.popout.backend.WalContent;

class QueueSerializer<T> {
    private final Serializer<T> serializer;
    private final Deserializer<T> deserializer;

    QueueSerializer(Serializer<T> serializer, Deserializer<T> deserializer) {
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    void serialize(Queue<T> collection, Bytes buffer) {
        buffer.reset().write4B(collection.size());
        collection.forEach(item -> {
            int writerIndex = buffer.writerIndex();
            buffer.write4B(0);
            this.serializer.serialize(item, buffer);
            buffer.set4B(writerIndex, buffer.writerIndex() - writerIndex - 4);
        });
    }

    Queue<T> deserialize(Bytes buffer) {
        return IntStream.range(0, buffer.readInt()).mapToObj(it -> this.deserializeItem(buffer)).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedList::new));
    }

    int getQueueLength(WalContent walContent) {
        ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
        walContent.open((length, channel) -> ReadBytesUtils.read((ReadableByteChannel)channel, (ByteBuffer)lengthBuffer));
        lengthBuffer.flip();
        return lengthBuffer.getInt();
    }

    Iterator<T> toIterator(WalContent walContent) {
        return new WalContentIterator(walContent);
    }

    private T deserializeItem(Bytes buffer) {
        int length = 0;
        while (buffer.isReadable(4) && (length = buffer.readInt()) < 0) {
            int jump = Math.abs(length);
            if (buffer.isReadable(jump)) {
                return null;
            }
            int newReaderPosition = buffer.readerIndex() + jump;
            buffer.readerIndex(newReaderPosition);
        }
        return this.deserializer.deserialize(length, buffer);
    }

    @SuppressFBWarnings(justification="generated code")
    public static <T> QueueSerializerBuilder<T> builder() {
        return new QueueSerializerBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public static class QueueSerializerBuilder<T> {
        @SuppressFBWarnings(justification="generated code")
        private Serializer<T> serializer;
        @SuppressFBWarnings(justification="generated code")
        private Deserializer<T> deserializer;

        @SuppressFBWarnings(justification="generated code")
        QueueSerializerBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public QueueSerializerBuilder<T> serializer(Serializer<T> serializer) {
            this.serializer = serializer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public QueueSerializerBuilder<T> deserializer(Deserializer<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public QueueSerializer<T> build() {
            return new QueueSerializer<T>(this.serializer, this.deserializer);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "QueueSerializer.QueueSerializerBuilder(serializer=" + this.serializer + ", deserializer=" + this.deserializer + ")";
        }
    }

    private class WalContentIterator
    implements Iterator<T> {
        WalContent walContent;
        int index;
        int elements;
        long currentPosition;
        long nextPosition;
        Bytes buffer;
        T nextItem;

        WalContentIterator(WalContent walContent) {
            this.walContent = walContent;
            this.elements = QueueSerializer.this.getQueueLength(walContent);
            this.nextPosition = walContent.getOffset() + 4L;
            this.buffer = Bytes.resizableArray((int)32);
        }

        @Override
        public boolean hasNext() {
            if (this.nextItem != null) {
                return true;
            }
            if (this.index >= this.elements) {
                return false;
            }
            this.walContent.open((walContentLength, channel) -> {
                int length;
                int readed;
                block5: {
                    long limit = channel.position() + (long)walContentLength.intValue();
                    int minRecordLength = 4;
                    if (limit <= this.nextPosition + 4L) {
                        return;
                    }
                    do {
                        channel.position(this.nextPosition);
                        this.buffer.reset();
                        readed = ReadBytesUtils.read((ReadableByteChannel)channel, (Bytes)this.buffer, (int)4);
                        if (readed < 4) {
                            throw new IllegalStateException();
                        }
                        length = this.buffer.readInt();
                        if (length >= 0) break block5;
                        this.nextPosition += (long)(4 + Math.abs(length));
                    } while (limit > this.nextPosition + 4L);
                    return;
                }
                if (!this.buffer.isWritable(length)) {
                    int newCapacity = this.buffer.writerIndex() + length;
                    this.buffer.capacity(newCapacity);
                }
                if ((readed = ReadBytesUtils.read((ReadableByteChannel)channel, (Bytes)this.buffer, (int)length)) < length) {
                    throw new IllegalStateException();
                }
                this.buffer.readerIndex(0);
                this.nextItem = QueueSerializer.this.deserializeItem(this.buffer);
                this.currentPosition = this.nextPosition;
                this.nextPosition = channel.position();
            });
            return this.nextItem != null;
        }

        @Override
        public T next() {
            if (this.nextItem != null || this.hasNext()) {
                Object result = this.nextItem;
                this.nextItem = null;
                ++this.index;
                return result;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.walContent.open((walContentLength, channel) -> {
                channel.position(this.currentPosition);
                ByteBuffer buf = ByteBuffer.allocate(4);
                int readed = channel.read(buf);
                if (readed < 4) {
                    throw new IllegalStateException();
                }
                buf.flip();
                int length = buf.getInt();
                buf.putInt(0, -length);
                buf.flip();
                channel.position(this.currentPosition);
                int written = channel.write(buf);
                if (written < 4) {
                    throw new IllegalStateException();
                }
                this.nextPosition = channel.position() + (long)length;
            });
        }
    }
}

