/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.synced;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.utils.Bytes;
import io.appulse.utils.ReadBytesUtils;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.LongAdder;
import lombok.NonNull;
import org.infobip.lib.popout.FileQueue;
import org.infobip.lib.popout.QueueLimit;
import org.infobip.lib.popout.ReadWriteBytesPool;
import org.infobip.lib.popout.backend.FileSystemBackend;
import org.infobip.lib.popout.backend.WalContent;
import org.infobip.lib.popout.synced.ItemSerialization;
import org.infobip.lib.popout.synced.SyncedFileQueueBuilder;

class SyncedFileQueue<T>
extends FileQueue<T> {
    @SuppressFBWarnings(justification="generated code")
    private final Object $lock = new Object[0];
    private final LongAdder size;
    private final FileSystemBackend backend;
    private final ItemSerialization<T> serialization;
    private final QueueLimit<T> limit;

    SyncedFileQueue(@NonNull SyncedFileQueueBuilder<T> builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked @NonNull but is null");
        }
        this.limit = builder.getLimit();
        this.serialization = ItemSerialization.builder().serializer(builder.getSerializer()).deserializer(builder.getDeserializer()).build();
        this.backend = FileSystemBackend.builder().queueName(builder.getName()).restoreFromDisk(builder.isRestoreFromDisk()).walConfig(builder.getWalFilesConfig()).compressedConfig(builder.getCompressedFilesConfig()).build();
        this.size = new LongAdder();
        Iterator<WalContent> iterator = this.backend.iterator();
        while (iterator.hasNext()) {
            this.size.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(@NonNull T value) {
        Object object = this.$lock;
        synchronized (object) {
            if (value == null) {
                throw new NullPointerException("value is marked @NonNull but is null");
            }
            if (this.limit.isExceeded(this)) {
                this.limit.handle(value, this);
                return false;
            }
            ReadWriteBytesPool.getInstance().borrow(buffer -> {
                this.serialization.serialize(value, buffer);
                this.backend.write(buffer);
                return null;
            });
            this.size.increment();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll() {
        Object object = this.$lock;
        synchronized (object) {
            return (T)ReadWriteBytesPool.getInstance().borrow(buffer -> {
                int readed = this.backend.pollTo(buffer);
                if (readed <= 0) {
                    return null;
                }
                this.size.decrement();
                return this.serialization.deserialize(buffer);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T peek() {
        Object object = this.$lock;
        synchronized (object) {
            return (T)ReadWriteBytesPool.getInstance().borrow(buffer -> {
                int readed = this.backend.peakTo(buffer);
                return readed > 0 ? this.serialization.deserialize(buffer) : null;
            });
        }
    }

    @Override
    public int size() {
        return this.size.intValue();
    }

    @Override
    public long longSize() {
        return this.size.longValue();
    }

    @Override
    public long diskSize() {
        return this.backend.diskSize();
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compress() {
        Object object = this.$lock;
        synchronized (object) {
            this.backend.compress();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new SyncedFileQueueIterator();
    }

    @Override
    public void close() {
    }

    private class SyncedFileQueueIterator
    implements Iterator<T> {
        Iterator<WalContent> walContentsIterator;
        Bytes buffer;
        WalContent nextWalContent;

        private SyncedFileQueueIterator() {
            this.walContentsIterator = SyncedFileQueue.this.backend.iterator();
            this.buffer = Bytes.resizableArray((int)32);
        }

        @Override
        public boolean hasNext() {
            if (this.nextWalContent != null) {
                return true;
            }
            if (!this.walContentsIterator.hasNext()) {
                return false;
            }
            this.nextWalContent = this.walContentsIterator.next();
            return true;
        }

        @Override
        public T next() {
            if (this.nextWalContent != null || this.hasNext()) {
                WalContent walContent = this.nextWalContent;
                this.nextWalContent = null;
                walContent.open((length, channel) -> {
                    this.buffer.reset();
                    if (!this.buffer.isWritable(length.intValue())) {
                        int newCapacity = this.buffer.writerIndex() + length;
                        this.buffer.capacity(newCapacity);
                    }
                    ReadBytesUtils.read((ReadableByteChannel)channel, (Bytes)this.buffer);
                });
                return SyncedFileQueue.this.serialization.deserialize(this.buffer);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.walContentsIterator.remove();
            SyncedFileQueue.this.size.decrement();
        }
    }
}

