/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.backend;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.utils.Bytes;
import io.appulse.utils.ReadBytesUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import lombok.NonNull;
import org.infobip.lib.popout.CompressedFilesConfig;
import org.infobip.lib.popout.backend.CompressedFileIteratorManyFiles;
import org.infobip.lib.popout.backend.CompressionResult;
import org.infobip.lib.popout.backend.FilesManager;
import org.infobip.lib.popout.backend.RecordHeader;
import org.infobip.lib.popout.backend.WalContent;

class CompressedFiles
implements Iterable<WalContent> {
    private static final byte[] CLEAR = new byte[8192];
    private final FilesManager files;
    private final long maxFileSizeBytes;

    CompressedFiles(@NonNull String queueName, @NonNull Boolean restoreFromDisk, @NonNull CompressedFilesConfig config) {
        if (queueName == null) {
            throw new NullPointerException("queueName is marked @NonNull but is null");
        }
        if (restoreFromDisk == null) {
            throw new NullPointerException("restoreFromDisk is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        this.files = FilesManager.builder().folder(config.getFolder()).prefix(queueName + '-').suffix(".compressed").build();
        if (!restoreFromDisk.booleanValue()) {
            this.files.clear();
        }
        this.maxFileSizeBytes = config.getMaxSizeBytes();
    }

    int peekContentPart(@NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        return this.readContent((channel, header) -> {
            int length = header.getLength();
            if (buffer.isWritable(length)) {
                int newCapacity = buffer.writerIndex() + length;
                buffer.capacity(newCapacity);
            }
            return ReadBytesUtils.read((ReadableByteChannel)channel, (Bytes)buffer, (int)length);
        });
    }

    int pollContentPart(@NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        return this.readContent((channel, header) -> {
            int length = header.getLength();
            if (!buffer.isWritable(length)) {
                int newCapacity = buffer.writerIndex() + length;
                buffer.capacity(newCapacity);
            }
            int result = ReadBytesUtils.read((ReadableByteChannel)channel, (Bytes)buffer, (int)length);
            long position = channel.position();
            if (!header.skipJumps(channel).isEnd()) {
                header.writeJump(channel, 0L, position);
            }
            return result;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readContent(RecordReader reader) {
        RecordHeader header = new RecordHeader();
        while (true) {
            Throwable throwable;
            FileChannel channel;
            boolean shouldRemoveFile;
            Path file;
            block23: {
                int n;
                if ((file = this.files.peek()) == null) {
                    return 0;
                }
                shouldRemoveFile = false;
                try {
                    block24: {
                        block25: {
                            channel = FileChannel.open(file, StandardOpenOption.READ, StandardOpenOption.WRITE);
                            throwable = null;
                            try {
                                header.skipJumps(channel);
                                if (header.isEnd()) {
                                    shouldRemoveFile = true;
                                    break block23;
                                }
                                int readed = reader.read(channel, header);
                                if (readed == 0 || header.isEnd()) {
                                    shouldRemoveFile = true;
                                }
                                if (readed <= 0) break block23;
                                n = readed;
                                if (channel == null) break block24;
                                if (throwable == null) break block25;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (channel == null) throw throwable3;
                                    if (throwable == null) {
                                        channel.close();
                                        throw throwable3;
                                    }
                                    try {
                                        channel.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                            }
                            try {
                                channel.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            break block24;
                        }
                        channel.close();
                    }
                    if (!shouldRemoveFile) return n;
                }
                catch (Throwable throwable6) {
                    if (!shouldRemoveFile) throw throwable6;
                    this.files.remove(file);
                    throw throwable6;
                }
                this.files.remove(file);
                return n;
            }
            if (channel != null) {
                if (throwable != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    channel.close();
                }
            }
            if (!shouldRemoveFile) continue;
            this.files.remove(file);
        }
    }

    CompressionResult compress(@NonNull Collection<Path> walFiles) {
        if (walFiles == null) {
            throw new NullPointerException("walFiles is marked @NonNull but is null");
        }
        CompressionResult result = new CompressionResult(new ArrayList<Path>(), new ArrayList<Path>(walFiles));
        if (walFiles.isEmpty()) {
            return result;
        }
        Path file = this.files.createNextFile();
        long walFilesSumSize = walFiles.stream().mapToLong(this::getSizeWithHeader).sum() + 9L;
        long needToAllocate = Math.min(walFilesSumSize, this.maxFileSizeBytes);
        long allocated = this.allocate(file, needToAllocate) - 9L;
        RecordHeader header = new RecordHeader();
        try (FileChannel channel = FileChannel.open(file, StandardOpenOption.WRITE);){
            for (Path walFile : walFiles) {
                long size = Files.size(walFile);
                if (channel.position() + 9L + size > allocated) break;
                header.writeRecord(channel, size);
                try (FileChannel walFileChannel = FileChannel.open(walFile, new OpenOption[0]);){
                    walFileChannel.transferTo(0L, walFileChannel.size(), channel);
                }
                result.getCompressed().add(walFile);
                result.getRemaining().remove(walFile);
            }
            header.writeEnd(channel);
        }
        return result;
    }

    Collection<Path> getFiles() {
        return this.files.getFilesFromQueue();
    }

    long diskSize() {
        long result = 0L;
        for (Path file : this.getFiles()) {
            result += Files.size(file);
        }
        return result;
    }

    @Override
    public Iterator<WalContent> iterator() {
        return new CompressedFileIteratorManyFiles(this.files.getFilesFromQueue());
    }

    private long getSizeWithHeader(Path path) {
        return 9L + Files.size(path);
    }

    private long allocate(Path path, long size) {
        int allocated = 0;
        try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            while ((long)allocated < size) {
                int bufferSize = (int)Math.min((long)CLEAR.length, size - (long)allocated);
                out.write(CLEAR, 0, bufferSize);
                allocated += bufferSize;
            }
        }
        return allocated;
    }

    @SuppressFBWarnings(justification="generated code")
    public static CompressedFilesBuilder builder() {
        return new CompressedFilesBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public static class CompressedFilesBuilder {
        @SuppressFBWarnings(justification="generated code")
        private String queueName;
        @SuppressFBWarnings(justification="generated code")
        private Boolean restoreFromDisk;
        @SuppressFBWarnings(justification="generated code")
        private CompressedFilesConfig config;

        @SuppressFBWarnings(justification="generated code")
        CompressedFilesBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public CompressedFilesBuilder queueName(@NonNull String queueName) {
            if (queueName == null) {
                throw new NullPointerException("queueName is marked @NonNull but is null");
            }
            this.queueName = queueName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public CompressedFilesBuilder restoreFromDisk(@NonNull Boolean restoreFromDisk) {
            if (restoreFromDisk == null) {
                throw new NullPointerException("restoreFromDisk is marked @NonNull but is null");
            }
            this.restoreFromDisk = restoreFromDisk;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public CompressedFilesBuilder config(@NonNull CompressedFilesConfig config) {
            if (config == null) {
                throw new NullPointerException("config is marked @NonNull but is null");
            }
            this.config = config;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public CompressedFiles build() {
            return new CompressedFiles(this.queueName, this.restoreFromDisk, this.config);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "CompressedFiles.CompressedFilesBuilder(queueName=" + this.queueName + ", restoreFromDisk=" + this.restoreFromDisk + ", config=" + this.config + ")";
        }
    }

    @FunctionalInterface
    static interface RecordReader {
        public int read(FileChannel var1, RecordHeader var2) throws IOException;
    }
}

