/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.backend;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;

final class FilesManager {
    private final AtomicInteger index;
    private final Queue<Path> queue;
    private final Path folder;
    private final String prefix;
    private final String suffix;
    private final Pattern fileNamePattern;
    private final Pattern fileIndexPattern;

    FilesManager(@NonNull Path folder, String prefix, String suffix) {
        if (folder == null) {
            throw new NullPointerException("folder is marked @NonNull but is null");
        }
        this.index = new AtomicInteger(0);
        this.folder = folder;
        this.prefix = Optional.ofNullable(prefix).map(String::trim).orElse("");
        this.suffix = Optional.ofNullable(suffix).map(String::trim).orElse("");
        String fileNameRegex = String.format(Locale.ENGLISH, "^%s\\d+%s$", this.prefix, this.suffix);
        this.fileNamePattern = Pattern.compile(fileNameRegex);
        String fileIndexRegex = String.format(Locale.ENGLISH, "^%s(?<index>\\d+)%s$", this.prefix, this.suffix);
        this.fileIndexPattern = Pattern.compile(fileIndexRegex);
        this.queue = this.getFilesFromFileSystem();
        if (!this.queue.isEmpty()) {
            Path[] array = this.queue.toArray(new Path[0]);
            Path lastPath = array[array.length - 1];
            int lastPathIndex = this.getIndex(lastPath);
            this.index.set(lastPathIndex + 1);
        }
    }

    Queue<Path> getFilesFromQueue() {
        return this.queue;
    }

    Queue<Path> getFilesFromFileSystem() {
        Predicate<Path> byNamePattern = path -> Optional.ofNullable(path).map(Path::getFileName).filter(Objects::nonNull).map(Path::toString).map(this.fileNamePattern::matcher).map(Matcher::matches).orElse(false);
        return Files.list(this.folder).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(byNamePattern).sorted(Comparator.comparing(this::getIndex)).collect(Collectors.toCollection(LinkedList::new));
    }

    int getIndex(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        return Optional.of(path).map(Path::getFileName).filter(Objects::nonNull).map(Path::toString).map(this.fileIndexPattern::matcher).filter(Matcher::find).map(matcher -> matcher.group("index")).map(Integer::valueOf).orElseThrow(() -> {
            String msg = String.format(Locale.ENGLISH, "File '%s' doesn't have index group", path.toString());
            return new IllegalArgumentException(msg);
        });
    }

    Path getFile(int fileIndex) {
        String fileName = String.format(Locale.ENGLISH, "%s%d%s", this.prefix, fileIndex, this.suffix);
        return this.folder.resolve(fileName);
    }

    Optional<Path> findFile(int fileIndex) {
        return Optional.ofNullable(this.getFile(fileIndex)).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }

    Path createNextFile() {
        int nextIndex;
        Path result;
        while (Files.exists(result = this.getFile(nextIndex = this.index.getAndIncrement()), new LinkOption[0])) {
        }
        Files.createFile(result, new FileAttribute[0]);
        this.queue.add(result);
        return result;
    }

    Path poll() {
        return this.queue.poll();
    }

    Path peek() {
        return this.queue.peek();
    }

    void remove(Path ... paths) {
        if (paths == null) {
            throw new NullPointerException("paths is marked @NonNull but is null");
        }
        for (Path path : paths) {
            Files.deleteIfExists(path);
            this.queue.remove(path);
        }
    }

    void remove(@NonNull Collection<Path> paths) {
        if (paths == null) {
            throw new NullPointerException("paths is marked @NonNull but is null");
        }
        Path[] array = paths.toArray(new Path[0]);
        this.remove(array);
    }

    void clear() {
        this.remove(this.queue);
        this.index.set(0);
    }

    @SuppressFBWarnings(justification="generated code")
    public static FilesManagerBuilder builder() {
        return new FilesManagerBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public static class FilesManagerBuilder {
        @SuppressFBWarnings(justification="generated code")
        private Path folder;
        @SuppressFBWarnings(justification="generated code")
        private String prefix;
        @SuppressFBWarnings(justification="generated code")
        private String suffix;

        @SuppressFBWarnings(justification="generated code")
        FilesManagerBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public FilesManagerBuilder folder(@NonNull Path folder) {
            if (folder == null) {
                throw new NullPointerException("folder is marked @NonNull but is null");
            }
            this.folder = folder;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public FilesManagerBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public FilesManagerBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public FilesManager build() {
            return new FilesManager(this.folder, this.prefix, this.suffix);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "FilesManager.FilesManagerBuilder(folder=" + this.folder + ", prefix=" + this.prefix + ", suffix=" + this.suffix + ")";
        }
    }
}

