/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.backend;

import io.appulse.utils.ReadBytesUtils;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.stream.Stream;

class RecordHeader {
    static final int BYTES = 9;
    private final ByteBuffer buffer = ByteBuffer.allocate(9);

    RecordHeader() {
    }

    RecordHeader readFrom(FileChannel channel) {
        this.buffer.clear();
        ReadBytesUtils.read((ReadableByteChannel)channel, (ByteBuffer)this.buffer);
        return this;
    }

    RecordHeader skipJumps(FileChannel channel) {
        while (true) {
            this.readFrom(channel);
            if (!this.isJump()) {
                return this;
            }
            long newPosition = this.getValue();
            channel.position(newPosition);
        }
    }

    void writeJump(FileChannel channel, long from, long to) {
        this.buffer.clear();
        this.buffer.put(Marker.JUMP.getValue());
        this.buffer.putLong(to);
        this.buffer.rewind();
        channel.write(this.buffer, from);
    }

    void writeRecord(FileChannel channel, long length) {
        this.buffer.clear();
        this.buffer.put(Marker.RECORD.getValue());
        this.buffer.putLong(length);
        this.buffer.rewind();
        channel.write(this.buffer);
    }

    void writeEnd(FileChannel channel) {
        this.buffer.clear();
        this.buffer.put(Marker.END.getValue());
        this.buffer.putLong(0L);
        this.buffer.rewind();
        channel.write(this.buffer);
    }

    Marker getMarker() {
        byte value = this.buffer.get(0);
        return Marker.of(value);
    }

    long getValue() {
        return this.buffer.getLong(1);
    }

    int getLength() {
        return (int)this.getValue();
    }

    boolean isRecord() {
        if (this.getMarker() != Marker.RECORD) {
            return false;
        }
        if (this.getValue() == 0L) {
            throw new IllegalStateException();
        }
        return true;
    }

    boolean isJump() {
        if (this.getMarker() != Marker.JUMP) {
            return false;
        }
        if (this.getValue() == 0L) {
            throw new IllegalStateException();
        }
        return true;
    }

    boolean isEnd() {
        if (this.getMarker() != Marker.END) {
            return false;
        }
        if (this.getValue() != 0L) {
            throw new IllegalStateException();
        }
        return true;
    }

    static enum Marker {
        RECORD(1),
        JUMP(2),
        END(4),
        UNDEFINED(255);

        byte value;

        private Marker(int value) {
            this.value = (byte)value;
        }

        byte getValue() {
            return this.value;
        }

        static Marker of(byte value) {
            return Stream.of(Marker.values()).filter(it -> it.getValue() == value).findAny().orElse(UNDEFINED);
        }
    }
}

