/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout;

import io.appulse.utils.Bytes;
import io.appulse.utils.SerializationUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public interface Deserializer<T> {
    public static final Deserializer<Byte> BYTE = new ByteDeserializer();
    public static final Deserializer<Short> SHORT = new ShortDeserializer();
    public static final Deserializer<Character> CHARACTER = new CharacterDeserializer();
    public static final Deserializer<Integer> INTEGER = new IntegerDeserializer();
    public static final Deserializer<Long> LONG = new LongDeserializer();
    public static final Deserializer<Float> FLOAT = new FloatDeserializer();
    public static final Deserializer<Double> DOUBLE = new DoubleDeserializer();
    public static final Deserializer<BigInteger> BIG_INTEGER = new BigIntegerDeserializer();
    public static final Deserializer<BigDecimal> BIG_DECIMAL = new BigDecimalDeserializer();
    public static final Deserializer<byte[]> BYTE_ARRAY = new ByteArrayDeserializer();
    public static final Deserializer<String> STRING = new StringDeserializer();

    public T deserialize(int var1, Bytes var2);

    public static class StringDeserializer
    implements Deserializer<String> {
        @Override
        public String deserialize(int length, Bytes buffer) {
            int arrayLength = buffer.readInt();
            byte[] bytes = buffer.readBytes(arrayLength);
            return new String(bytes, StandardCharsets.UTF_8);
        }
    }

    public static class ByteArrayDeserializer
    implements Deserializer<byte[]> {
        @Override
        public byte[] deserialize(int length, Bytes buffer) {
            int arrayLength = buffer.readInt();
            return buffer.readBytes(arrayLength);
        }
    }

    public static class BigDecimalDeserializer
    implements Deserializer<BigDecimal> {
        @Override
        public BigDecimal deserialize(int length, Bytes buffer) {
            int arrayLength = buffer.readInt();
            byte[] bytes = buffer.readBytes(arrayLength);
            int scale = buffer.readInt();
            BigInteger unscaledValue = new BigInteger(bytes);
            return new BigDecimal(unscaledValue, scale);
        }
    }

    public static class BigIntegerDeserializer
    implements Deserializer<BigInteger> {
        @Override
        public BigInteger deserialize(int length, Bytes buffer) {
            int arrayLength = buffer.readInt();
            byte[] bytes = buffer.readBytes(arrayLength);
            return new BigInteger(bytes);
        }
    }

    public static class DoubleDeserializer
    implements Deserializer<Double> {
        @Override
        public Double deserialize(int length, Bytes buffer) {
            return buffer.readDouble();
        }
    }

    public static class FloatDeserializer
    implements Deserializer<Float> {
        @Override
        public Float deserialize(int length, Bytes buffer) {
            return Float.valueOf(buffer.readFloat());
        }
    }

    public static class LongDeserializer
    implements Deserializer<Long> {
        @Override
        public Long deserialize(int length, Bytes buffer) {
            return buffer.readLong();
        }
    }

    public static class IntegerDeserializer
    implements Deserializer<Integer> {
        @Override
        public Integer deserialize(int length, Bytes buffer) {
            return buffer.readInt();
        }
    }

    public static class CharacterDeserializer
    implements Deserializer<Character> {
        @Override
        public Character deserialize(int length, Bytes buffer) {
            return Character.valueOf(buffer.readChar());
        }
    }

    public static class ShortDeserializer
    implements Deserializer<Short> {
        @Override
        public Short deserialize(int length, Bytes buffer) {
            return buffer.readShort();
        }
    }

    public static class ByteDeserializer
    implements Deserializer<Byte> {
        @Override
        public Byte deserialize(int length, Bytes buffer) {
            return buffer.readByte();
        }
    }

    public static class DefaultDeserializer<T>
    implements Deserializer<T> {
        @Override
        public T deserialize(int length, Bytes buffer) {
            byte[] bytes = (byte[])BYTE_ARRAY.deserialize(length, buffer);
            return (T)SerializationUtils.deserialize((byte[])bytes);
        }
    }
}

