/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractQueue;
import java.util.Optional;
import lombok.NonNull;
import org.infobip.lib.popout.CompressedFilesConfig;
import org.infobip.lib.popout.Deserializer;
import org.infobip.lib.popout.QueueLimit;
import org.infobip.lib.popout.Serializer;
import org.infobip.lib.popout.WalFilesConfig;
import org.infobip.lib.popout.batched.BatchedFileQueueBuilder;
import org.infobip.lib.popout.synced.SyncedFileQueueBuilder;

public abstract class FileQueue<T>
extends AbstractQueue<T>
implements AutoCloseable {
    public static <T> SyncedFileQueueBuilder<T> synced() {
        return new SyncedFileQueueBuilder();
    }

    public static <T> BatchedFileQueueBuilder<T> batched() {
        return new BatchedFileQueueBuilder();
    }

    public abstract long longSize();

    public abstract long diskSize();

    public abstract void flush();

    public abstract void compress();

    @Override
    public abstract void close();

    public static abstract class Builder<SELF extends Builder<SELF, T>, T> {
        protected String name;
        protected Path folder;
        protected Serializer<T> serializer;
        protected Deserializer<T> deserializer;
        protected QueueLimit<T> limit;
        protected WalFilesConfig walFilesConfig;
        protected CompressedFilesConfig compressedFilesConfig;
        protected boolean restoreFromDisk = true;

        public SELF name(@NonNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked @NonNull but is null");
            }
            this.name = value;
            return (SELF)this;
        }

        public SELF folder(@NonNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked @NonNull but is null");
            }
            this.folder = Paths.get(value, new String[0]);
            return (SELF)this;
        }

        public SELF folder(@NonNull Path value) {
            if (value == null) {
                throw new NullPointerException("value is marked @NonNull but is null");
            }
            this.folder = value;
            return (SELF)this;
        }

        public SELF serializer(@NonNull Serializer<T> value) {
            if (value == null) {
                throw new NullPointerException("value is marked @NonNull but is null");
            }
            this.serializer = value;
            return (SELF)this;
        }

        public SELF deserializer(@NonNull Deserializer<T> value) {
            if (value == null) {
                throw new NullPointerException("value is marked @NonNull but is null");
            }
            this.deserializer = value;
            return (SELF)this;
        }

        public SELF limit(@NonNull QueueLimit<T> value) {
            if (value == null) {
                throw new NullPointerException("value is marked @NonNull but is null");
            }
            this.limit = value;
            return (SELF)this;
        }

        public SELF wal(@NonNull WalFilesConfig value) {
            if (value == null) {
                throw new NullPointerException("value is marked @NonNull but is null");
            }
            this.walFilesConfig = value;
            return (SELF)this;
        }

        public SELF compressed(@NonNull CompressedFilesConfig value) {
            if (value == null) {
                throw new NullPointerException("value is marked @NonNull but is null");
            }
            this.compressedFilesConfig = value;
            return (SELF)this;
        }

        public SELF restoreFromDisk(boolean value) {
            this.restoreFromDisk = value;
            return (SELF)this;
        }

        public FileQueue<T> build() {
            this.validateAndSetDefaults();
            return this.createQueue();
        }

        protected abstract FileQueue<T> createQueue();

        protected void validateAndSetDefaults() {
            this.name = Optional.ofNullable(this.name).orElse("queue");
            this.folder = Optional.ofNullable(this.folder).orElse(Paths.get(".", new String[0]));
            this.serializer = Optional.ofNullable(this.serializer).orElseGet(() -> new Serializer.DefaultSerializer());
            this.deserializer = Optional.ofNullable(this.deserializer).orElseGet(() -> new Deserializer.DefaultDeserializer());
            this.limit = Optional.ofNullable(this.limit).orElseGet(() -> QueueLimit.noLimit());
            this.walFilesConfig = Optional.ofNullable(this.walFilesConfig).map(it -> {
                if (it.getMaxCount() < 0) {
                    String msg = "WAL's max count should be greater than 0, or 0 - if you would like to get default value (100)";
                    throw new IllegalArgumentException("WAL's max count should be greater than 0, or 0 - if you would like to get default value (100)");
                }
                return it;
            }).map(it -> it.getFolder() == null ? it.withFolder(this.folder) : it).map(it -> it.getMaxCount() == 0 ? it.withMaxCount(100) : it).orElseGet(() -> WalFilesConfig.builder().folder(this.folder).maxCount(100).build());
            Files.createDirectories(this.walFilesConfig.getFolder(), new FileAttribute[0]);
            this.compressedFilesConfig = Optional.ofNullable(this.compressedFilesConfig).map(it -> {
                if (it.getMaxSizeBytes() < 0L) {
                    String msg = "Compressed file's max size should be greater than 0, or 0 - if you would like to get default value (Long.MAX_VALUE)";
                    throw new IllegalArgumentException("Compressed file's max size should be greater than 0, or 0 - if you would like to get default value (Long.MAX_VALUE)");
                }
                return it;
            }).map(it -> it.getFolder() == null ? it.withFolder(this.folder) : it).map(it -> it.getMaxSizeBytes() == 0L ? it.withMaxSizeBytes(Long.MAX_VALUE) : it).orElseGet(() -> CompressedFilesConfig.builder().folder(this.folder).maxSizeBytes(Long.MAX_VALUE).build());
            Files.createDirectories(this.compressedFilesConfig.getFolder(), new FileAttribute[0]);
        }

        @SuppressFBWarnings(justification="generated code")
        public String getName() {
            return this.name;
        }

        @SuppressFBWarnings(justification="generated code")
        public Path getFolder() {
            return this.folder;
        }

        @SuppressFBWarnings(justification="generated code")
        public Serializer<T> getSerializer() {
            return this.serializer;
        }

        @SuppressFBWarnings(justification="generated code")
        public Deserializer<T> getDeserializer() {
            return this.deserializer;
        }

        @SuppressFBWarnings(justification="generated code")
        public QueueLimit<T> getLimit() {
            return this.limit;
        }

        @SuppressFBWarnings(justification="generated code")
        public WalFilesConfig getWalFilesConfig() {
            return this.walFilesConfig;
        }

        @SuppressFBWarnings(justification="generated code")
        public CompressedFilesConfig getCompressedFilesConfig() {
            return this.compressedFilesConfig;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean isRestoreFromDisk() {
            return this.restoreFromDisk;
        }
    }
}

