/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.function.BiConsumer;
import lombok.NonNull;
import org.infobip.lib.popout.FileQueue;

public interface QueueLimit<T> {
    public static <T> QueueLimit<T> noLimit() {
        return new NoLimit();
    }

    public static <T> QueueLength.QueueLengthBuilder<T> queueLength() {
        return QueueLength.builder();
    }

    public static <T> DiskSize.DiskSizeBuilder<T> diskSize() {
        return DiskSize.builder();
    }

    public boolean isExceeded(FileQueue<T> var1);

    public void handle(T var1, FileQueue<T> var2);

    public static class DiskSize<T>
    implements QueueLimit<T> {
        private final long bytes;
        private final BiConsumer<T, FileQueue<T>> handler;

        DiskSize(long bytes, BiConsumer<T, FileQueue<T>> handler) {
            this.bytes = bytes;
            this.handler = handler;
        }

        @Override
        public boolean isExceeded(@NonNull FileQueue<T> queue) {
            if (queue == null) {
                throw new NullPointerException("queue is marked @NonNull but is null");
            }
            return queue.diskSize() > this.bytes;
        }

        @Override
        public void handle(@NonNull T value, @NonNull FileQueue<T> queue) {
            if (value == null) {
                throw new NullPointerException("value is marked @NonNull but is null");
            }
            if (queue == null) {
                throw new NullPointerException("queue is marked @NonNull but is null");
            }
            this.handler.accept(value, queue);
        }

        @SuppressFBWarnings(justification="generated code")
        public static <T> DiskSizeBuilder<T> builder() {
            return new DiskSizeBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public static class DiskSizeBuilder<T> {
            @SuppressFBWarnings(justification="generated code")
            private long bytes;
            @SuppressFBWarnings(justification="generated code")
            private BiConsumer<T, FileQueue<T>> handler;

            @SuppressFBWarnings(justification="generated code")
            DiskSizeBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public DiskSizeBuilder<T> bytes(long bytes) {
                this.bytes = bytes;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public DiskSizeBuilder<T> handler(BiConsumer<T, FileQueue<T>> handler) {
                this.handler = handler;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public DiskSize<T> build() {
                return new DiskSize<T>(this.bytes, this.handler);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "QueueLimit.DiskSize.DiskSizeBuilder(bytes=" + this.bytes + ", handler=" + this.handler + ")";
            }
        }
    }

    public static class QueueLength<T>
    implements QueueLimit<T> {
        private final long length;
        private final BiConsumer<T, FileQueue<T>> handler;

        QueueLength(long length, BiConsumer<T, FileQueue<T>> handler) {
            this.length = length;
            this.handler = handler;
        }

        @Override
        public boolean isExceeded(@NonNull FileQueue<T> queue) {
            if (queue == null) {
                throw new NullPointerException("queue is marked @NonNull but is null");
            }
            return queue.longSize() > this.length;
        }

        @Override
        public void handle(@NonNull T value, @NonNull FileQueue<T> queue) {
            if (value == null) {
                throw new NullPointerException("value is marked @NonNull but is null");
            }
            if (queue == null) {
                throw new NullPointerException("queue is marked @NonNull but is null");
            }
            this.handler.accept(value, queue);
        }

        @SuppressFBWarnings(justification="generated code")
        public static <T> QueueLengthBuilder<T> builder() {
            return new QueueLengthBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public static class QueueLengthBuilder<T> {
            @SuppressFBWarnings(justification="generated code")
            private long length;
            @SuppressFBWarnings(justification="generated code")
            private BiConsumer<T, FileQueue<T>> handler;

            @SuppressFBWarnings(justification="generated code")
            QueueLengthBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public QueueLengthBuilder<T> length(long length) {
                this.length = length;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public QueueLengthBuilder<T> handler(BiConsumer<T, FileQueue<T>> handler) {
                this.handler = handler;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public QueueLength<T> build() {
                return new QueueLength<T>(this.length, this.handler);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "QueueLimit.QueueLength.QueueLengthBuilder(length=" + this.length + ", handler=" + this.handler + ")";
            }
        }
    }

    public static class NoLimit<T>
    implements QueueLimit<T> {
        @Override
        public boolean isExceeded(FileQueue<T> queue) {
            return false;
        }

        @Override
        public void handle(T value, FileQueue<T> queue) {
            throw new UnsupportedOperationException();
        }
    }
}

