/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout;

import io.appulse.utils.Bytes;
import io.appulse.utils.BytesPool;
import lombok.NonNull;

public final class ReadWriteBytesPool {
    private final BytesPool pool = BytesPool.builder().initialBufferSizeBytes(Integer.valueOf(512)).initialBuffersCount(Integer.valueOf(3)).maximumBuffersCount(Integer.valueOf(1024)).bufferCreateFunction(Bytes::resizableArray).build();

    public static ReadWriteBytesPool getInstance() {
        return ReadWriteBytesPoolHolder.HOLDER_INSTANCE;
    }

    private ReadWriteBytesPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T borrow(@NonNull ThrowableBytesConsumer<T> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked @NonNull but is null");
        }
        BytesPool.PooledBytes buffer = this.pool.acquire();
        try {
            T t = consumer.consume((Bytes)buffer);
            return t;
        }
        finally {
            buffer.release();
        }
    }

    private static class ReadWriteBytesPoolHolder {
        private static final ReadWriteBytesPool HOLDER_INSTANCE = new ReadWriteBytesPool();

        private ReadWriteBytesPoolHolder() {
        }
    }

    @FunctionalInterface
    public static interface ThrowableBytesConsumer<T> {
        public T consume(Bytes var1) throws Throwable;
    }
}

