/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.synced;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.utils.Bytes;
import lombok.NonNull;
import org.infobip.lib.popout.Deserializer;
import org.infobip.lib.popout.Serializer;

class ItemSerialization<T> {
    @NonNull
    private final Serializer<T> serializer;
    @NonNull
    private final Deserializer<T> deserializer;

    void serialize(T item, Bytes buffer) {
        buffer.reset();
        buffer.write4B(0);
        this.serializer.serialize(item, buffer);
        buffer.set4B(0, buffer.writerIndex() - 4);
    }

    T deserialize(Bytes buffer) {
        int length = buffer.readInt();
        return this.deserializer.deserialize(length, buffer);
    }

    @SuppressFBWarnings(justification="generated code")
    public static <T> ItemSerializationBuilder<T> builder() {
        return new ItemSerializationBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public ItemSerialization(@NonNull Serializer<T> serializer, @NonNull Deserializer<T> deserializer) {
        if (serializer == null) {
            throw new NullPointerException("serializer is marked @NonNull but is null");
        }
        if (deserializer == null) {
            throw new NullPointerException("deserializer is marked @NonNull but is null");
        }
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class ItemSerializationBuilder<T> {
        @SuppressFBWarnings(justification="generated code")
        private Serializer<T> serializer;
        @SuppressFBWarnings(justification="generated code")
        private Deserializer<T> deserializer;

        @SuppressFBWarnings(justification="generated code")
        ItemSerializationBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public ItemSerializationBuilder<T> serializer(@NonNull Serializer<T> serializer) {
            if (serializer == null) {
                throw new NullPointerException("serializer is marked @NonNull but is null");
            }
            this.serializer = serializer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ItemSerializationBuilder<T> deserializer(@NonNull Deserializer<T> deserializer) {
            if (deserializer == null) {
                throw new NullPointerException("deserializer is marked @NonNull but is null");
            }
            this.deserializer = deserializer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ItemSerialization<T> build() {
            return new ItemSerialization<T>(this.serializer, this.deserializer);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ItemSerialization.ItemSerializationBuilder(serializer=" + this.serializer + ", deserializer=" + this.deserializer + ")";
        }
    }
}

