/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.backend;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.infobip.lib.popout.backend.CompressedFileIteratorSingleFile;
import org.infobip.lib.popout.backend.WalContent;

class CompressedFileIteratorManyFiles
implements Iterator<WalContent>,
AutoCloseable {
    private final Iterator<Path> pathsIterator;
    private final CompressedFileIteratorSingleFile walContentsIterator;
    private WalContent nextWalContent;

    CompressedFileIteratorManyFiles(Collection<Path> paths) {
        this.pathsIterator = paths.iterator();
        this.walContentsIterator = new CompressedFileIteratorSingleFile();
    }

    @Override
    public boolean hasNext() {
        if (this.nextWalContent != null) {
            return true;
        }
        while (!this.walContentsIterator.hasNext()) {
            if (!this.pathsIterator.hasNext()) {
                return false;
            }
            Path path = this.pathsIterator.next();
            this.walContentsIterator.init(path);
        }
        this.nextWalContent = this.walContentsIterator.next();
        return true;
    }

    @Override
    public WalContent next() {
        if (this.nextWalContent != null || this.hasNext()) {
            WalContent result = this.nextWalContent;
            this.nextWalContent = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        this.walContentsIterator.remove();
    }

    @Override
    public void close() throws Exception {
        this.walContentsIterator.close();
    }
}

