/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.backend;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.utils.Bytes;
import io.appulse.utils.ReadBytesUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import org.infobip.lib.popout.CompressedFilesConfig;
import org.infobip.lib.popout.FileQueue;
import org.infobip.lib.popout.backend.CompressedFileIteratorManyFiles;
import org.infobip.lib.popout.backend.CompressionResult;
import org.infobip.lib.popout.backend.FilesManager;
import org.infobip.lib.popout.backend.RecordHeader;
import org.infobip.lib.popout.backend.WalContent;
import org.infobip.lib.popout.exception.CorruptedDataException;

class CompressedFiles
implements Iterable<WalContent>,
AutoCloseable {
    private static final byte[] CLEAR = new byte[8192];
    private final FilesManager files;
    private final long maxFileSizeBytes;
    private final Function<CorruptedDataException, Boolean> corruptionHandler;

    CompressedFiles(@NonNull String queueName, @NonNull CompressedFilesConfig config, Boolean restoreFromDisk, Function<CorruptedDataException, Boolean> corruptionHandler) {
        if (queueName == null) {
            throw new NullPointerException("queueName is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        Boolean restoreFromDiskValue = Optional.ofNullable(restoreFromDisk).orElse(Boolean.TRUE);
        Function corruptionHandlerValue = Optional.ofNullable(corruptionHandler).orElseGet(() -> new FileQueue.DefaultCorruptionHandler());
        this.files = FilesManager.builder().folder(config.getFolder()).prefix(queueName + '-').suffix(".compressed").build();
        if (!restoreFromDiskValue.booleanValue()) {
            this.files.clear();
        }
        this.maxFileSizeBytes = config.getMaxSizeBytes();
        this.corruptionHandler = corruptionHandlerValue;
    }

    @Override
    public Iterator<WalContent> iterator() {
        return new CompressedFileIteratorManyFiles(this.files.getFilesFromQueue());
    }

    @Override
    public void close() {
        this.files.close();
    }

    int peekContentPart(@NonNull Bytes bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked @NonNull but is null");
        }
        return this.readTo(bytes, (channel, header, buffer) -> {
            int length = header.getLength();
            if (buffer.isWritable(length)) {
                int newCapacity = buffer.writerIndex() + length;
                buffer.capacity(newCapacity);
            }
            return ReadBytesUtils.read((ReadableByteChannel)channel, (Bytes)buffer, (int)length);
        });
    }

    int pollContentPart(@NonNull Bytes bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked @NonNull but is null");
        }
        return this.readTo(bytes, (channel, header, buffer) -> {
            int length = header.getLength();
            if (!buffer.isWritable(length)) {
                int newCapacity = buffer.writerIndex() + length;
                buffer.capacity(newCapacity);
            }
            int result = ReadBytesUtils.read((ReadableByteChannel)channel, (Bytes)buffer, (int)length);
            long position = channel.position();
            if (!header.skipJumps(channel).isEnd()) {
                header.writeJump(channel, 0L, position);
            }
            return result;
        });
    }

    CompressionResult compress(@NonNull Collection<Path> walFiles) {
        if (walFiles == null) {
            throw new NullPointerException("walFiles is marked @NonNull but is null");
        }
        CompressionResult result = new CompressionResult(new ArrayList<Path>(), new ArrayList<Path>(walFiles));
        if (walFiles.isEmpty()) {
            return result;
        }
        Path file = this.files.createNextFile();
        long walFilesSumSize = walFiles.stream().mapToLong(this::getSizeWithHeader).sum() + 9L;
        long needToAllocate = Math.min(walFilesSumSize, this.maxFileSizeBytes);
        long allocated = this.allocate(file, needToAllocate) - 9L;
        RecordHeader header = new RecordHeader();
        try (FileChannel channel = FileChannel.open(file, StandardOpenOption.WRITE);){
            for (Path walFile : walFiles) {
                long size = Files.size(walFile);
                if (channel.position() + 9L + size > allocated) break;
                header.writeRecord(channel, size);
                try (FileChannel walFileChannel = FileChannel.open(walFile, new OpenOption[0]);){
                    walFileChannel.transferTo(0L, walFileChannel.size(), channel);
                }
                result.getCompressed().add(walFile);
                result.getRemaining().remove(walFile);
            }
            header.writeEnd(channel);
        }
        return result;
    }

    Collection<Path> getFiles() {
        return this.files.getFilesFromQueue();
    }

    long diskSize() {
        long result = 0L;
        for (Path file : this.getFiles()) {
            result += Files.size(file);
        }
        return result;
    }

    private int readTo(Bytes buffer, RecordReader reader) {
        int writerIndex = buffer.writerIndex();
        int readerIndex = buffer.readerIndex();
        RecordHeader header = new RecordHeader();
        Path file;
        while ((file = this.files.peek()) != null) {
            ReadResult result = this.readTo(file, header, buffer, reader);
            if (result.isRemoveFile()) {
                this.files.remove(file);
            }
            if (result.hesReaded()) {
                return (int)result.getReaded();
            }
            buffer.writerIndex(writerIndex);
            buffer.readerIndex(readerIndex);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReadResult readTo(Path file, RecordHeader header, Bytes buffer, RecordReader reader) {
        try (AbstractInterruptibleChannel channel = null;){
            channel = FileChannel.open(file, StandardOpenOption.READ, StandardOpenOption.WRITE);
            header.skipJumps((FileChannel)channel);
            if (header.isEnd()) {
                ReadResult readResult2 = ReadResult.endOfFile();
                return readResult2;
            }
            int readed = reader.read((FileChannel)channel, header, buffer);
            boolean shouldRemoveFile = readed == 0 || header.isEnd();
            ReadResult readResult = new ReadResult(readed, shouldRemoveFile);
            return readResult;
        }
    }

    private long getSizeWithHeader(Path path) {
        return 9L + Files.size(path);
    }

    private long allocate(Path path, long size) {
        int allocated = 0;
        try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            while ((long)allocated < size) {
                int bufferSize = (int)Math.min((long)CLEAR.length, size - (long)allocated);
                out.write(CLEAR, 0, bufferSize);
                allocated += bufferSize;
            }
        }
        return allocated;
    }

    @SuppressFBWarnings(justification="generated code")
    public static CompressedFilesBuilder builder() {
        return new CompressedFilesBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public static class CompressedFilesBuilder {
        @SuppressFBWarnings(justification="generated code")
        private String queueName;
        @SuppressFBWarnings(justification="generated code")
        private CompressedFilesConfig config;
        @SuppressFBWarnings(justification="generated code")
        private Boolean restoreFromDisk;
        @SuppressFBWarnings(justification="generated code")
        private Function<CorruptedDataException, Boolean> corruptionHandler;

        @SuppressFBWarnings(justification="generated code")
        CompressedFilesBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public CompressedFilesBuilder queueName(@NonNull String queueName) {
            if (queueName == null) {
                throw new NullPointerException("queueName is marked @NonNull but is null");
            }
            this.queueName = queueName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public CompressedFilesBuilder config(@NonNull CompressedFilesConfig config) {
            if (config == null) {
                throw new NullPointerException("config is marked @NonNull but is null");
            }
            this.config = config;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public CompressedFilesBuilder restoreFromDisk(Boolean restoreFromDisk) {
            this.restoreFromDisk = restoreFromDisk;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public CompressedFilesBuilder corruptionHandler(Function<CorruptedDataException, Boolean> corruptionHandler) {
            this.corruptionHandler = corruptionHandler;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public CompressedFiles build() {
            return new CompressedFiles(this.queueName, this.config, this.restoreFromDisk, this.corruptionHandler);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "CompressedFiles.CompressedFilesBuilder(queueName=" + this.queueName + ", config=" + this.config + ", restoreFromDisk=" + this.restoreFromDisk + ", corruptionHandler=" + this.corruptionHandler + ")";
        }
    }

    static final class ReadResult {
        private final long readed;
        private final boolean removeFile;

        static ReadResult endOfFile() {
            return new ReadResult(0L, true);
        }

        static ReadResult continueReading(long readed) {
            return new ReadResult(readed, false);
        }

        boolean hesReaded() {
            return this.readed > 0L;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getReaded() {
            return this.readed;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean isRemoveFile() {
            return this.removeFile;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadResult)) {
                return false;
            }
            ReadResult other = (ReadResult)o;
            if (this.getReaded() != other.getReaded()) {
                return false;
            }
            return this.isRemoveFile() == other.isRemoveFile();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $readed = this.getReaded();
            result = result * 59 + (int)($readed >>> 32 ^ $readed);
            result = result * 59 + (this.isRemoveFile() ? 79 : 97);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "CompressedFiles.ReadResult(readed=" + this.getReaded() + ", removeFile=" + this.isRemoveFile() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        public ReadResult(long readed, boolean removeFile) {
            this.readed = readed;
            this.removeFile = removeFile;
        }
    }

    @FunctionalInterface
    static interface RecordReader {
        public int read(FileChannel var1, RecordHeader var2, Bytes var3) throws IOException;
    }
}

