/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.backend;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.utils.Bytes;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import org.infobip.lib.popout.CompressedFilesConfig;
import org.infobip.lib.popout.FileQueue;
import org.infobip.lib.popout.WalFilesConfig;
import org.infobip.lib.popout.backend.CompressedFiles;
import org.infobip.lib.popout.backend.CompressionResult;
import org.infobip.lib.popout.backend.WalContent;
import org.infobip.lib.popout.backend.WalFiles;
import org.infobip.lib.popout.exception.CorruptedDataException;

public class FileSystemBackend
implements Iterable<WalContent>,
AutoCloseable {
    private final WalFiles walFiles;
    private final CompressedFiles compressedFiles;

    public FileSystemBackend(@NonNull String queueName, @NonNull WalFilesConfig walConfig, @NonNull CompressedFilesConfig compressedConfig, Boolean restoreFromDisk, Function<CorruptedDataException, Boolean> corruptionHandler) {
        if (queueName == null) {
            throw new NullPointerException("queueName is marked @NonNull but is null");
        }
        if (walConfig == null) {
            throw new NullPointerException("walConfig is marked @NonNull but is null");
        }
        if (compressedConfig == null) {
            throw new NullPointerException("compressedConfig is marked @NonNull but is null");
        }
        Boolean restoreFromDiskValue = Optional.ofNullable(restoreFromDisk).orElse(Boolean.TRUE);
        Function corruptionHandlerValue = Optional.ofNullable(corruptionHandler).orElseGet(() -> new FileQueue.DefaultCorruptionHandler());
        this.walFiles = WalFiles.builder().queueName(queueName).restoreFromDisk(restoreFromDiskValue).config(walConfig).corruptionHandler(corruptionHandlerValue).build();
        this.compressedFiles = CompressedFiles.builder().queueName(queueName).restoreFromDisk(restoreFromDiskValue).config(compressedConfig).corruptionHandler(corruptionHandlerValue).build();
    }

    public void write(@NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        this.walFiles.write(buffer);
        while (this.walFiles.isLimitExceeded()) {
            this.compress();
        }
    }

    public void compress() {
        Collection<Path> files = this.walFiles.getFiles();
        CompressionResult result = this.compressedFiles.compress(files);
        this.walFiles.remove(result.getCompressed());
    }

    public int pollTo(@NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        int readed = this.compressedFiles.pollContentPart(buffer);
        return readed > 0 ? readed : this.walFiles.pollTo(buffer);
    }

    public int peakTo(@NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        int readed = this.compressedFiles.peekContentPart(buffer);
        return readed > 0 ? readed : this.walFiles.peakTo(buffer);
    }

    public long diskSize() {
        return this.walFiles.diskSize() + this.compressedFiles.diskSize();
    }

    @Override
    public Iterator<WalContent> iterator() {
        return new FileSystemBackendIterator();
    }

    @Override
    public void close() {
        this.walFiles.close();
        this.compressedFiles.close();
    }

    @SuppressFBWarnings(justification="generated code")
    public static FileSystemBackendBuilder builder() {
        return new FileSystemBackendBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public static class FileSystemBackendBuilder {
        @SuppressFBWarnings(justification="generated code")
        private String queueName;
        @SuppressFBWarnings(justification="generated code")
        private WalFilesConfig walConfig;
        @SuppressFBWarnings(justification="generated code")
        private CompressedFilesConfig compressedConfig;
        @SuppressFBWarnings(justification="generated code")
        private Boolean restoreFromDisk;
        @SuppressFBWarnings(justification="generated code")
        private Function<CorruptedDataException, Boolean> corruptionHandler;

        @SuppressFBWarnings(justification="generated code")
        FileSystemBackendBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public FileSystemBackendBuilder queueName(@NonNull String queueName) {
            if (queueName == null) {
                throw new NullPointerException("queueName is marked @NonNull but is null");
            }
            this.queueName = queueName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public FileSystemBackendBuilder walConfig(@NonNull WalFilesConfig walConfig) {
            if (walConfig == null) {
                throw new NullPointerException("walConfig is marked @NonNull but is null");
            }
            this.walConfig = walConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public FileSystemBackendBuilder compressedConfig(@NonNull CompressedFilesConfig compressedConfig) {
            if (compressedConfig == null) {
                throw new NullPointerException("compressedConfig is marked @NonNull but is null");
            }
            this.compressedConfig = compressedConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public FileSystemBackendBuilder restoreFromDisk(Boolean restoreFromDisk) {
            this.restoreFromDisk = restoreFromDisk;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public FileSystemBackendBuilder corruptionHandler(Function<CorruptedDataException, Boolean> corruptionHandler) {
            this.corruptionHandler = corruptionHandler;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public FileSystemBackend build() {
            return new FileSystemBackend(this.queueName, this.walConfig, this.compressedConfig, this.restoreFromDisk, this.corruptionHandler);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "FileSystemBackend.FileSystemBackendBuilder(queueName=" + this.queueName + ", walConfig=" + this.walConfig + ", compressedConfig=" + this.compressedConfig + ", restoreFromDisk=" + this.restoreFromDisk + ", corruptionHandler=" + this.corruptionHandler + ")";
        }
    }

    private class FileSystemBackendIterator
    implements Iterator<WalContent> {
        private final Iterator<WalContent> compressed;
        private final Iterator<WalContent> wals;
        private Iterator<WalContent> current;

        private FileSystemBackendIterator() {
            this.compressed = FileSystemBackend.this.compressedFiles.iterator();
            this.wals = FileSystemBackend.this.walFiles.iterator();
            this.current = this.compressed;
        }

        @Override
        public boolean hasNext() {
            if (this.current.hasNext()) {
                return true;
            }
            if (this.wals.hasNext()) {
                this.current = this.wals;
                return true;
            }
            return false;
        }

        @Override
        public WalContent next() {
            return this.current.next();
        }

        @Override
        public void remove() {
            this.current.remove();
        }
    }
}

