/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.backend;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.utils.Bytes;
import io.appulse.utils.ReadBytesUtils;
import io.appulse.utils.WriteBytesUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import org.infobip.lib.popout.FileQueue;
import org.infobip.lib.popout.WalFilesConfig;
import org.infobip.lib.popout.backend.FilesManager;
import org.infobip.lib.popout.backend.WalContent;
import org.infobip.lib.popout.exception.CorruptedDataException;

class WalFiles
implements Iterable<WalContent>,
AutoCloseable {
    private final FilesManager files;
    private final int maxCount;
    private final Function<CorruptedDataException, Boolean> corruptionHandler;

    WalFiles(@NonNull String queueName, @NonNull WalFilesConfig config, Boolean restoreFromDisk, Function<CorruptedDataException, Boolean> corruptionHandler) {
        if (queueName == null) {
            throw new NullPointerException("queueName is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        Boolean restoreFromDiskValue = Optional.ofNullable(restoreFromDisk).orElse(Boolean.TRUE);
        Function corruptionHandlerValue = Optional.ofNullable(corruptionHandler).orElseGet(() -> new FileQueue.DefaultCorruptionHandler());
        this.files = FilesManager.builder().folder(config.getFolder()).prefix(queueName + '-').suffix(".wal").build();
        if (!restoreFromDiskValue.booleanValue()) {
            this.files.clear();
        }
        this.maxCount = config.getMaxCount();
        this.corruptionHandler = corruptionHandlerValue;
    }

    @Override
    public void close() {
        this.files.close();
    }

    void write(@NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        Path file = this.files.createNextFile();
        WriteBytesUtils.write((Path)file, (Bytes)buffer);
    }

    int pollTo(@NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        return this.readTo(buffer, this.files::poll, xva$0 -> this.files.remove((Path)xva$0));
    }

    int peakTo(@NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        return this.readTo(buffer, this.files::peek, null);
    }

    boolean isLimitExceeded() {
        return this.files.getFilesFromQueue().size() > this.maxCount;
    }

    Collection<Path> getFiles() {
        return this.files.getFilesFromQueue();
    }

    long diskSize() {
        long result = 0L;
        for (Path file : this.getFiles()) {
            result += Files.size(file);
        }
        return result;
    }

    void remove(Collection<Path> paths) {
        this.files.remove(paths);
    }

    @Override
    public Iterator<WalContent> iterator() {
        return new WalFilesIterator();
    }

    private int readTo(Bytes buffer, Supplier<Path> supplier, Consumer<Path> actionAfter) {
        int writerIndex = buffer.writerIndex();
        int readerIndex = buffer.readerIndex();
        while (true) {
            Path file = supplier.get();
            try {
                int readed;
                if (file == null) {
                    return 0;
                }
                int size = (int)Files.size(file);
                if (!buffer.isWritable(size)) {
                    int newCapacity = buffer.writerIndex() + size;
                    buffer.capacity(newCapacity);
                }
                if ((readed = ReadBytesUtils.read((Path)file, (Bytes)buffer)) > 0 && actionAfter != null) {
                    actionAfter.accept(file);
                }
                return readed;
            }
            catch (Exception ex) {
                CorruptedDataException exception = new CorruptedDataException(file, 0L, (Throwable)ex);
                this.corruptionHandler.apply(exception);
                this.files.remove(file);
                buffer.writerIndex(writerIndex);
                buffer.readerIndex(readerIndex);
                continue;
            }
            break;
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public static WalFilesBuilder builder() {
        return new WalFilesBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public static class WalFilesBuilder {
        @SuppressFBWarnings(justification="generated code")
        private String queueName;
        @SuppressFBWarnings(justification="generated code")
        private WalFilesConfig config;
        @SuppressFBWarnings(justification="generated code")
        private Boolean restoreFromDisk;
        @SuppressFBWarnings(justification="generated code")
        private Function<CorruptedDataException, Boolean> corruptionHandler;

        @SuppressFBWarnings(justification="generated code")
        WalFilesBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public WalFilesBuilder queueName(@NonNull String queueName) {
            if (queueName == null) {
                throw new NullPointerException("queueName is marked @NonNull but is null");
            }
            this.queueName = queueName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public WalFilesBuilder config(@NonNull WalFilesConfig config) {
            if (config == null) {
                throw new NullPointerException("config is marked @NonNull but is null");
            }
            this.config = config;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public WalFilesBuilder restoreFromDisk(Boolean restoreFromDisk) {
            this.restoreFromDisk = restoreFromDisk;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public WalFilesBuilder corruptionHandler(Function<CorruptedDataException, Boolean> corruptionHandler) {
            this.corruptionHandler = corruptionHandler;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public WalFiles build() {
            return new WalFiles(this.queueName, this.config, this.restoreFromDisk, this.corruptionHandler);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WalFiles.WalFilesBuilder(queueName=" + this.queueName + ", config=" + this.config + ", restoreFromDisk=" + this.restoreFromDisk + ", corruptionHandler=" + this.corruptionHandler + ")";
        }
    }

    private class WalFilesIterator
    implements Iterator<WalContent> {
        private final Iterator<Path> paths;
        private WalContent lastReturned;
        private WalContent next;

        private WalFilesIterator() {
            this.paths = WalFiles.this.files.getFilesFromQueue().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (!this.paths.hasNext()) {
                return false;
            }
            Path path = this.paths.next();
            this.next = WalContent.builder().file(path).offset(0L).length((int)Files.size(path)).build();
            return true;
        }

        @Override
        public WalContent next() {
            if (this.next != null || this.hasNext()) {
                this.lastReturned = this.next;
                this.next = null;
                return this.lastReturned;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.paths.remove();
            Files.deleteIfExists(this.lastReturned.getFile());
            this.lastReturned = null;
        }
    }
}

