/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.batched;

import io.appulse.utils.LimitedQueue;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import lombok.NonNull;
import org.infobip.lib.popout.FileQueue;
import org.infobip.lib.popout.QueueLimit;
import org.infobip.lib.popout.ReadWriteBytesPool;
import org.infobip.lib.popout.backend.FileSystemBackend;
import org.infobip.lib.popout.backend.WalContent;
import org.infobip.lib.popout.batched.BatchedFileQueueBuilder;
import org.infobip.lib.popout.batched.QueueSerializer;

class BatchedFileQueue<T>
extends FileQueue<T> {
    private final LongAdder size;
    private final Queue<T> tail;
    private final FileSystemBackend backend;
    private Queue<T> head;
    private final QueueSerializer<T> queueSerializer;
    private final QueueLimit<T> limit;
    private final Lock writeLock;
    private final Lock readLock;

    BatchedFileQueue(@NonNull BatchedFileQueueBuilder<T> builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked @NonNull but is null");
        }
        this.backend = FileSystemBackend.builder().queueName(builder.getName()).restoreFromDisk(builder.isRestoreFromDisk()).walConfig(builder.getWalFilesConfig()).compressedConfig(builder.getCompressedFilesConfig()).corruptionHandler(builder.getCorruptionHandler()).build();
        this.queueSerializer = QueueSerializer.builder().serializer(builder.getSerializer()).deserializer(builder.getDeserializer()).build();
        this.size = new LongAdder();
        this.head = new LinkedList<T>();
        this.tail = new LimitedQueue(builder.getBatchSize());
        for (WalContent walContent : this.backend) {
            int length = this.queueSerializer.getQueueLength(walContent);
            this.size.add(length);
        }
        this.limit = builder.getLimit();
        this.writeLock = new ReentrantLock(true);
        this.readLock = new ReentrantLock(true);
    }

    @Override
    public boolean offer(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        if (this.limit.isExceeded(this)) {
            this.limit.handle(value, this);
            return false;
        }
        this.writeLock.lock();
        try {
            if (this.tail.offer(value)) {
                this.size.increment();
                boolean bl = true;
                return bl;
            }
            this.flush();
            this.tail.add(value);
            this.size.increment();
        }
        finally {
            this.writeLock.unlock();
        }
        return true;
    }

    @Override
    public T poll() {
        Object result = this.doOn(Queue::poll);
        if (result != null) {
            this.size.decrement();
        }
        return (T)result;
    }

    @Override
    public T peek() {
        return (T)this.doOn(Queue::peek);
    }

    @Override
    public int size() {
        return this.size.intValue();
    }

    @Override
    public long longSize() {
        return this.size.longValue();
    }

    @Override
    public long diskSize() {
        return this.backend.diskSize();
    }

    @Override
    public void flush() {
        this.writeLock.lock();
        try {
            if (this.tail.isEmpty()) {
                return;
            }
            ReadWriteBytesPool.getInstance().borrow(buffer -> {
                this.queueSerializer.serialize(this.tail, buffer);
                this.backend.write(buffer);
                return null;
            });
            this.tail.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void compress() {
        this.writeLock.lock();
        try {
            this.backend.compress();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new BatchedFileQueueIterator();
    }

    @Override
    public void close() {
        this.flush();
        this.backend.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T doOn(Function<Queue<T>, T> extractor) {
        this.readLock.lock();
        try {
            Object object;
            T result = extractor.apply(this.head);
            if (result != null) {
                T t = result;
                return t;
            }
            this.writeLock.lock();
            try {
                object = ReadWriteBytesPool.getInstance().borrow(buffer -> {
                    if (this.backend.pollTo(buffer) <= 0) {
                        return extractor.apply(this.tail);
                    }
                    this.head = this.queueSerializer.deserialize(buffer);
                    return extractor.apply(this.head);
                });
                this.writeLock.unlock();
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
            return (T)object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private class BackendIterator
    implements Iterator<T> {
        Iterator<WalContent> walContentsIterator;
        Iterator<T> elements;

        private BackendIterator() {
            this.walContentsIterator = BatchedFileQueue.this.backend.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.elements == null || !this.elements.hasNext()) {
                if (!this.walContentsIterator.hasNext()) {
                    return false;
                }
                WalContent walContent = this.walContentsIterator.next();
                this.elements = BatchedFileQueue.this.queueSerializer.toIterator(walContent);
            }
            return this.elements.hasNext();
        }

        @Override
        public T next() {
            return this.elements.next();
        }

        @Override
        public void remove() {
            this.elements.remove();
        }
    }

    private class BatchedFileQueueIterator
    implements Iterator<T> {
        Iterator<T> current;
        Iterator<T> backendIterator;
        Iterator<T> tailIterator;

        private BatchedFileQueueIterator() {
            this.current = BatchedFileQueue.this.head.iterator();
            this.backendIterator = new BackendIterator();
            this.tailIterator = BatchedFileQueue.this.tail.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.current.hasNext()) {
                return true;
            }
            if (this.backendIterator.hasNext()) {
                this.current = this.backendIterator;
                return true;
            }
            if (this.tailIterator.hasNext()) {
                this.current = this.tailIterator;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            return this.current.next();
        }

        @Override
        public void remove() {
            this.current.remove();
            BatchedFileQueue.this.size.decrement();
        }
    }
}

