/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.exception;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.util.Locale;
import org.infobip.lib.popout.exception.ReadingFromDiskException;

public class CorruptedDataException
extends ReadingFromDiskException {
    private static final long serialVersionUID = -897411999655926422L;
    private final long offset;

    private static String getDefaultMessage(Path file, long offset) {
        return String.format(Locale.ENGLISH, "Corrupted data in file '%s' at position %d", file.toAbsolutePath().toString(), offset);
    }

    public CorruptedDataException(Path file, long offset) {
        this(file, offset, CorruptedDataException.getDefaultMessage(file, offset));
    }

    public CorruptedDataException(Path file, long offset, String message) {
        super(file, message);
        this.offset = offset;
    }

    public CorruptedDataException(Path file, long offset, Throwable throwable) {
        this(file, offset, CorruptedDataException.getDefaultMessage(file, offset), throwable);
    }

    public CorruptedDataException(Path file, long offset, String message, Throwable throwable) {
        super(file, message, throwable);
        this.offset = offset;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getOffset() {
        return this.offset;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "CorruptedDataException(offset=" + this.getOffset() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CorruptedDataException)) {
            return false;
        }
        CorruptedDataException other = (CorruptedDataException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getOffset() == other.getOffset();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof CorruptedDataException;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        return result;
    }
}

