/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.exception;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.util.Locale;

public class ReadingFromDiskException
extends RuntimeException {
    private static final long serialVersionUID = 1897411999655926132L;
    private final Path file;

    private static String getDefaultMessage(Path file) {
        return String.format(Locale.ENGLISH, "Error during reading file's '%s' content", file.toAbsolutePath().toString());
    }

    public ReadingFromDiskException(Path file) {
        this(file, ReadingFromDiskException.getDefaultMessage(file));
    }

    public ReadingFromDiskException(Path file, String message) {
        super(message);
        this.file = file;
    }

    public ReadingFromDiskException(Path file, Throwable throwable) {
        super(ReadingFromDiskException.getDefaultMessage(file), throwable);
        this.file = file;
    }

    public ReadingFromDiskException(Path file, String message, Throwable throwable) {
        super(message, throwable);
        this.file = file;
    }

    @SuppressFBWarnings(justification="generated code")
    public Path getFile() {
        return this.file;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ReadingFromDiskException(file=" + this.getFile() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadingFromDiskException)) {
            return false;
        }
        ReadingFromDiskException other = (ReadingFromDiskException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Path this$file = this.getFile();
        Path other$file = other.getFile();
        return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ReadingFromDiskException;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Path $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        return result;
    }
}

