/*
 * Decompiled with CFR 0.152.
 */
package oneapi.examples.smsmessaging;

import oneapi.PropertyLoader;
import oneapi.client.impl.SMSClient;
import oneapi.config.Configuration;
import oneapi.listener.DeliveryStatusNotificationsListener;
import oneapi.model.DeliveryInfoNotification;
import oneapi.model.SMSRequest;
import oneapi.model.SubscribeToDeliveryNotificationsRequest;
import org.apache.log4j.BasicConfigurator;

public class SendSMS_Subscribe_WaitForDeliveryStatusPush {
    private static final String USERNAME = PropertyLoader.loadProperty("example.properties", "username");
    private static final String PASSWORD = PropertyLoader.loadProperty("example.properties", "password");
    private static String SENDER = PropertyLoader.loadProperty("example.properties", "sender");
    private static final String DESTINATION = PropertyLoader.loadProperty("example.properties", "destination");
    private static final String MESSAGE = PropertyLoader.loadProperty("example.properties", "message");
    private static String NOTIFY_URL = "http://127.0.0.1:3000/";
    private static String CRITERIA = "SomeCriteria";

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        Configuration configuration = new Configuration(USERNAME, PASSWORD);
        SMSClient smsClient = new SMSClient(configuration);
        smsClient.getSMSMessagingClient().addPushDeliveryStatusNotificationListener(new DeliveryStatusNotificationsListener(){

            public void onDeliveryStatusNotificationReceived(DeliveryInfoNotification deliveryInfoNotification) {
                if (deliveryInfoNotification != null) {
                    String deliveryStatus = deliveryInfoNotification.getDeliveryInfo().getDeliveryStatus();
                    System.out.println(deliveryStatus);
                }
            }
        });
        String subscriptionId = smsClient.getSMSMessagingClient().subscribeToDeliveryStatusNotifications(new SubscribeToDeliveryNotificationsRequest(SENDER, NOTIFY_URL, CRITERIA, "", ""));
        smsClient.getSMSMessagingClient().sendSMS(new SMSRequest(SENDER, CRITERIA + MESSAGE, new String[]{DESTINATION}));
        Thread.sleep(30000L);
        smsClient.getSMSMessagingClient().removeDeliveryNotificationsSubscription(subscriptionId);
        smsClient.getSMSMessagingClient().removePushDeliveryStatusNotificationListeners();
    }
}

