/*
 * Decompiled with CFR 0.152.
 */
package oneapi.examples.smsmessaging;

import oneapi.PropertyLoader;
import oneapi.client.impl.SMSClient;
import oneapi.config.Configuration;
import oneapi.listener.DeliveryStatusNotificationsListener;
import oneapi.model.DeliveryInfoNotification;
import oneapi.model.SMSRequest;
import org.apache.log4j.BasicConfigurator;

public class SendSMS_WaitForDeliveryStatusPush {
    private static final String USERNAME = PropertyLoader.loadProperty("example.properties", "username");
    private static final String PASSWORD = PropertyLoader.loadProperty("example.properties", "password");
    private static String SENDER = PropertyLoader.loadProperty("example.properties", "sender");
    private static final String DESTINATION = PropertyLoader.loadProperty("example.properties", "destination");
    private static final String MESSAGE = PropertyLoader.loadProperty("example.properties", "message");
    private static final String NOTIFY_URL = "http://127.0.0.1:3000/";

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        Configuration configuration = new Configuration(USERNAME, PASSWORD);
        SMSClient smsClient = new SMSClient(configuration);
        smsClient.getSMSMessagingClient().addPushDeliveryStatusNotificationListener(new DeliveryStatusNotificationsListener(){

            public void onDeliveryStatusNotificationReceived(DeliveryInfoNotification deliveryInfoNotification) {
                if (deliveryInfoNotification != null) {
                    String deliveryStatus = deliveryInfoNotification.getDeliveryInfo().getDeliveryStatus();
                    System.out.println(deliveryStatus);
                }
            }
        });
        SMSRequest smsRequest = new SMSRequest(SENDER, MESSAGE, new String[]{DESTINATION});
        smsRequest.setNotifyURL(NOTIFY_URL);
        smsClient.getSMSMessagingClient().sendSMS(smsRequest);
        Thread.sleep(30000L);
        smsClient.getSMSMessagingClient().removePushDeliveryStatusNotificationListeners();
    }
}

