/*
 * Decompiled with CFR 0.152.
 */
package oneapi.test;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class OneAPIServerSimulator
implements Runnable {
    private int port = 8080;
    private boolean running = true;
    private ServerSocket server;
    private List<String> requests = new ArrayList<String>();
    private String postRequest;
    private String response = "dummy response";

    public OneAPIServerSimulator(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.server == null) {
                this.server = new ServerSocket(this.port);
            }
            while (this.running) {
                Socket connection = null;
                try {
                    connection = this.server.accept();
                    String request = this.getRequest(connection);
                    this.requests.add(request);
                    int postlen = this.parseContentLength(request);
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    char[] posted = new char[postlen];
                    in.read(posted, 0, postlen);
                    this.postRequest = new String(posted);
                    System.out.println(this.postRequest);
                    BufferedOutputStream out = new BufferedOutputStream(connection.getOutputStream());
                    if (request.startsWith("POST")) {
                        ((OutputStream)out).write("HTTP/1.1 201 OK\r\nContent-Type: application/json;charset=UTF-8\r\nConnection: close\r\n\r\n".getBytes());
                    } else if (request.startsWith("GET")) {
                        ((OutputStream)out).write("HTTP/1.1 200 OK\r\nContent-Type: application/json;charset=UTF-8\r\nConnection: close\r\n\r\n".getBytes());
                    } else if (request.startsWith("DELETE")) {
                        ((OutputStream)out).write("HTTP/1.1 204 OK\r\nConnection: close\r\n\r\n".getBytes());
                    }
                    ((OutputStream)out).write(this.response.getBytes());
                    ((OutputStream)out).flush();
                    in.close();
                }
                catch (IOException ex) {
                    if (this.server.isClosed()) continue;
                    ex.printStackTrace();
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
        }
        catch (IOException e) {
            System.err.println("Could not start server: " + e.getMessage());
        }
    }

    private int parseContentLength(String request) {
        int position = request.indexOf("Content-Length:");
        if (position == -1) {
            return 0;
        }
        String contentLength = request.substring(position);
        contentLength = contentLength.split(" ")[1];
        contentLength = contentLength.split("\r\n")[0];
        return Integer.valueOf(contentLength);
    }

    private String getRequest(Socket connection) throws IOException {
        int i;
        InputStream in = connection.getInputStream();
        StringBuilder request = new StringBuilder();
        while ((i = in.read()) != -1) {
            request.append((char)i);
            if (!request.toString().endsWith("\r\n\r\n") && !request.toString().endsWith("\n\n")) continue;
            return request.toString();
        }
        return request.toString();
    }

    public void release() {
        try {
            this.running = false;
            try {
                Thread.sleep(100L);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (this.server != null && !this.server.isClosed()) {
                this.server.close();
            }
        }
        catch (IOException e) {
            System.err.println("Could not release server:" + e.getMessage());
        }
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public List<String> getRequests() {
        return this.requests;
    }

    public String getPostRequest() {
        return this.postRequest;
    }
}

