/*
 * Decompiled with CFR 0.152.
 */
package oneapi.test;

import java.util.ArrayList;
import oneapi.client.impl.SMSClient;
import oneapi.config.Configuration;
import oneapi.exception.RequestException;
import oneapi.model.SMSRequest;
import oneapi.model.SendMessageResult;
import oneapi.model.SubscribeToDeliveryNotificationsRequest;
import oneapi.model.SubscribeToInboundMessagesRequest;
import oneapi.model.common.DeliveryInfoList;
import oneapi.model.common.DeliveryReceiptSubscription;
import oneapi.model.common.DeliveryReportSubscription;
import oneapi.model.common.InboundSMSMessage;
import oneapi.model.common.InboundSMSMessageList;
import oneapi.model.common.ResourceReferenceWrapper;
import oneapi.test.OneAPIServerSimulator;
import oneapi.test.TestJsonProvider;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestOneAPI {
    public static final int SERVERPORT = 8080;
    public static final String URL = "http://localhost:8080";
    public static final String ONEAPI_VERSION = "1";
    public static final String USERNAME = "simple";
    public static final String PASSWORD = "simple";
    public static final String SENDER_ADDRESS = "TestSender";
    public static final String DESTINATION_ADDRESS = "TestDestination";
    public static final String RECIPIENT_ADDRESS = "1111";
    public static final String MESSAGE_TEXT = "TestMessageText";
    public static final String CLIENT_CORRELATOR = "TestClientCorrelator";
    public static final String NOTIFY_URL = "http://TestNotifyUrl";
    public static final String SENDER_NAME = "TestSenderName";
    public static final String CALLBACK_DATA = "TestCallbackData";
    public static final String REQUEST_ID = "TestRequestId";
    public static final String SUBSCRIPTION_ID = "TestSubscriptionId";
    public static final String CRITERIA = "TestCriteria";
    public static final String NOTIFICATION_FORMAT = "TestNotificationFormat";
    public static final String MESSAGE_ID = "ID1";
    private static SMSClient client = null;
    private static OneAPIServerSimulator server = null;

    @BeforeClass
    public static void startSimulator() throws Exception {
        server = new OneAPIServerSimulator(8080);
        new Thread(server).start();
        client = new SMSClient(TestOneAPI.createOneAPIConfig());
    }

    @AfterClass
    public static void stopSimulator() {
        server.release();
        server = null;
        client = null;
    }

    @Test
    public void testSendSimpleSMS() {
        server.setResponse(TestOneAPI.getResourceReferenceJson());
        ResourceReferenceWrapper resourceReferenceWrapper = TestOneAPI.getResourceReferenceWrapper();
        SendMessageResult response = null;
        SMSRequest smsRequest = new SMSRequest(SENDER_ADDRESS, MESSAGE_TEXT, new String[]{RECIPIENT_ADDRESS});
        try {
            response = client.getSMSMessagingClient().sendSMS(smsRequest);
        }
        catch (RequestException e) {
            Assert.fail((String)("Error occured while trying to send the message. Err: " + e.getMessage()));
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)resourceReferenceWrapper.getResourceReference().getResourceURL(), (Object)response.getResourceReference().getResourceURL());
        Assert.assertEquals((Object)"{\"senderAddress\":\"TestSender\",\"address\":[\"1111\"],\"message\":\"TestMessageText\",\"clientCorrelator\":null,\"notifyURL\":null,\"senderName\":null,\"callbackData\":null,\"language\":null}", (Object)server.getPostRequest());
    }

    @Test
    public void testSendMultipleSMS() {
        server.setResponse(TestOneAPI.getResourceReferenceJson());
        ResourceReferenceWrapper resourceReferenceWrapper = TestOneAPI.getResourceReferenceWrapper();
        SMSRequest sms = TestOneAPI.composeSms();
        SendMessageResult response = null;
        try {
            response = client.getSMSMessagingClient().sendSMS(sms);
        }
        catch (RequestException e) {
            Assert.fail((String)("Error occured while trying to send the message. Err: " + e.getMessage()));
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)resourceReferenceWrapper.getResourceReference().getResourceURL(), (Object)response.getResourceReference().getResourceURL());
        Assert.assertEquals((Object)"{\"senderAddress\":\"TestSender\",\"address\":[\"2222\",\"3333\",\"4444\",\"5555\"],\"message\":\"TestMessageText\",\"clientCorrelator\":\"TestClientCorrelator\",\"notifyURL\":\"http://TestNotifyUrl\",\"senderName\":\"TestSenderName\",\"callbackData\":\"TestCallbackData\",\"language\":null}", (Object)server.getPostRequest());
    }

    @Test
    public void testQueryDeliveryStatus() {
        server.setResponse(TestOneAPI.getDeliveryInfoListJson());
        DeliveryInfoList deliveryInfoList = TestOneAPI.getDeliveryInfoList();
        DeliveryInfoList response = null;
        try {
            response = client.getSMSMessagingClient().queryDeliveryStatus(SENDER_ADDRESS, REQUEST_ID);
        }
        catch (RequestException e) {
            Assert.fail((String)("Error occured while trying to query delivery status. Err: " + e.getMessage()));
        }
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getDeliveryInfo());
        Assert.assertNotNull(response.getDeliveryInfo().get(0));
        Assert.assertEquals((Object)deliveryInfoList.getResourceURL(), (Object)response.getResourceURL());
        Assert.assertEquals((Object)((DeliveryInfoList.DeliveryInfo)deliveryInfoList.getDeliveryInfo().get(0)).getAddress(), (Object)((DeliveryInfoList.DeliveryInfo)response.getDeliveryInfo().get(0)).getAddress());
        Assert.assertEquals((Object)((DeliveryInfoList.DeliveryInfo)deliveryInfoList.getDeliveryInfo().get(0)).getDeliveryStatus(), (Object)((DeliveryInfoList.DeliveryInfo)response.getDeliveryInfo().get(0)).getDeliveryStatus());
    }

    @Test
    public void subscribeToDeliveryNotificationsWithoutOptionalParams() {
        server.setResponse(TestOneAPI.getDeliveryReceiptSubscriptionJson());
        DeliveryReceiptSubscription deliveryReceiptSubscription = TestOneAPI.getDeliveryReceiptSubscription();
        String response = null;
        try {
            response = client.getSMSMessagingClient().subscribeToDeliveryStatusNotifications(new SubscribeToDeliveryNotificationsRequest(SENDER_ADDRESS, NOTIFY_URL));
        }
        catch (RequestException e) {
            Assert.fail((String)("Error occured while trying to subcribe to delivery notifications. Err: " + e.getMessage()));
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)this.GetIdFromResourceUrl(deliveryReceiptSubscription.getResourceURL()), (Object)response);
        Assert.assertEquals((Object)"{\"senderAddress\":\"TestSender\",\"notifyURL\":\"http://TestNotifyUrl\",\"criteria\":null,\"clientCorrelator\":null,\"callbackData\":null}", (Object)server.getPostRequest());
    }

    @Test
    public void subscribeToDeliveryNotificationsWithOptionalParams() {
        server.setResponse(TestOneAPI.getDeliveryReceiptSubscriptionJson());
        DeliveryReceiptSubscription deliveryReceiptSubscription = TestOneAPI.getDeliveryReceiptSubscription();
        String response = null;
        try {
            response = client.getSMSMessagingClient().subscribeToDeliveryStatusNotifications(new SubscribeToDeliveryNotificationsRequest(SENDER_ADDRESS, NOTIFY_URL, CRITERIA, CLIENT_CORRELATOR, CALLBACK_DATA));
        }
        catch (RequestException e) {
            Assert.fail((String)("Error occured while trying to subcribe to delivery notifications. Err: " + e.getMessage()));
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)this.GetIdFromResourceUrl(deliveryReceiptSubscription.getResourceURL()), (Object)response);
        Assert.assertEquals((Object)"{\"senderAddress\":\"TestSender\",\"notifyURL\":\"http://TestNotifyUrl\",\"criteria\":\"TestCriteria\",\"clientCorrelator\":\"TestClientCorrelator\",\"callbackData\":\"TestCallbackData\"}", (Object)server.getPostRequest());
    }

    @Test
    public void cancelDeliveryNotifications() {
        try {
            client.getSMSMessagingClient().removeDeliveryNotificationsSubscription(SUBSCRIPTION_ID);
        }
        catch (RequestException e) {
            Assert.fail((String)("Error occured while trying to cancel delivery notifications. Err: " + e.getMessage()));
        }
    }

    @Test
    public void getInboundMessages() {
        server.setResponse(TestOneAPI.getInboundSMSMessageListJson());
        InboundSMSMessageList inboundSMSMessageList = TestOneAPI.getInboundSMSMessageList();
        InboundSMSMessageList response = null;
        try {
            response = client.getSMSMessagingClient().getInboundMessages(100);
        }
        catch (RequestException e) {
            Assert.fail((String)("Error occured while trying to get inbound messages. Err: " + e.getMessage()));
        }
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getInboundSMSMessage()[0]);
        Assert.assertEquals((Object)inboundSMSMessageList.getResourceURL(), (Object)response.getResourceURL());
        Assert.assertEquals((Object)inboundSMSMessageList.getNumberOfMessagesInThisBatch(), (Object)response.getNumberOfMessagesInThisBatch());
        Assert.assertEquals((Object)inboundSMSMessageList.getTotalNumberOfPendingMessages(), (Object)response.getTotalNumberOfPendingMessages());
        Assert.assertEquals((Object)inboundSMSMessageList.getInboundSMSMessage()[0].getSenderAddress(), (Object)response.getInboundSMSMessage()[0].getSenderAddress());
        Assert.assertEquals((Object)inboundSMSMessageList.getInboundSMSMessage()[0].getDestinationAddress(), (Object)response.getInboundSMSMessage()[0].getDestinationAddress());
        Assert.assertEquals((Object)inboundSMSMessageList.getInboundSMSMessage()[0].getMessage(), (Object)response.getInboundSMSMessage()[0].getMessage());
        Assert.assertEquals((Object)inboundSMSMessageList.getInboundSMSMessage()[0].getMessageId(), (Object)response.getInboundSMSMessage()[0].getMessageId());
    }

    @Test
    public void subscribeToReceiptNotificationsWithoutOptionalParams() {
        server.setResponse(TestOneAPI.getResourceReferenceJson());
        ResourceReferenceWrapper resourceReferenceWrapper = TestOneAPI.getResourceReferenceWrapper();
        String response = null;
        try {
            response = client.getSMSMessagingClient().subscribeToInboundMessagesNotifications(new SubscribeToInboundMessagesRequest(DESTINATION_ADDRESS, NOTIFY_URL));
        }
        catch (RequestException e) {
            Assert.fail((String)("Error occured while trying to subcribe to receipt notifications. Err: " + e.getMessage()));
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)this.GetIdFromResourceUrl(resourceReferenceWrapper.getResourceReference().getResourceURL()), (Object)response);
        Assert.assertEquals((Object)"{\"destinationAddress\":\"TestDestination\",\"notifyURL\":\"http://TestNotifyUrl\",\"criteria\":null,\"notificationFormat\":null,\"clientCorrelator\":null,\"callbackData\":null}", (Object)server.getPostRequest());
    }

    @Test
    public void subscribeToReceiptNotificationsWithOptionalParams() {
        server.setResponse(TestOneAPI.getResourceReferenceJson());
        ResourceReferenceWrapper resourceReferenceWrapper = TestOneAPI.getResourceReferenceWrapper();
        String response = null;
        try {
            response = client.getSMSMessagingClient().subscribeToInboundMessagesNotifications(new SubscribeToInboundMessagesRequest(DESTINATION_ADDRESS, NOTIFY_URL, CRITERIA, NOTIFICATION_FORMAT, CLIENT_CORRELATOR, CALLBACK_DATA));
        }
        catch (RequestException e) {
            Assert.fail((String)("Error occured while trying to subcribe to receipt notifications. Err: " + e.getMessage()));
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)this.GetIdFromResourceUrl(resourceReferenceWrapper.getResourceReference().getResourceURL()), (Object)response);
        Assert.assertEquals((Object)"{\"destinationAddress\":\"TestDestination\",\"notifyURL\":\"http://TestNotifyUrl\",\"criteria\":\"TestCriteria\",\"notificationFormat\":\"TestNotificationFormat\",\"clientCorrelator\":\"TestClientCorrelator\",\"callbackData\":\"TestCallbackData\"}", (Object)server.getPostRequest());
    }

    @Test
    public void cancelReceiptNotifications() {
        int response = 0;
        try {
            client.getSMSMessagingClient().removeInboundMessagesSubscription(SUBSCRIPTION_ID);
        }
        catch (RequestException e) {
            Assert.fail((String)("Error occured while trying to receipt notificationss. Err: " + e.getMessage()));
        }
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void getDLRSubscriptions() {
        server.setResponse(TestOneAPI.getDlrSubscriptionsJson());
        DeliveryReportSubscription[] deliveryReportSubscriptions = TestOneAPI.getDlrSubscriptions();
        try {
            DeliveryReportSubscription[] response = client.getSMSMessagingClient().getDeliveryNotificationsSubscriptionsBySender(SENDER_ADDRESS);
            Assert.assertNotNull((Object)response);
            Assert.assertTrue((response.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)deliveryReportSubscriptions[0].getCallbackData(), (Object)response[0].getCallbackData());
            Assert.assertEquals((Object)deliveryReportSubscriptions[0].getCriteria(), (Object)response[0].getCriteria());
            Assert.assertEquals((Object)deliveryReportSubscriptions[0].getNotifyUrl(), (Object)response[0].getNotifyUrl());
            Assert.assertEquals((Object)deliveryReportSubscriptions[0].getSenderAddress(), (Object)response[0].getSenderAddress());
            Assert.assertEquals((Object)deliveryReportSubscriptions[0].getSubscriptionId(), (Object)response[0].getSubscriptionId());
        }
        catch (Exception e) {
            Assert.fail((String)("Error occured while trying to get DLR subscriptions for specified mobile terminal. Err: " + e.getMessage()));
        }
    }

    private static Configuration createOneAPIConfig() {
        Configuration config = new Configuration(URL, "simple", ONEAPI_VERSION, "simple");
        return config;
    }

    private static SMSRequest composeSms() {
        String[] address = new String[]{"2222", "3333", "4444", "5555"};
        SMSRequest sms = new SMSRequest(SENDER_ADDRESS, MESSAGE_TEXT, address);
        sms.setClientCorrelator(CLIENT_CORRELATOR);
        sms.setNotifyURL(NOTIFY_URL);
        sms.setSenderName(SENDER_NAME);
        sms.setCallbackData(CALLBACK_DATA);
        return sms;
    }

    public static String getDlrSubscriptionsJson() {
        return TestJsonProvider.convertToJson(TestJsonProvider.getEntityWithRoot("deliveryReceiptSubscriptions", TestOneAPI.getDlrSubscriptions()));
    }

    private static DeliveryReportSubscription[] getDlrSubscriptions() {
        DeliveryReportSubscription[] deliveryReportSubscriptions = new DeliveryReportSubscription[1];
        DeliveryReportSubscription deliveryReportSubscription = new DeliveryReportSubscription();
        deliveryReportSubscription.setSubscriptionId(REQUEST_ID);
        deliveryReportSubscription.setCallbackData(CRITERIA);
        deliveryReportSubscription.setNotifyUrl(NOTIFY_URL);
        deliveryReportSubscription.setSenderAddress(SENDER_ADDRESS);
        deliveryReportSubscriptions[0] = deliveryReportSubscription;
        return deliveryReportSubscriptions;
    }

    private static ResourceReferenceWrapper getResourceReferenceWrapper() {
        ResourceReferenceWrapper resourceReferenceWrapper = new ResourceReferenceWrapper("http://example.com/1/smsmessaging/outbound/tel%3A%2B12345678/requests/abc123");
        return resourceReferenceWrapper;
    }

    private static String getResourceReferenceJson() {
        return TestJsonProvider.convertToJson(TestOneAPI.getResourceReferenceWrapper());
    }

    private static DeliveryReceiptSubscription getDeliveryReceiptSubscription() {
        DeliveryReceiptSubscription deliveryReceiptSubscription = new DeliveryReceiptSubscription();
        deliveryReceiptSubscription.setResourceURL("http://example.com/1/smsmessaging/outbound/tel%3A%2B12345678/requests/abc123");
        deliveryReceiptSubscription.setCallbackReference(new DeliveryReceiptSubscription.CallbackReference());
        return deliveryReceiptSubscription;
    }

    private static String getDeliveryReceiptSubscriptionJson() {
        return TestJsonProvider.convertToJson(TestJsonProvider.getEntityWithRoot("deliveryReceiptSubscription", TestOneAPI.getDeliveryReceiptSubscription()));
    }

    private static DeliveryInfoList getDeliveryInfoList() {
        DeliveryInfoList deliveryInfoList = new DeliveryInfoList();
        deliveryInfoList.setResourceURL("http://example.com/1/smsmessaging/outbound/38595111111111111/requests/abc123");
        DeliveryInfoList.DeliveryInfo deliveryInfo = new DeliveryInfoList.DeliveryInfo();
        deliveryInfo.setDeliveryStatus("DELIVERED");
        deliveryInfo.setAddress("38595111111111111");
        ArrayList<DeliveryInfoList.DeliveryInfo> newList = new ArrayList<DeliveryInfoList.DeliveryInfo>();
        newList.add(deliveryInfo);
        deliveryInfoList.setDeliveryInfo(newList);
        return deliveryInfoList;
    }

    private static String getDeliveryInfoListJson() {
        return TestJsonProvider.convertToJson(TestJsonProvider.getEntityWithRoot("deliveryInfoList", TestOneAPI.getDeliveryInfoList()));
    }

    private static InboundSMSMessageList getInboundSMSMessageList() {
        InboundSMSMessageList inboundSMSMessageList = new InboundSMSMessageList();
        InboundSMSMessage[] inboundSMSMessages = new InboundSMSMessage[1];
        InboundSMSMessage inboundSMSMessage = new InboundSMSMessage();
        inboundSMSMessage.setMessage(MESSAGE_TEXT);
        inboundSMSMessage.setMessageId(MESSAGE_ID);
        inboundSMSMessage.setResourceURL("");
        inboundSMSMessage.setSenderAddress(SENDER_ADDRESS);
        inboundSMSMessages[0] = inboundSMSMessage;
        inboundSMSMessageList.setInboundSMSMessage(inboundSMSMessages);
        inboundSMSMessageList.setNumberOfMessagesInThisBatch(Integer.valueOf(1));
        inboundSMSMessageList.setTotalNumberOfPendingMessages(Integer.valueOf(0));
        inboundSMSMessageList.setResourceURL("http://example.com/1/smsmessaging/outbound/38595111111111111/requests/abc123");
        return inboundSMSMessageList;
    }

    private static String getInboundSMSMessageListJson() {
        return TestJsonProvider.convertToJson(TestJsonProvider.getEntityWithRoot("inboundSMSMessageList", TestOneAPI.getInboundSMSMessageList()));
    }

    protected String GetIdFromResourceUrl(String resourceUrl) {
        String[] arrResourceUrl;
        String id = "";
        if (resourceUrl.contains("/") && (arrResourceUrl = resourceUrl.split("/")).length > 0) {
            id = arrResourceUrl[arrResourceUrl.length - 1];
        }
        return id;
    }
}

